/**
 * 
 */
package org.gcube.portlets.user.td.client.ribbon;

import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.RibbonEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.UIStateEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.RibbonType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.UIStateType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.ButtonArrowAlign;
import com.sencha.gxt.cell.core.client.ButtonCell.ButtonScale;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.core.client.dom.XElement;
import com.sencha.gxt.widget.core.client.button.ButtonGroup;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class CurationToolBar {

	protected EventBus eventBus;
	protected ToolBar toolBar;

	protected TextButton duplicateDetectionButton;
	//protected TextButton rulesButton;
	//protected TextButton manageRulesButton;
	protected TextButton applyTemplateButton;
	protected TextButton normalizeButton;
	protected TextButton denormalizeButton;
	protected TextButton changeColumnLabelButton;
	protected TextButton columnTypeButton;
	protected TextButton tableTypeButton;
	protected TextButton addColumnButton;
	protected TextButton deleteColumnButton;
	protected TextButton splitColumnButton;
	protected TextButton mergeColumnButton;

	
	protected TextButton extractCodelistButton;
	protected TextButton codelistMappingButton;
	//protected TextButton generateSummaryButton;

	public CurationToolBar(EventBus eventBus) {
		this.eventBus = eventBus;
		build();
	}

	public ToolBar getToolBar() {
		return toolBar;
	}

	protected void build() {
		toolBar = new ToolBar();
		toolBar.setSpacing(1);
		toolBar.setEnableOverflow(false);

		// Validation
		ButtonGroup validationGroup = new ButtonGroup();
		validationGroup.setId("Validation");
		validationGroup.setStyleName("ribbon");
		validationGroup.setHeadingText("Validation");
		validationGroup.enable();
		toolBar.add(validationGroup);

		FlexTable validationLayout = new FlexTable();
		validationGroup.add(validationLayout);
		/*
		rulesButton = new TextButton("New Rule",
				TabularDataResources.INSTANCE.ruleAdd32());
		rulesButton.disable();
		rulesButton.setScale(ButtonScale.LARGE);
		rulesButton.setIconAlign(IconAlign.TOP);
		rulesButton.setToolTip("Define a new validation rule");
		rulesButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		rulesButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.RULENEW));
			}
		});

		validationLayout.setWidget(0, 1, rulesButton);
		validationLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);
		
		manageRulesButton = new TextButton("Manage Rules",
				TabularDataResources.INSTANCE.wrenchManage32());
		manageRulesButton.disable();
		manageRulesButton.setScale(ButtonScale.LARGE);
		manageRulesButton.setIconAlign(IconAlign.TOP);
		manageRulesButton.setToolTip("View defined rules and apply");
		manageRulesButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		manageRulesButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.RULEMANAGE));
			}
		});
		
		validationLayout.setWidget(0, 2, manageRulesButton);
		validationLayout.getFlexCellFormatter().setRowSpan(0, 2, 2);
		 */
		
		duplicateDetectionButton = new TextButton("Duplicate Detection",
				TabularDataResources.INSTANCE.tableDuplicateRows32());
		duplicateDetectionButton.disable();
		duplicateDetectionButton.setScale(ButtonScale.LARGE);
		duplicateDetectionButton.setIconAlign(IconAlign.TOP);
		duplicateDetectionButton
				.setToolTip("Detects duplicate lines in the table");
		duplicateDetectionButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		duplicateDetectionButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(
						RibbonType.DUPLICATEDETECTION));
			}
		});

		validationLayout.setWidget(0, 0, duplicateDetectionButton);
		validationLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		applyTemplateButton = new TextButton("Apply Template",
				TabularDataResources.INSTANCE.templateApply32());
		applyTemplateButton.disable();
		applyTemplateButton.setScale(ButtonScale.LARGE);
		applyTemplateButton.setIconAlign(IconAlign.TOP);
		applyTemplateButton.setToolTip("Apply Template");
		applyTemplateButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		applyTemplateButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.TEMPLATEAPPLY));
			}
		});

		validationLayout.setWidget(0, 1, applyTemplateButton);
		validationLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);

		cleanCells(validationLayout.getElement());

		// Structure
		ButtonGroup structureGroup = new ButtonGroup();
		structureGroup.setId("Structure");
		structureGroup.setStyleName("ribbon");
		structureGroup.setHeadingText("Structure");
		structureGroup.enable();
		toolBar.add(structureGroup);

		FlexTable structureLayout = new FlexTable();
		structureGroup.add(structureLayout);

		tableTypeButton = new TextButton("Table Type",
				TabularDataResources.INSTANCE.tableType32());
		tableTypeButton.setScale(ButtonScale.LARGE);
		tableTypeButton.disable();
		tableTypeButton.setIconAlign(IconAlign.TOP);
		tableTypeButton.setToolTip("Change table type");
		tableTypeButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		tableTypeButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.TABLETYPE));
			}
		});

		structureLayout.setWidget(0, 0, tableTypeButton);
		structureLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		changeColumnLabelButton = new TextButton("Labels",
				TabularDataResources.INSTANCE.columnLabel32());
		changeColumnLabelButton.disable();
		changeColumnLabelButton.setScale(ButtonScale.LARGE);
		changeColumnLabelButton.setIconAlign(IconAlign.TOP);
		changeColumnLabelButton.setToolTip("Change column labels");
		changeColumnLabelButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		changeColumnLabelButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.COLUMNLABEL));
			}
		});

		structureLayout.setWidget(0, 1, changeColumnLabelButton);
		structureLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);

		columnTypeButton = new TextButton("Column Type",
				TabularDataResources.INSTANCE.columnType32());
		columnTypeButton.disable();
		columnTypeButton.setScale(ButtonScale.LARGE);
		columnTypeButton.setIconAlign(IconAlign.TOP);
		columnTypeButton.setToolTip("Change column type");
		columnTypeButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		columnTypeButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.COLUMNTYPE));
			}
		});

		structureLayout.setWidget(0, 2, columnTypeButton);
		structureLayout.getFlexCellFormatter().setRowSpan(0, 2, 2);

		addColumnButton = new TextButton("Add Column",
				TabularDataResources.INSTANCE.columnAdd32());
		addColumnButton.disable();
		addColumnButton.setScale(ButtonScale.LARGE);
		addColumnButton.setIconAlign(IconAlign.TOP);
		addColumnButton.setToolTip("Add column");
		addColumnButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		addColumnButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.COLUMNADD));
			}
		});

		structureLayout.setWidget(0, 3, addColumnButton);
		structureLayout.getFlexCellFormatter().setRowSpan(0, 3, 2);

		deleteColumnButton = new TextButton("Delete Column",
				TabularDataResources.INSTANCE.columnDelete32());
		deleteColumnButton.disable();
		deleteColumnButton.setScale(ButtonScale.LARGE);
		deleteColumnButton.setIconAlign(IconAlign.TOP);
		deleteColumnButton.setToolTip("Delete column");
		deleteColumnButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		deleteColumnButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.COLUMNDELETE));
			}
		});

		structureLayout.setWidget(0, 4, deleteColumnButton);
		structureLayout.getFlexCellFormatter().setRowSpan(0, 4, 2);
		
		//
		splitColumnButton = new TextButton("Split Column",
				TabularDataResources.INSTANCE.columnSplit32());
		splitColumnButton.disable();
		splitColumnButton.setScale(ButtonScale.LARGE);
		splitColumnButton.setIconAlign(IconAlign.TOP);
		splitColumnButton.setToolTip("Split Column");
		splitColumnButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		splitColumnButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.COLUMNSPLIT));
			}
		});

		structureLayout.setWidget(0, 5, splitColumnButton);
		structureLayout.getFlexCellFormatter().setRowSpan(0, 5, 2);

		mergeColumnButton = new TextButton("Merge Column",
				TabularDataResources.INSTANCE.columnMerge32());
		mergeColumnButton.disable();
		mergeColumnButton.setScale(ButtonScale.LARGE);
		mergeColumnButton.setIconAlign(IconAlign.TOP);
		mergeColumnButton.setToolTip("Merge Column");
		mergeColumnButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		mergeColumnButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.COLUMNMERGE));
			}
		});

		structureLayout.setWidget(0, 6, mergeColumnButton);
		structureLayout.getFlexCellFormatter().setRowSpan(0, 6, 2);
		//
		
		denormalizeButton = new TextButton("Denormalize",
				TabularDataResources.INSTANCE.tableDenormalize32());
		denormalizeButton.disable();
		denormalizeButton.setScale(ButtonScale.LARGE);
		denormalizeButton.setIconAlign(IconAlign.TOP);
		denormalizeButton.setToolTip("Denormalize table");
		denormalizeButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		denormalizeButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.DENORMALIZE));
			}
		});

		structureLayout.setWidget(0, 7, denormalizeButton);
		structureLayout.getFlexCellFormatter().setRowSpan(0, 7, 2);

		normalizeButton = new TextButton("Normalize",
				TabularDataResources.INSTANCE.tableNormalize32());
		normalizeButton.disable();
		normalizeButton.setScale(ButtonScale.LARGE);
		normalizeButton.setIconAlign(IconAlign.TOP);
		normalizeButton.setToolTip("Normalize");
		normalizeButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		normalizeButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.NORMALIZE));
			}
		});

		structureLayout.setWidget(0, 8, normalizeButton);
		structureLayout.getFlexCellFormatter().setRowSpan(0, 8, 2);
		
		cleanCells(structureLayout.getElement());

		// Helper
		ButtonGroup helperGroup = new ButtonGroup();
		helperGroup.setId("Helper");
		helperGroup.setStyleName("ribbon");
		helperGroup.setHeadingText("Helper");
		helperGroup.enable();
		toolBar.add(helperGroup);

		FlexTable helperLayout = new FlexTable();
		helperGroup.add(helperLayout);

		extractCodelistButton = new TextButton("Extract Codelist",
				TabularDataResources.INSTANCE.codelist32());
		extractCodelistButton.disable();
		extractCodelistButton.setScale(ButtonScale.LARGE);
		extractCodelistButton.setIconAlign(IconAlign.TOP);
		extractCodelistButton.setToolTip("Extract Codelist");
		extractCodelistButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		extractCodelistButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.EXTRACTCODELIST));
			}
		});

		helperLayout.setWidget(0, 0, extractCodelistButton);
		helperLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		codelistMappingButton = new TextButton("Map Import",
				TabularDataResources.INSTANCE.codelistMapping32());
		codelistMappingButton.disable();
		codelistMappingButton.setScale(ButtonScale.LARGE);
		codelistMappingButton.setIconAlign(IconAlign.TOP);
		codelistMappingButton.setToolTip("Codelist Map Import");
		codelistMappingButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		codelistMappingButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.CODELISTMAPPING));
			}
		});

		helperLayout.setWidget(0, 1, codelistMappingButton);
		helperLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);
		
		/*
		generateSummaryButton = new TextButton("Generate Summary",
				TabularDataResources.INSTANCE.summary32());
		generateSummaryButton.disable();
		generateSummaryButton.setScale(ButtonScale.LARGE);
		generateSummaryButton.setIconAlign(IconAlign.TOP);
		generateSummaryButton.setToolTip("Generate Summary");
		generateSummaryButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		generateSummaryButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.GENERATESUMMARY));
			}
		});

		helperLayout.setWidget(0, 2, generateSummaryButton);
		helperLayout.getFlexCellFormatter().setRowSpan(0, 2, 2);
		*/
		cleanCells(helperLayout.getElement());

		eventBus.addHandler(UIStateEvent.TYPE,
				new UIStateEvent.UIStateHandler() {

					public void onUIState(UIStateEvent event) {
						setUI(event);

					}
				});

	}

	protected void cleanCells(Element elem) {
		NodeList<Element> tds = elem.<XElement> cast().select("td");
		for (int i = 0; i < tds.getLength(); i++) {
			Element td = tds.getItem(i);

			if (!td.hasChildNodes() && td.getClassName().equals("")) {
				td.removeFromParent();
			}
		}
	}

	public void setUI(UIStateEvent event) {
		UIStateType uiStateType = event.getUIStateType();
		try {
			switch (uiStateType) {
			case START:
				duplicateDetectionButton.disable();
				//rulesButton.disable();
				normalizeButton.disable();
				//manageRulesButton.disable();
				applyTemplateButton.disable();
				denormalizeButton.disable();
				changeColumnLabelButton.disable();
				columnTypeButton.disable();
				tableTypeButton.disable();
				addColumnButton.disable();
				deleteColumnButton.disable();
				splitColumnButton.disable();
				mergeColumnButton.disable();
				extractCodelistButton.disable();
				codelistMappingButton.disable();
				//generateSummaryButton.disable();
				break;
			case TR_CLOSE:
			case TR_READONLY:
				duplicateDetectionButton.disable();
				//rulesButton.disable();
				normalizeButton.disable();
				//manageRulesButton.disable();
				applyTemplateButton.disable();
				denormalizeButton.disable();
				changeColumnLabelButton.disable();
				columnTypeButton.disable();
				tableTypeButton.disable();
				addColumnButton.disable();
				deleteColumnButton.disable();
				splitColumnButton.disable();
				mergeColumnButton.disable();
				extractCodelistButton.disable();
				codelistMappingButton.disable();
				//generateSummaryButton.disable();
				break;
			case TR_OPEN:
			case TABLEUPDATE:
			case TABLECURATION:
				duplicateDetectionButton.enable();
				//rulesButton.disable();
				//manageRulesButton.disable();
				applyTemplateButton.enable();
				denormalizeButton.enable();
				normalizeButton.enable();
				changeColumnLabelButton.enable();
				columnTypeButton.enable();
				tableTypeButton.enable();
				addColumnButton.enable();
				deleteColumnButton.enable();
				splitColumnButton.enable();
				mergeColumnButton.enable();
				extractCodelistButton.enable();
				TRId trId = event.getTrId();
				if (trId != null && trId.getTableType() != null
						&& trId.getTableType().compareTo("Codelist") == 0) {
					codelistMappingButton.enable();
				} else {
					codelistMappingButton.disable();
				}
				//generateSummaryButton.disable();
				break;
			case WIZARD_OPEN:
				duplicateDetectionButton.disable();
				//rulesButton.disable();
				normalizeButton.disable();
				//manageRulesButton.disable();
				applyTemplateButton.disable();
				denormalizeButton.disable();
				changeColumnLabelButton.disable();
				columnTypeButton.disable();
				tableTypeButton.disable();
				addColumnButton.disable();
				deleteColumnButton.disable();
				splitColumnButton.disable();
				mergeColumnButton.disable();
				extractCodelistButton.disable();
				codelistMappingButton.disable();
				//generateSummaryButton.disable();
				break;
			default:
				break;
			}
		} catch (Exception e) {
			Log.error("setUI Error on Ribbon Curation: "
					+ e.getLocalizedMessage());
		}
	}

}
