/**
 * 
 */
package org.gcube.portlets.user.td.client.ribbon;

import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.RibbonEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.UIStateEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.RibbonType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.UIStateType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.ButtonArrowAlign;
import com.sencha.gxt.cell.core.client.ButtonCell.ButtonScale;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.core.client.dom.XElement;
import com.sencha.gxt.widget.core.client.button.ButtonGroup;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class FileToolBar {

	protected EventBus eventBus;
	protected ToolBar toolBar;

	protected TextButton openButton;
	protected TextButton cloneButton;
	protected TextButton closeButton;

	protected TextButton deleteButton;
	protected TextButton propertiesButton;

	protected TextButton importCSVButton;
	protected TextButton importJSONButton;
	protected TextButton importSDMXButton;

	protected TextButton exportSDMXButton;
	protected TextButton exportCSVButton;
	protected TextButton exportJSONButton;

	//Template
	protected TextButton templateNewButton;
	protected TextButton templateOpenButton;
	protected TextButton templateDeleteButton;
	
    //Share
	protected TextButton shareButton;

	protected TextButton timelineButton;
	protected TextButton backgroundButton;

	// History
	protected TextButton historyButton;
	protected TextButton undoButton;
	//protected TextButton discardAllButton;

	protected TextButton helpButton;
	protected TextButton logsButton;
	

	public FileToolBar(EventBus eventBus) {
		this.eventBus = eventBus;
		build();
	}

	public ToolBar getToolBar() {
		return toolBar;
	}

	protected void build() {
		toolBar = new ToolBar();
		toolBar.setSpacing(1);
		toolBar.setEnableOverflow(false);
		
		// File
		ButtonGroup fileGroup = new ButtonGroup();
		fileGroup.setId("File");
		fileGroup.setStyleName("ribbon");
		fileGroup.setHeadingText("File");
		toolBar.add(fileGroup);

		FlexTable fileLayout = new FlexTable();
		fileLayout.setStyleName("ribbon");
		fileGroup.add(fileLayout);

		openButton = new TextButton("Open",
				TabularDataResources.INSTANCE.open32());
		openButton.setId("openButton");
		openButton.setScale(ButtonScale.LARGE);
		openButton.setIconAlign(IconAlign.TOP);
		openButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		openButton.setToolTip("Open Tabular Resource");

		openButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.OPEN));
			}
		});

		fileLayout.setWidget(0, 0, openButton);
		fileLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);
		
		
		
		
		closeButton = new TextButton("Close All",
				TabularDataResources.INSTANCE.close32());
		closeButton.disable();
		closeButton.setId("closeButton");
		closeButton.setScale(ButtonScale.LARGE);
		closeButton.setIconAlign(IconAlign.TOP);
		closeButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		closeButton.setToolTip("Close All Tabular Resources");

		closeButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.CLOSE));
			}
		});

		fileLayout.setWidget(0, 1, closeButton);
		fileLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);
		
		
		cloneButton = new TextButton("Clone",
				TabularDataResources.INSTANCE.clone32());
		cloneButton.disable();
		cloneButton.setId("cloneButton");
		cloneButton.setScale(ButtonScale.LARGE);
		cloneButton.setIconAlign(IconAlign.TOP);
		cloneButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		cloneButton.setToolTip("Clone Tabular Resource");

		cloneButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.CLONE));
			}
		});

		fileLayout.setWidget(0, 2, cloneButton);
		fileLayout.getFlexCellFormatter().setRowSpan(0, 2, 2);


		deleteButton = new TextButton("Delete",
				TabularDataResources.INSTANCE.delete());
		deleteButton.disable();
		deleteButton.setId("closeButton");
		deleteButton.setToolTip("Delete Tabular Resource");

		fileLayout.setWidget(0, 3, deleteButton);
		deleteButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.DELETE));
			}
		});

		propertiesButton = new TextButton("Properties",
				TabularDataResources.INSTANCE.properties());
		propertiesButton.disable();
		propertiesButton.setId("propertiesButton");
		propertiesButton.setToolTip("Show properties");

		fileLayout.setWidget(1, 3, propertiesButton);
		propertiesButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.PROPERTIES));
			}
		});

		cleanCells(fileLayout.getElement());

		// Import
		ButtonGroup importGroup = new ButtonGroup();
		importGroup.setId("Import");
		importGroup.setStyleName("ribbon");
		importGroup.setHeadingText("Import");
		toolBar.add(importGroup);

		FlexTable importLayout = new FlexTable();
		importGroup.add(importLayout);

		importSDMXButton = new TextButton("SDMX",
				TabularDataResources.INSTANCE.sdmx32());
		importSDMXButton.setScale(ButtonScale.LARGE);
		importSDMXButton.setIconAlign(IconAlign.TOP);
		importSDMXButton.setToolTip("Import table from SDMX source");
		importSDMXButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		importSDMXButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.IMPORTSDMX));
			}
		});

		importLayout.setWidget(0, 0, importSDMXButton);
		importLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		importCSVButton = new TextButton("CSV",
				TabularDataResources.INSTANCE.csv());
		importCSVButton.setToolTip("Import table from CSV source");
		importCSVButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.IMPORTCSV));
			}
		});
		importLayout.setWidget(0, 2, importCSVButton);

		importJSONButton = new TextButton("JSON",
				TabularDataResources.INSTANCE.json());
		importJSONButton.disable();
		importJSONButton.setToolTip("Import table from JSON source");
		importJSONButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.IMPORTJSON));
			}
		});
		importLayout.setWidget(1, 2, importJSONButton);

		cleanCells(importLayout.getElement());

		// Export
		ButtonGroup exportGroup = new ButtonGroup();
		exportGroup.setId("Export");
		exportGroup.setStyleName("ribbon");
		exportGroup.setHeadingText("Export");
		// exportGroup.disable();
		toolBar.add(exportGroup);

		FlexTable exportLayout = new FlexTable();
		exportGroup.add(exportLayout);

		exportSDMXButton = new TextButton("SDMX",
				TabularDataResources.INSTANCE.sdmx32());
		exportSDMXButton.disable();
		exportSDMXButton.setToolTip("Export SDMX document");
		exportSDMXButton.setScale(ButtonScale.LARGE);
		exportSDMXButton.setIconAlign(IconAlign.TOP);
		exportSDMXButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		exportSDMXButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.EXPORTSDMX));
			}
		});

		exportLayout.setWidget(0, 0, exportSDMXButton);
		exportLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		exportCSVButton = new TextButton("CSV",
				TabularDataResources.INSTANCE.csv());
		exportCSVButton.disable();
		exportCSVButton.setToolTip("Export CSV document");
		exportCSVButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.EXPORTCSV));
			}
		});
		exportLayout.setWidget(0, 2, exportCSVButton);

		exportJSONButton = new TextButton("JSON",
				TabularDataResources.INSTANCE.json());
		exportJSONButton.disable();
		exportJSONButton.setToolTip("Export JSON document");
		exportJSONButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.EXPORTJSON));
			}
		});
		exportLayout.setWidget(1, 2, exportJSONButton);
		cleanCells(exportLayout.getElement());

		// Template
		ButtonGroup templateGroup = new ButtonGroup();
		templateGroup.setId("Template");
		templateGroup.setStyleName("ribbon");
		templateGroup.setHeadingText("Template");
		//templateGroup.disable();
		toolBar.add(templateGroup);

		FlexTable templateLayout = new FlexTable();
		templateGroup.add(templateLayout);

		templateNewButton = new TextButton("New",
				TabularDataResources.INSTANCE.templateEdit32());
		templateNewButton.enable();
		templateNewButton.setToolTip("New");
		templateNewButton.setScale(ButtonScale.LARGE);
		templateNewButton.setIconAlign(IconAlign.TOP);
		templateNewButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		templateNewButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(
				RibbonType.TEMPLATENEW));
			}
		});
		
		templateLayout.setWidget(0, 0, templateNewButton);
		templateLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);
		
		templateOpenButton = new TextButton("Open",
				TabularDataResources.INSTANCE.templateAdd32());
		templateOpenButton.enable();
		templateOpenButton.setToolTip("Open");
		templateOpenButton.setScale(ButtonScale.LARGE);
		templateOpenButton.setIconAlign(IconAlign.TOP);
		templateOpenButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		templateOpenButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(
						RibbonType.TEMPLATEOPEN));
			}
		});

		templateLayout.setWidget(0, 1, templateOpenButton);
		templateLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);
		
		
		templateDeleteButton = new TextButton("Delete",
				TabularDataResources.INSTANCE.templateDelete32());
		templateDeleteButton.enable();
		templateDeleteButton.setToolTip("Delete");
		templateDeleteButton.setScale(ButtonScale.LARGE);
		templateDeleteButton.setIconAlign(IconAlign.TOP);
		templateDeleteButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		templateDeleteButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(
				RibbonType.TEMPLATEDELETE));
			}
		});
		
		templateLayout.setWidget(0, 2, templateDeleteButton);
		templateLayout.getFlexCellFormatter().setRowSpan(0, 2, 2);
		
		cleanCells(templateLayout.getElement());

		// Share
		ButtonGroup shareGroup = new ButtonGroup();
		shareGroup.setId("Share");
		shareGroup.setStyleName("ribbon");
		shareGroup.setHeadingText("Share");
		toolBar.add(shareGroup);

		FlexTable shareLayout = new FlexTable();
		shareGroup.add(shareLayout);

		shareButton = new TextButton("Share",
				TabularDataResources.INSTANCE.share32());
		shareButton.disable();
		shareButton.setId("shareButton");
		shareButton.setScale(ButtonScale.LARGE);
		shareButton.setIconAlign(IconAlign.TOP);
		shareButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		shareButton.setToolTip("Share Tabular Resource");

		shareButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.SHARE));
			}
		});

		shareLayout.setWidget(0, 0, shareButton);
		shareLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);
		cleanCells(shareLayout.getElement());

		// TimeLine (Tasks)
		ButtonGroup taskGroup = new ButtonGroup();
		taskGroup.setId("TasksStatus");
		taskGroup.setStyleName("ribbon");
		taskGroup.setHeadingText("Tasks");
		toolBar.add(taskGroup);

		FlexTable taskLayout = new FlexTable();
		taskGroup.add(taskLayout);

		timelineButton = new TextButton("Timeline",
				TabularDataResources.INSTANCE.timeline32());
		timelineButton.disable();
		timelineButton.setToolTip("Timeline");
		timelineButton.setScale(ButtonScale.LARGE);
		timelineButton.setIconAlign(IconAlign.TOP);
		timelineButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		timelineButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.TIMELINE));
			}
		});

		taskLayout.setWidget(0, 0, timelineButton);
		taskLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);
		
		backgroundButton = new TextButton("Background",
				TabularDataResources.INSTANCE.basketBackground32());
		backgroundButton.enable();
		backgroundButton.setToolTip("Tasks in background");
		backgroundButton.setScale(ButtonScale.LARGE);
		backgroundButton.setIconAlign(IconAlign.TOP);
		backgroundButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		backgroundButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.BACKGROUNDTASKS));
			}
		});

		taskLayout.setWidget(0, 1, backgroundButton);
		taskLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);
		
		cleanCells(taskLayout.getElement());

		// History Group
		ButtonGroup historyGroup = new ButtonGroup();
		historyGroup.setId("History");
		historyGroup.setStyleName("ribbon");
		historyGroup.setHeadingText("History");
		historyGroup.enable();
		toolBar.add(historyGroup);

		FlexTable historyLayout = new FlexTable();
		historyGroup.add(historyLayout);

		historyButton = new TextButton("History",
				TabularDataResources.INSTANCE.history32());
		historyButton.disable();
		historyButton.setScale(ButtonScale.LARGE);
		historyButton.setIconAlign(IconAlign.TOP);
		historyButton.setToolTip("Show history");
		historyButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		historyButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.HISTORY));
			}
		});

		historyLayout.setWidget(0, 0, historyButton);
		historyLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);

		undoButton = new TextButton("Undo",
				TabularDataResources.INSTANCE.discard32());
		undoButton.disable();
		undoButton.setScale(ButtonScale.LARGE);
		undoButton.setIconAlign(IconAlign.TOP);
		undoButton.setToolTip("Discard last operation");
		undoButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		undoButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.UNDO));
			}
		});
		historyLayout.setWidget(0, 1, undoButton);
		historyLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);

		/*discardAllButton = new TextButton("Discard All",
				TabularDataResources.INSTANCE.discardAll());
		discardAllButton.disable();
		discardAllButton.setToolTip("Discard all unsaved operations");
		historyLayout.setWidget(1, 1, discardAllButton);
		discardAllButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.DISCARDALL));
			}
		});*/

		cleanCells(historyLayout.getElement());

		// Help
		ButtonGroup helpGroup = new ButtonGroup();
		helpGroup.setId("Help");
		helpGroup.setStyleName("ribbon");
		helpGroup.setHeadingText("Help");
		toolBar.add(helpGroup);

		FlexTable helpLayout = new FlexTable();
		helpGroup.add(helpLayout);

		helpButton = new TextButton("Help",
				TabularDataResources.INSTANCE.help32());
		helpButton.enable();
		helpButton.setToolTip("Help");
		helpButton.setScale(ButtonScale.LARGE);
		helpButton.setIconAlign(IconAlign.TOP);
		helpButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		helpButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.HELP));
			}
		});

		helpLayout.setWidget(0, 0, helpButton);
		helpLayout.getFlexCellFormatter().setRowSpan(0, 0, 2);
		
		/*
		logsButton = new TextButton("Logs",
				TabularDataResources.INSTANCE.logs32());
		logsButton.enable();
		logsButton.setToolTip("Show Logs");
		logsButton.setScale(ButtonScale.LARGE);
		logsButton.setIconAlign(IconAlign.TOP);
		logsButton.setArrowAlign(ButtonArrowAlign.BOTTOM);
		logsButton.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				eventBus.fireEvent(new RibbonEvent(RibbonType.LOGS));
			}
		});

		helpLayout.setWidget(0, 1, logsButton);
		helpLayout.getFlexCellFormatter().setRowSpan(0, 1, 2);
		*/
		
		cleanCells(helpLayout.getElement());

		eventBus.addHandler(UIStateEvent.TYPE,
				new UIStateEvent.UIStateHandler() {

					public void onUIState(UIStateEvent event) {
						setUI(event);

					}
				});

	}

	private void cleanCells(Element elem) {
		NodeList<Element> tds = elem.<XElement> cast().select("td");
		for (int i = 0; i < tds.getLength(); i++) {
			Element td = tds.getItem(i);

			if (!td.hasChildNodes() && td.getClassName().equals("")) {
				td.removeFromParent();
			}
		}
	}

	public void setUI(UIStateEvent event) {
		UIStateType uiStateType = event.getUIStateType();
		try {
			switch (uiStateType) {
			case START:
				openButton.enable();
				cloneButton.disable();
				closeButton.disable();
				shareButton.disable();
				deleteButton.disable();
				propertiesButton.disable();
				importCSVButton.enable();
				importJSONButton.disable();
				importSDMXButton.enable();
				exportCSVButton.disable();
				exportJSONButton.disable();
				exportSDMXButton.disable();
				templateOpenButton.enable();
				templateNewButton.enable();
				templateDeleteButton.enable();
				timelineButton.disable();
				backgroundButton.enable();
				historyButton.disable();
				undoButton.disable();
				//discardAllButton.disable();
				break;
			case TR_CLOSE:
			case TR_READONLY:	
				openButton.enable();
				cloneButton.disable();
				closeButton.disable();
				shareButton.disable();
				deleteButton.disable();
				propertiesButton.disable();
				importCSVButton.enable();
				importJSONButton.disable();
				importSDMXButton.enable();
				exportCSVButton.disable();
				exportJSONButton.disable();
				exportSDMXButton.disable();
				templateOpenButton.enable();
				templateNewButton.enable();
				templateDeleteButton.enable();
				timelineButton.disable();
				backgroundButton.enable();
				historyButton.disable();
				undoButton.disable();
				//discardAllButton.disable();
				break;
			case TR_OPEN:
			case TABLEUPDATE:
			case TABLECURATION:	
				openButton.enable();
				cloneButton.enable();
				closeButton.enable();
				shareButton.enable();
				deleteButton.enable();
				propertiesButton.enable();
				importCSVButton.enable();
				importJSONButton.disable();
				importSDMXButton.enable();
				TRId trId=event.getTrId();
				if (trId!=null&& trId.getTableType()!=null && trId.getTableType().compareTo("Codelist") == 0) {
					exportSDMXButton.enable();
				} else {
					exportSDMXButton.disable();
				}
				exportCSVButton.enable();
				exportJSONButton.enable();
				templateOpenButton.enable();
				templateNewButton.enable();
				templateDeleteButton.enable();
				timelineButton.enable();
				backgroundButton.enable();
				historyButton.enable();
				undoButton.enable();
				//discardAllButton.disable();
				break;
			case WIZARD_OPEN:
				openButton.disable();
				cloneButton.disable();
				closeButton.disable();
				shareButton.disable();
				deleteButton.disable();
				propertiesButton.disable();
				importCSVButton.disable();
				importJSONButton.disable();
				importSDMXButton.disable();
				exportCSVButton.disable();
				exportJSONButton.disable();
				exportSDMXButton.disable();
				templateOpenButton.disable();
				templateNewButton.disable();
				templateDeleteButton.disable();
				timelineButton.disable();
				backgroundButton.disable();
				historyButton.disable();
				undoButton.disable();
				//discardAllButton.disable();
				break;
			default:
				break;
			}
		} catch (Exception e) {
			Log.error("setUI Error : " + e.getLocalizedMessage());
		}
	}
}
