package org.gcube.portlets.user.td.client.template;

import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateData;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateDeleteSession;
import org.gcube.portlets.user.td.sharewidget.client.TemplateShare;
import org.gcube.portlets.user.tdtemplate.client.TdTemplateController;
import org.gcube.portlets.user.tdtemplate.client.TdTemplateControllerUpdater;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 *
 */
public class TemplateOpenDialog extends Window {
	protected String WIDTH = "720px";
	protected String HEIGHT = "530px";
	protected TemplateDeleteSession templateDeleteSession;
	protected EventBus eventBus;

	public TemplateOpenDialog(EventBus eventBus) {
		this.eventBus = eventBus;
		initWindow();

		TemplateOpenPanel templateDeletePanel = new TemplateOpenPanel(this,
				eventBus);
		add(templateDeletePanel);
	}

	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("Open Template");
		setClosable(true);
		setModal(true);
		forceLayoutOnResize = true;
		getHeader().setIcon(TabularDataResources.INSTANCE.templateAdd());

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}

	protected void close() {
		hide();
	}

	public void templateOpen(TemplateData template) {
		TdTemplateControllerUpdater controller = new TdTemplateControllerUpdater(
				template.getId());
		TdTemplateController.bindCommonBus(eventBus);
		controller.getWindowTemplatePanel().show();
		close();

	}

	public void templateShare(TemplateData templateData) {
		Log.debug("Open Share Window");
		@SuppressWarnings("unused")
		TemplateShare templateShare = new TemplateShare(templateData, eventBus);
		close();

	}

}
