package org.gcube.portlets.user.td.client.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.expressionwidget.client.rpc.ExpressionServiceAsync;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.RuleDescriptionDataProperties;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsFinalException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsLockedException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.rule.AppliedRulesResponseData;
import org.gcube.portlets.user.td.gwtservice.shared.rule.DetachColumnRulesSession;
import org.gcube.portlets.user.td.gwtservice.shared.rule.RuleDescriptionData;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnData;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.core.client.XTemplates;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer.HBoxLayoutAlign;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.filters.GridFilters;
import com.sencha.gxt.widget.core.client.grid.filters.StringFilter;
import com.sencha.gxt.widget.core.client.menu.Item;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;

/**
 * 
 * @author giancarlo email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 *
 */
public class RuleActivePanel extends FramedPanel {
	private static final int RULE_ON_COLUMN_FIELDSET_HEIGHT = 348;
	private static final String RULES_GRID_HEIGHT = "102px";
	private static final String WIDTH = "630px";
	private static final String HEIGHT = "418px";

	interface RuleApplyTemplates extends XTemplates {
		@XTemplate("<span title=\"{value}\">{value}</span>")
		SafeHtml format(String value);
	}

	private EventBus eventBus;
	private RuleActiveDialog parent;
	private TRId trId;
	private ArrayList<ColumnData> columns;

	private AppliedRulesResponseData appliedRuleResponseData;

	private TextButton btnClose;
	private VerticalLayoutContainer mainLayoutContainer;

	public RuleActivePanel(RuleActiveDialog parent, TRId trId,
			EventBus eventBus) {
		this.parent = parent;
		this.trId = trId;

		Log.debug("RuleActivePanel");
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
		this.eventBus = eventBus;
		retrieveColumns();

	}

	protected void retrieveColumns() {
		TDGWTServiceAsync.INSTANCE.getColumns(trId,
				new AsyncCallback<ArrayList<ColumnData>>() {

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							if (caught instanceof TDGWTIsLockedException) {
								Log.error(caught.getLocalizedMessage());
								UtilsGXT3.alert("Error Locked",
										caught.getLocalizedMessage());
							} else {
								if (caught instanceof TDGWTIsFinalException) {
									Log.error(caught.getLocalizedMessage());
									UtilsGXT3.alert("Error Final",
											caught.getLocalizedMessage());
								} else {
									Log.debug("Error retrieving columns: "
											+ caught.getLocalizedMessage());
									UtilsGXT3
											.alert("Error retrieving columns",
													"Error retrieving column on server!");
								}
							}
						}

					}

					@Override
					public void onSuccess(ArrayList<ColumnData> result) {
						Log.debug("Retrieved Columns");
						if (result == null) {
							UtilsGXT3.alert("Error",
									"The requested columns is null");
						}
						columns = result;

						getActiveRulesOnColumn();

					}
				});
	}

	protected void create() {

		Log.debug("Create RuleActivePanel(): " + trId);

		// SimpleContainer rulesOnColumnContainer=new SimpleContainer();
		FieldSet columnRulesFieldSet = new FieldSet();
		columnRulesFieldSet.setHeadingText("Rules On Column");
		columnRulesFieldSet.setCollapsible(false);

		VerticalLayoutContainer columnRulesFieldSetLayout = new VerticalLayoutContainer();
		columnRulesFieldSetLayout.setScrollMode(ScrollMode.AUTO);
		columnRulesFieldSetLayout.setAdjustForScroll(true);

		columnRulesFieldSet.add(columnRulesFieldSetLayout);

		HashMap<String, ArrayList<RuleDescriptionData>> columnRuleMapping = appliedRuleResponseData
				.getColumnRuleMapping();
		if (columnRuleMapping != null && columnRuleMapping.size() > 0) {

			for (ColumnData column : columns) {
				ArrayList<RuleDescriptionData> columnAppliedRules = columnRuleMapping
						.get(column.getColumnId());
				if (columnAppliedRules != null && columnAppliedRules.size() > 0) {
					FieldLabel columnLabel = createColumnRules(column,
							columnAppliedRules);
					columnRulesFieldSetLayout.add(columnLabel,
							new VerticalLayoutData(1, -1, new Margins(0)));
				}
			}
		} else {
			FieldLabel noRulesLabel = new FieldLabel(null, "No rules applied!");
			noRulesLabel.setLabelSeparator("");
			columnRulesFieldSetLayout.add(noRulesLabel, new VerticalLayoutData(
					1, -1, new Margins(0)));

		}

		btnClose = new TextButton("Close");
		btnClose.setIcon(TabularDataResources.INSTANCE.close());
		btnClose.setIconAlign(IconAlign.RIGHT);
		btnClose.setToolTip("Close");
		btnClose.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Close");
				close();
			}
		});

		HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
		flowButton.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		flowButton.setPack(BoxLayoutPack.CENTER);
		flowButton.add(btnClose, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		mainLayoutContainer = new VerticalLayoutContainer();
		mainLayoutContainer.add(columnRulesFieldSet, new VerticalLayoutData(-1,
				RULE_ON_COLUMN_FIELDSET_HEIGHT, new Margins(0)));
		mainLayoutContainer.add(flowButton,
				new VerticalLayoutData(1, 36, new Margins(5, 2, 5, 2)));
		add(mainLayoutContainer);

	}

	private FieldLabel createColumnRules(ColumnData column,
			ArrayList<RuleDescriptionData> columnAppliedRules) {
		// Rules

		RuleDescriptionDataProperties propsRules = GWT
				.create(RuleDescriptionDataProperties.class);

		ColumnConfig<RuleDescriptionData, String> nameCol = new ColumnConfig<RuleDescriptionData, String>(
				propsRules.name(), 120, "Name");

		nameCol.setCell(new AbstractCell<String>() {

			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				RuleApplyTemplates ruleApplyTemplates = GWT
						.create(RuleApplyTemplates.class);
				sb.append(ruleApplyTemplates.format(value));
			}
		});

		ColumnConfig<RuleDescriptionData, String> descriptionCol = new ColumnConfig<RuleDescriptionData, String>(
				propsRules.description(), 120, "Description");
		descriptionCol.setCell(new AbstractCell<String>() {

			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				RuleApplyTemplates ruleApplyTemplates = GWT
						.create(RuleApplyTemplates.class);
				sb.append(ruleApplyTemplates.format(value));
			}
		});

		ColumnConfig<RuleDescriptionData, String> ownerCol = new ColumnConfig<RuleDescriptionData, String>(
				propsRules.ownerLogin(), 70, "Owner");
		ownerCol.setCell(new AbstractCell<String>() {

			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				RuleApplyTemplates ruleApplyTemplates = GWT
						.create(RuleApplyTemplates.class);
				sb.append(ruleApplyTemplates.format(value));
			}
		});

		/*
		ColumnConfig<RuleDescriptionData, String> readableExpressionCol = new ColumnConfig<RuleDescriptionData, String>(
				propsRules.readableExpression(), 160, "Expression");

	
		readableExpressionCol.setCell(new AbstractCell<String>() {

			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				RuleApplyTemplates ruleApplyTemplates = GWT
						.create(RuleApplyTemplates.class);
				sb.append(ruleApplyTemplates.format(value));
			}
		});*/

		List<ColumnConfig<RuleDescriptionData, ?>> l = new ArrayList<ColumnConfig<RuleDescriptionData, ?>>();
		l.add(nameCol);
		l.add(descriptionCol);
		l.add(ownerCol);
		//l.add(readableExpressionCol);

		ColumnModel<RuleDescriptionData> cm = new ColumnModel<RuleDescriptionData>(
				l);

		StringFilter<RuleDescriptionData> nameFilter = new StringFilter<RuleDescriptionData>(
				propsRules.name());
		StringFilter<RuleDescriptionData> descriptionFilter = new StringFilter<RuleDescriptionData>(
				propsRules.description());

		// Applies Rules
		ListStore<RuleDescriptionData> appliedRulesStore = new ListStore<RuleDescriptionData>(
				propsRules.id());

		if (columnAppliedRules != null && columnAppliedRules.size() > 0) {
			appliedRulesStore.addAll(columnAppliedRules);
		}

		final Grid<RuleDescriptionData> gridAppliedRules = new Grid<RuleDescriptionData>(
				appliedRulesStore, cm);
		gridAppliedRules.setItemId(column.getColumnId());
		gridAppliedRules.setHeight(RULES_GRID_HEIGHT);
		gridAppliedRules.getView().setStripeRows(true);
		gridAppliedRules.getView().setColumnLines(true);
		gridAppliedRules.getView().setAutoFill(true);
		gridAppliedRules.setBorders(false);
		gridAppliedRules.setLoadMask(true);
		gridAppliedRules.setColumnReordering(true);
		gridAppliedRules.setColumnResize(true);
		gridAppliedRules.getView().setAutoExpandColumn(descriptionCol);

		GridFilters<RuleDescriptionData> filtersAppliesRules = new GridFilters<RuleDescriptionData>();
		filtersAppliesRules.initPlugin(gridAppliedRules);
		filtersAppliesRules.setLocal(true);
		filtersAppliesRules.addFilter(nameFilter);
		filtersAppliesRules.addFilter(descriptionFilter);

		createContextMenu(gridAppliedRules);

		FieldLabel rulesAppliedLabel = new FieldLabel(gridAppliedRules,
				column.getLabel());

		return rulesAppliedLabel;
	}

	protected void getActiveRulesOnColumn() {

		ExpressionServiceAsync.INSTANCE.getActiveRulesByTabularResourceId(
				trId, new AsyncCallback<AppliedRulesResponseData>() {

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error(caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving active rules",
									caught.getLocalizedMessage());
						}

					}

					@Override
					public void onSuccess(AppliedRulesResponseData result) {
						Log.trace("AppliedRuleResponseData: " + result);
						appliedRuleResponseData = result;
						create();
					}
				});

	}
	
	
	protected void updateActiveRulesOnColumn() {

		ExpressionServiceAsync.INSTANCE.getActiveRulesByTabularResourceId(
				trId, new AsyncCallback<AppliedRulesResponseData>() {

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error(caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving applied rules",
									caught.getLocalizedMessage());
						}

					}

					@Override
					public void onSuccess(AppliedRulesResponseData result) {
						Log.trace("AppliedRuleResponseData: " + result);
						appliedRuleResponseData = result;
						recreate();
					}
				});

	}
	

	protected void close() {
		parent.close();
	}
	
	
	

	protected void requestInfo(RuleDescriptionData rule) {
		final RuleInfoDialog infoRuleDialog = new RuleInfoDialog(rule);
		infoRuleDialog.show();


	}

	protected void createContextMenu(final Grid<RuleDescriptionData> grid) {
		Menu contextMenu = new Menu();

		MenuItem infoItem = new MenuItem();
		infoItem.setText("Info");
		infoItem.setToolTip("Info");
		infoItem.setIcon(TabularDataResources.INSTANCE.information());
		infoItem.addSelectionHandler(new SelectionHandler<Item>() {

			@Override
			public void onSelection(SelectionEvent<Item> event) {
				RuleDescriptionData selected = grid.getSelectionModel()
						.getSelectedItem();
				Log.debug(selected.toString());
				requestInfo(selected);
			}
		});
		
		MenuItem detachItem = new MenuItem();
		detachItem.setText("Detach");
		detachItem.setToolTip("Detach rule");
		detachItem.setIcon(TabularDataResources.INSTANCE.ruleColumnDetach());
		detachItem.addSelectionHandler(new SelectionHandler<Item>() {

			@Override
			public void onSelection(SelectionEvent<Item> event) {
				RuleDescriptionData selected = grid.getSelectionModel()
						.getSelectedItem();
				Log.debug(selected.toString());
				requestDetach(selected, grid);
			}

			
		});
		

		contextMenu.add(infoItem);
		contextMenu.add(detachItem);

		grid.setContextMenu(contextMenu);

	}

	protected void requestDetach(RuleDescriptionData selected,
			final Grid<RuleDescriptionData> grid) {
		
		String columnLocalId=grid.getItemId();
		ColumnData columnData=new ColumnData();
		columnData.setColumnId(columnLocalId);
		ArrayList<RuleDescriptionData> detachRules=new ArrayList<RuleDescriptionData>();
		detachRules.add(selected);
		
		DetachColumnRulesSession detachColumnRulesSession=new DetachColumnRulesSession(trId, columnData, detachRules);
		
		ExpressionServiceAsync.INSTANCE.setDetachColumnRules(detachColumnRulesSession, 
				 new AsyncCallback<Void>() {

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error(caught.getLocalizedMessage());
							UtilsGXT3.alert("Error in detach rules",
									caught.getLocalizedMessage());
						}

					}

					@Override
					public void onSuccess(Void result) {
						updateActiveRulesOnColumn();
						Log.debug("The rule is detached!");
						UtilsGXT3.info("Detach Rule",
								"The rule is detached!");
					
					}
				});
		
	}
	
	
	protected void recreate(){
		remove(mainLayoutContainer);
		create();
		forceLayout();
		
	
	}
	

}
