/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.client;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.widget.Window;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.ContentPanel;
import com.sencha.gxt.widget.core.client.box.ConfirmMessageBox;
import com.sencha.gxt.widget.core.client.container.BorderLayoutContainer;
import com.sencha.gxt.widget.core.client.event.DialogHideEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.gcube.portlets.user.td.client.TabularDataController;
import org.gcube.portlets.user.td.client.logs.TDMLogs;
import org.gcube.portlets.user.td.client.rstudio.RStudio;
import org.gcube.portlets.user.td.client.rule.RuleActiveDialog;
import org.gcube.portlets.user.td.client.rule.RuleApplyDialog;
import org.gcube.portlets.user.td.client.rule.RuleDeleteDialog;
import org.gcube.portlets.user.td.client.rule.RuleOpenDialog;
import org.gcube.portlets.user.td.client.rule.RuleShareDialog;
import org.gcube.portlets.user.td.columnwidget.client.batch.ReplaceBatchDialog;
import org.gcube.portlets.user.td.columnwidget.client.replace.ReplaceAllDialog;
import org.gcube.portlets.user.td.expressionwidget.client.ColumnFilterDialog;
import org.gcube.portlets.user.td.expressionwidget.client.MultiColumnFilterDialog;
import org.gcube.portlets.user.td.expressionwidget.client.ReplaceColumnByExpressionDialog;
import org.gcube.portlets.user.td.expressionwidget.client.RowsDeleteByExpressionDialog;
import org.gcube.portlets.user.td.expressionwidget.client.RuleDialog;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.user.UserInfo;
import org.gcube.portlets.user.td.mainboxwidget.client.MainBoxPanel;
import org.gcube.portlets.user.td.tablewidget.client.CloneTabularResource;
import org.gcube.portlets.user.td.tablewidget.client.history.HistoryDiscard;
import org.gcube.portlets.user.td.tablewidget.client.rows.DeleteRows;
import org.gcube.portlets.user.td.tablewidget.client.rows.EditRowDialog;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.taskswidget.client.TdTaskController;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.BackgroundRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ChangeTableRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.DataViewActiveEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.DataViewRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.GridContextMenuItemEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.GridHeaderColumnMenuItemEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.RibbonEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.TasksMonitorEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.UIStateEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.WidgetRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.BackgroundRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.DataViewRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.RibbonType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.TaskType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.UIStateType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.WidgetRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.CellData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.GridHeaderOperationId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.GridOperationId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.RequestProperties;
import org.gcube.portlets.user.td.widgetcommonevent.shared.RequestPropertiesParameterType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.dataview.DataView;
import org.gcube.portlets.user.td.widgetcommonevent.shared.dataview.TabularResourceDataView;
import org.gcube.portlets.user.td.widgetcommonevent.shared.geospatial.GeospatialCoordinatesType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.grid.model.RowRaw;
import org.gcube.portlets.widgets.sessionchecker.client.CheckSession;

public class TabularDataController {
    private static final String TD_LANG_COOKIE = "TDLangCookie";
    private SimpleEventBus eventBus;
    private MainBoxPanel mainBoxPanel;
    private UIStateType uiState = UIStateType.START;
    private boolean taskManagerInit = false;
    private TdTaskController tdTaskController;
    private ContentPanel toolBoxPanel;
    private BorderLayoutContainer.BorderLayoutData westData;
    private UserInfo userInfo;
    private TRId trId;
    private TRId openTRIdAfterServerUpdate;
    private Window tdTaskMainWindow;

    public TabularDataController() {
        this.eventBus = new SimpleEventBus();
        this.callHello();
        this.checkSession();
        this.pendingTasksRetrieve();
        this.bindToEvents();
    }

    private void checkSession() {
        CheckSession.getInstance().startPolling();
    }

    private void sessionExpiredShow() {
        CheckSession.showLogoutDialog();
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public ContentPanel getToolBoxPanel() {
        return this.toolBoxPanel;
    }

    public void setToolBoxPanel(ContentPanel toolBoxPanel) {
        this.toolBoxPanel = toolBoxPanel;
    }

    public BorderLayoutContainer.BorderLayoutData getWestData() {
        return this.westData;
    }

    public void setWestData(BorderLayoutContainer.BorderLayoutData westData) {
        this.westData = westData;
    }

    public void setMainBoxPanel(MainBoxPanel mainBoxPanel) {
        this.mainBoxPanel = mainBoxPanel;
    }

    private void callHello() {
        TDGWTServiceAsync.INSTANCE.hello((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void pendingTasksRetrieve() {
        TDGWTServiceAsync.INSTANCE.pendingTasksRetrieve((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void sessionExpiredShowDelayed() {
        3 timeoutTimer = new /* Unavailable Anonymous Inner Class!! */;
        int TIMEOUT = 3;
        timeoutTimer.schedule(TIMEOUT * 1000);
    }

    private void bindToEvents() {
        this.eventBus.addHandler(SessionExpiredEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(DataViewActiveEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(GridHeaderColumnMenuItemEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(GridContextMenuItemEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(ChangeTableRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(RibbonEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(TasksMonitorEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(WidgetRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(BackgroundRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.fireEvent((GwtEvent)new UIStateEvent(UIStateType.START));
    }

    protected void checkLocale() {
        String[] locales;
        for (String locale : locales = LocaleInfo.getAvailableLocaleNames()) {
            Log.debug((String)("Locale avaible:" + locale));
        }
        String currentLocaleCookie = Cookies.getCookie((String)LocaleInfo.getLocaleCookieName());
        Log.debug((String)("TDLangCookie:" + currentLocaleCookie));
        LocaleInfo currentLocaleInfo = LocaleInfo.getCurrentLocale();
        Log.debug((String)("Current Locale:" + currentLocaleInfo.getLocaleName()));
    }

    protected void changeLanguage(String localeName) {
        Date now = new Date();
        long nowLong = now.getTime();
        now.setTime(nowLong += 1814400000L);
        String cookieLang = Cookies.getCookie((String)TD_LANG_COOKIE);
        if (cookieLang != null) {
            Cookies.removeCookie((String)TD_LANG_COOKIE);
        }
        Cookies.setCookie((String)TD_LANG_COOKIE, (String)localeName, (Date)now);
        Window.Location.reload();
    }

    public void restoreUISession() {
        this.checkLocale();
        String value = Window.Location.getParameter((String)"TabularResourceId");
        TRId startTRId = new TRId(value);
        TDGWTServiceAsync.INSTANCE.restoreUISession(startTRId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void putInBackgroundUIState() {
        try {
            this.requestCloseCurrent();
        }
        catch (Exception e) {
            Log.debug((String)("Put In Background :" + e.getLocalizedMessage()));
        }
    }

    private void resumeUIState() {
        try {
            switch (40.$SwitchMap$org$gcube$portlets$user$td$widgetcommonevent$client$type$UIStateType[this.uiState.ordinal()]) {
                case 1: {
                    this.eventBus.fireEvent((GwtEvent)new UIStateEvent(UIStateType.START));
                    break;
                }
                case 2: {
                    UIStateEvent uiStateEvent = new UIStateEvent(UIStateType.TABLECURATION);
                    uiStateEvent.setTrId(this.trId);
                    Log.debug((String)("ResumeUIState Fire: " + uiStateEvent));
                    this.eventBus.fireEvent((GwtEvent)uiStateEvent);
                    break;
                }
                case 3: {
                    UIStateEvent uiStateEvent = new UIStateEvent(UIStateType.TABLEUPDATE);
                    uiStateEvent.setTrId(this.trId);
                    Log.debug((String)("ResumeUIState Fire: " + uiStateEvent));
                    this.eventBus.fireEvent((GwtEvent)uiStateEvent);
                    break;
                }
                case 4: {
                    UIStateEvent uiStateEvent = new UIStateEvent(UIStateType.TR_CLOSE);
                    uiStateEvent.setTrId(this.trId);
                    this.eventBus.fireEvent((GwtEvent)uiStateEvent);
                    break;
                }
                case 5: {
                    UIStateEvent uiStateEvent = new UIStateEvent(UIStateType.TR_OPEN);
                    uiStateEvent.setTrId(this.trId);
                    Log.debug((String)("ResumeUIState Fire: " + uiStateEvent));
                    this.eventBus.fireEvent((GwtEvent)uiStateEvent);
                    break;
                }
                case 6: {
                    UIStateEvent uiStateEvent = new UIStateEvent(UIStateType.TR_READONLY);
                    uiStateEvent.setTrId(this.trId);
                    this.eventBus.fireEvent((GwtEvent)uiStateEvent);
                    break;
                }
                case 7: {
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.debug((String)("Resume :" + e.getLocalizedMessage()));
        }
    }

    private void openTable(TRId tabularResourceId) {
        Log.debug((String)("openTable: " + tabularResourceId));
        this.trId = tabularResourceId;
        this.uiState = UIStateType.TR_OPEN;
        UIStateEvent uiStateEvent = new UIStateEvent(UIStateType.TR_OPEN);
        uiStateEvent.setTrId(tabularResourceId);
        this.eventBus.fireEvent((GwtEvent)uiStateEvent);
    }

    private void updateTable(TRId tabularResourceId) {
        Log.debug((String)("updateTable: " + tabularResourceId));
        this.trId = tabularResourceId;
        this.uiState = UIStateType.TABLEUPDATE;
        UIStateEvent uiStateEvent = new UIStateEvent(UIStateType.TABLEUPDATE);
        uiStateEvent.setTrId(tabularResourceId);
        Log.debug((String)("UpdateTable Fire: " + uiStateEvent));
        this.eventBus.fireEvent((GwtEvent)uiStateEvent);
    }

    private void updateTableForCuration(TRId tabularResourceId) {
        Log.debug((String)("updateTableForCuration: " + tabularResourceId));
        this.trId = tabularResourceId;
        this.uiState = UIStateType.TABLECURATION;
        UIStateEvent uiStateEvent = new UIStateEvent(UIStateType.TABLECURATION);
        uiStateEvent.setTrId(tabularResourceId);
        Log.debug((String)("UpdateTableForCuration Fire: " + uiStateEvent));
        this.eventBus.fireEvent((GwtEvent)uiStateEvent);
    }

    private void closeAllTabularResource() {
        switch (40.$SwitchMap$org$gcube$portlets$user$td$widgetcommonevent$client$type$UIStateType[this.uiState.ordinal()]) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                Log.debug((String)"CloseTabularResource");
                UIStateEvent uiStateEvent = new UIStateEvent(UIStateType.TR_CLOSE);
                uiStateEvent.setTrId(this.trId);
                this.trId = null;
                this.uiState = UIStateType.TR_CLOSE;
                Log.debug((String)"fireEvent TR_CLOSE");
                try {
                    this.eventBus.fireEvent((GwtEvent)new UIStateEvent(UIStateType.TR_CLOSE));
                }
                catch (Exception e) {
                    Log.debug((String)("Bus Error: " + e.getMessage()));
                }
                this.closeAllTabularResourceOnServer();
                break;
            }
            case 4: {
                break;
            }
        }
    }

    private void closeAllTabularResourceOnServer() {
        TDGWTServiceAsync.INSTANCE.closeAllTabularResources((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doActiveAfterClose(DataViewActiveEvent event) {
        Log.debug((String)("doActiveAfterClose: " + event));
        DataView dataView = event.getDataView();
        if (dataView instanceof TabularResourceDataView) {
            TabularResourceDataView tabularResourceDataView = (TabularResourceDataView)dataView;
            Log.debug((String)("New TabularResourceDataView:" + tabularResourceDataView));
            this.openTRIdAfterServerUpdate = tabularResourceDataView.getTrId();
            DataView olderDataView = event.getOldDataView();
            if (olderDataView instanceof TabularResourceDataView) {
                TabularResourceDataView olderTabularResourceDataView = (TabularResourceDataView)olderDataView;
                Log.debug((String)("New TabularResourceDataView:" + olderTabularResourceDataView));
                TDGWTServiceAsync.INSTANCE.closeTabularResourceAndOpen(this.openTRIdAfterServerUpdate, olderTabularResourceDataView.getTrId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    private void doOpenTRIdAfterServerUpdate() {
        if (this.trId != null && this.trId.getId().compareTo(this.openTRIdAfterServerUpdate.getId()) == 0 && this.trId.getTableId().compareTo(this.trId.getTableId()) == 0) {
            Log.debug((String)"Open Table Break table just open");
        } else {
            Log.debug((String)"Open Table new Table for TR");
            this.openTable(this.openTRIdAfterServerUpdate);
        }
    }

    private void doNewActive(DataViewActiveEvent event) {
        Log.debug((String)("doNewActive: " + event));
        DataView dataView = event.getDataView();
        if (dataView instanceof TabularResourceDataView) {
            TabularResourceDataView tabularResourceDataView = (TabularResourceDataView)dataView;
            Log.debug((String)("TabularResourceDataView:" + tabularResourceDataView));
            this.openTRIdAfterServerUpdate = tabularResourceDataView.getTrId();
            TDGWTServiceAsync.INSTANCE.setActiveTabularResource(this.openTRIdAfterServerUpdate, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void doDataViewClose(DataViewActiveEvent event) {
        Log.debug((String)("doDataViewClose: " + event));
        DataView oldDataView = event.getOldDataView();
        if (oldDataView instanceof TabularResourceDataView) {
            this.closeAllTabularResource();
        }
    }

    private void requestCloseCurrent() {
        DataViewRequestEvent dataViewRequestEvent = new DataViewRequestEvent();
        dataViewRequestEvent.setDataViewRequestType(DataViewRequestType.CLOSE);
        dataViewRequestEvent.setDataView((DataView)new TabularResourceDataView(this.trId));
        this.eventBus.fireEvent((GwtEvent)dataViewRequestEvent);
    }

    private void deleteTabularResource() {
        ConfirmMessageBox mb = new ConfirmMessageBox("Confirm", "Are you sure you want to delete the tabular resource?");
        mb.addDialogHideHandler((DialogHideEvent.DialogHideHandler)new /* Unavailable Anonymous Inner Class!! */);
        mb.setWidth(300);
        mb.show();
    }

    private void openWizard() {
        this.eventBus.fireEvent((GwtEvent)new UIStateEvent(UIStateType.WIZARD_OPEN));
    }

    public void doRibbonCommand(RibbonEvent event) {
        RibbonType type = event.getRibbonType();
        Log.trace((String)("doRibbonEvent ribbonType: " + type));
        try {
            switch (40.$SwitchMap$org$gcube$portlets$user$td$widgetcommonevent$client$type$RibbonType[type.ordinal()]) {
                case 1: {
                    this.openTabularResource(false);
                    break;
                }
                case 2: {
                    this.cloneTabularResource();
                    break;
                }
                case 3: {
                    this.closeAllTabularResource();
                    break;
                }
                case 4: {
                    this.deleteTabularResource();
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    this.openSDMXImportWizard();
                    break;
                }
                case 7: {
                    this.openCSVImportWizard();
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    this.openSDMXExportWizard();
                    break;
                }
                case 10: {
                    this.openCSVExportWizard();
                    break;
                }
                case 11: {
                    this.openJSONExportWizard();
                    break;
                }
                case 12: {
                    this.openShareWindow();
                    break;
                }
                case 13: {
                    this.openTasksManagerWizard();
                    break;
                }
                case 14: {
                    this.openBackgroundMonitor();
                    break;
                }
                case 15: {
                    break;
                }
                case 16: {
                    this.callDiscard();
                    break;
                }
                case 17: {
                    break;
                }
                case 18: {
                    break;
                }
                case 19: {
                    this.openLogsWindow();
                    break;
                }
                case 20: {
                    this.openDuplicatesRowsDetection();
                    break;
                }
                case 21: {
                    this.openTableType();
                    break;
                }
                case 22: {
                    this.openPositionColumn();
                    break;
                }
                case 23: {
                    this.openColumnLabel();
                    break;
                }
                case 24: {
                    this.openChangeColumnType();
                    break;
                }
                case 25: {
                    this.openColumnAdd();
                    break;
                }
                case 26: {
                    this.openColumnDelete();
                    break;
                }
                case 27: {
                    this.openColumnSplit();
                    break;
                }
                case 28: {
                    this.openColumnMerge();
                    break;
                }
                case 29: {
                    this.openDenormalize();
                    break;
                }
                case 30: {
                    this.openNormalize();
                    break;
                }
                case 31: {
                    this.openExtractCodelistWizard();
                    break;
                }
                case 32: {
                    this.openCodelistMappingWizard();
                    break;
                }
                case 33: {
                    break;
                }
                case 34: {
                    break;
                }
                case 35: {
                    this.openColumnBatchReplace();
                    break;
                }
                case 36: {
                    this.openColumnReplaceByExpression();
                    break;
                }
                case 37: {
                    this.openReplaceByExternalColWizard();
                    break;
                }
                case 38: {
                    this.doRowsDelete();
                    break;
                }
                case 39: {
                    this.openDuplicatesRowsDelete();
                    break;
                }
                case 40: {
                    this.openRowsDeleteByExpression();
                    break;
                }
                case 41: {
                    this.doRowAdd();
                    break;
                }
                case 42: {
                    this.openColumnFilter();
                    break;
                }
                case 43: {
                    this.openTableUnionWizard();
                    break;
                }
                case 44: {
                    this.openGroupBy();
                    break;
                }
                case 45: {
                    this.openTimeAggregate();
                    break;
                }
                case 46: {
                    break;
                }
                case 47: {
                    this.openGeospatialCSquare();
                    break;
                }
                case 48: {
                    this.openGeospatialOceanArea();
                    break;
                }
                case 49: {
                    this.openDownscaleCSquare();
                    break;
                }
                case 50: {
                    this.openGeometryCreatePoint();
                    break;
                }
                case 51: {
                    break;
                }
                case 52: {
                    break;
                }
                case 53: {
                    this.openNewRule();
                    break;
                }
                case 54: {
                    this.openModifyRule();
                    break;
                }
                case 55: {
                    this.openDeleteRule();
                    break;
                }
                case 56: {
                    this.openApplyRule();
                    break;
                }
                case 57: {
                    this.openRulesAppliedOnTabularResource();
                    break;
                }
                case 58: {
                    this.openShareRule();
                    break;
                }
                case 59: {
                    this.openTemplateOpen();
                    break;
                }
                case 60: {
                    this.openTemplateNew();
                    break;
                }
                case 61: {
                    this.openTemplateDelete();
                    break;
                }
                case 62: {
                    this.openTemplateApply();
                    break;
                }
                case 63: {
                    this.openTemplateShare();
                    break;
                }
                case 64: {
                    break;
                }
                case 65: {
                    break;
                }
                case 66: {
                    break;
                }
                case 67: {
                    break;
                }
                case 68: {
                    break;
                }
                case 69: {
                    break;
                }
                case 70: {
                    break;
                }
                case 71: {
                    break;
                }
                case 72: {
                    break;
                }
                case 73: {
                    break;
                }
                case 74: {
                    this.openCreateChart();
                    break;
                }
                case 75: {
                    this.openRStudio();
                    break;
                }
                case 76: {
                    this.openStatistical();
                    break;
                }
                case 77: {
                    break;
                }
                case 78: {
                    this.openCreateMapWizard();
                    break;
                }
                case 79: {
                    this.changeLanguage("en");
                    break;
                }
                case 80: {
                    this.changeLanguage("es");
                    break;
                }
                case 81: {
                    this.changeLanguage("it");
                    break;
                }
            }
        }
        catch (Throwable e) {
            Log.error((String)("doRibbonCommand Error : " + e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    private void doTasksMonitorCommand(TasksMonitorEvent event) {
        TaskType taskType = event.getTaskType();
        Log.debug((String)("Received TaskMonitorEvent: " + taskType));
        switch (40.$SwitchMap$org$gcube$portlets$user$td$widgetcommonevent$client$type$TaskType[taskType.ordinal()]) {
            case 1: {
                break;
            }
        }
    }

    private void doWidgetRequestCommand(WidgetRequestEvent event) {
        WidgetRequestType widgetRequestType = event.getWidgetRequestType();
        switch (40.$SwitchMap$org$gcube$portlets$user$td$widgetcommonevent$client$type$WidgetRequestType[widgetRequestType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.openBatchReplace(event.getTrId(), event.getRequestProperties());
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
        }
    }

    public void doBackgroundRequestCommand(BackgroundRequestEvent event) {
        BackgroundRequestType type = event.getBackgroundRequestType();
        Log.trace((String)("doBackgroundRequestEvent BackgroundRequestType: " + type));
        try {
            switch (40.$SwitchMap$org$gcube$portlets$user$td$widgetcommonevent$client$type$BackgroundRequestType[type.ordinal()]) {
                case 1: {
                    this.putInBackgroundUIState();
                    break;
                }
            }
        }
        catch (Throwable e) {
            Log.error((String)("doBackgroundRequestCommand Error : " + e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    private void openLogsWindow() {
        Log.debug((String)"Request Open Logs Window");
        TDMLogs tdmLogs = new TDMLogs((EventBus)this.eventBus);
        tdmLogs.show();
    }

    private void openBatchReplace(TRId trId, RequestProperties requestProperties) {
        Log.debug((String)("Request Open Batch Replace Dialog: " + trId + " " + requestProperties));
        if (trId != null) {
            ReplaceBatchDialog dialog = new ReplaceBatchDialog(trId, requestProperties, (EventBus)this.eventBus);
            dialog.show();
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openSDMXImportWizard() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openCSVExportWizard() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openJSONExportWizard() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openSDMXExportWizard() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openExtractCodelistWizard() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openCodelistMappingWizard() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openTableUnionWizard() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openReplaceByExternalColWizard() {
        this.openReplaceByExternalColWizard(null, null);
    }

    private void openReplaceByExternalColWizard(String columnLocalId, String columnname) {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openCreateChart() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openCreateMapWizard() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openTabularResource(boolean switchState) {
        Log.info((String)"Open Tabular Resources");
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openCSVImportWizard() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openTasksManagerWizard() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initTaskManager() {
        if (!this.taskManagerInit) {
            this.taskManagerInit = true;
            this.tdTaskController = TdTaskController.getInstance();
            TdTaskController.bindCommonBus((EventBus)this.eventBus);
            this.tdTaskMainWindow = this.tdTaskController.getWindowTaskMonitor();
        }
    }

    private void openTemplateNew() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openTemplateDelete() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openTemplateOpen() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openTemplateApply() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openTemplateShare() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openShareWindow() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openNewRule() {
        Log.debug((String)"Request Open New Rule Dialog");
        RuleDialog cfDialog = new RuleDialog((EventBus)this.eventBus);
        cfDialog.show();
    }

    private void openModifyRule() {
        Log.debug((String)"Request Open Modify Rule Dialog");
        RuleOpenDialog cfDialog = new RuleOpenDialog((EventBus)this.eventBus);
        cfDialog.show();
    }

    private void openDeleteRule() {
        Log.debug((String)"Request Open Delete Rule Dialog");
        RuleDeleteDialog cfDialog = new RuleDeleteDialog((EventBus)this.eventBus);
        cfDialog.show();
    }

    private void openApplyRule() {
        Log.debug((String)"Request Open Apply Rule Dialog");
        if (this.trId != null) {
            RuleApplyDialog raDialog = new RuleApplyDialog(this.trId, (EventBus)this.eventBus);
            raDialog.show();
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No current tabular resource present");
        }
    }

    private void openShareRule() {
        Log.debug((String)"Request Open Share Rule Dialog");
        RuleShareDialog cfDialog = new RuleShareDialog((EventBus)this.eventBus);
        cfDialog.show();
    }

    private void openRulesAppliedOnTabularResource() {
        Log.debug((String)"Request Open Rules Applied on TabularResource Dialog");
        if (this.trId != null) {
            RuleActiveDialog raDialog = new RuleActiveDialog(this.trId, (EventBus)this.eventBus);
            raDialog.show();
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No current tabular resource present");
        }
    }

    private void callDiscard() {
        HistoryDiscard historyDiscard = new HistoryDiscard((EventBus)this.eventBus);
        historyDiscard.discard();
    }

    private void openRStudio() {
        Log.debug((String)"Request Open RStudio");
        if (this.trId != null) {
            RStudio rStudio = new RStudio(this.trId, (EventBus)this.eventBus);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No current tabular resource present");
        }
    }

    private void openStatistical() {
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openMultiColumnFilter() {
        Log.debug((String)"Request Open Multi Column Filter Dialog");
        if (this.trId != null) {
            MultiColumnFilterDialog mcfDialog = new MultiColumnFilterDialog(this.trId, (EventBus)this.eventBus);
            mcfDialog.show();
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No current tabular resource present");
        }
    }

    private void openColumnFilter() {
        this.openColumnFilter(null, null);
    }

    private void openColumnFilter(String columnLocalId, String columnName) {
        Log.debug((String)"Request Open Column Filter Dialog");
        if (this.trId != null) {
            ColumnFilterDialog cfDialog = new ColumnFilterDialog(this.trId, columnLocalId, (EventBus)this.eventBus);
            cfDialog.show();
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No current tabular resource present");
        }
    }

    private void openRowsDeleteByExpression() {
        this.openRowsDeleteByExpression(null, null);
    }

    private void openRowsDeleteByExpression(String columnLocalId, String columnName) {
        Log.debug((String)"Request Open Row Delete By Expression Dialog");
        if (this.trId != null) {
            RowsDeleteByExpressionDialog cfDialog = new RowsDeleteByExpressionDialog(this.trId, columnLocalId, (EventBus)this.eventBus);
            cfDialog.show();
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No current tabular resource present");
        }
    }

    private void openColumnReplaceByExpression() {
        this.openColumnReplaceByExpression(null, null);
    }

    private void openColumnReplaceByExpression(String columnLocalId, String columnName) {
        Log.debug((String)"Request Open Replace Column By Expression Dialog");
        if (this.trId != null) {
            ReplaceColumnByExpressionDialog rceDialog = new ReplaceColumnByExpressionDialog(this.trId, columnLocalId, (EventBus)this.eventBus);
            rceDialog.show();
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No current tabular resource present");
        }
    }

    private void openChangeColumnType() {
        this.openChangeColumnType(null, null);
    }

    private void openChangeColumnType(String columnLocalId, String columnName) {
        Log.debug((String)"Request Change Column Type Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.CHANGECOLUMNTYPEPANEL);
            e.setTrId(this.trId);
            e.setColumnLocalId(columnLocalId);
            e.setColumnName(columnName);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No current tabular resource present");
        }
    }

    private void openNormalize() {
        this.openNormalize(null);
    }

    private void openNormalize(String columnName) {
        Log.debug((String)"Request Open Normalize Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.NORMALIZEPANEL);
            e.setTrId(this.trId);
            e.setColumnName(columnName);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No current tabular resource present");
        }
    }

    private void openDenormalize() {
        this.openDenormalize(null);
    }

    private void openDenormalize(String columnName) {
        Log.debug((String)"Request Open Denormalize Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.DENORMALIZEPANEL);
            e.setTrId(this.trId);
            e.setColumnName(columnName);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No current tabular resource present");
        }
    }

    private void cloneTabularResource() {
        CloneTabularResource cloneTR = new CloneTabularResource(this.trId, (EventBus)this.eventBus);
        cloneTR.cloneTR();
    }

    private void openColumnBatchReplace() {
        this.openColumnBatchReplace(null, null);
    }

    private void openColumnBatchReplace(String columnLocalId, String columnName) {
        Log.debug((String)"Request Open Batch Replace Dialog");
        if (this.trId != null) {
            ReplaceBatchDialog dialog = new ReplaceBatchDialog(this.trId, columnLocalId, (EventBus)this.eventBus);
            dialog.show();
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openColumnAdd() {
        this.openColumnAdd(null, null);
    }

    private void openColumnAdd(String columnLocalId, String columnName) {
        Log.debug((String)"Request Add Column Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.ADDCOLUMNPANEL);
            e.setTrId(this.trId);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openColumnDelete() {
        this.openColumnDelete(null, null);
    }

    private void openColumnDelete(String columnLocalId, String columnName) {
        Log.debug((String)"Request Delete Column Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.DELETECOLUMNPANEL);
            e.setTrId(this.trId);
            e.setColumnLocalId(columnLocalId);
            e.setColumnName(columnName);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openColumnSplit() {
        this.openColumnSplit(null, null);
    }

    private void openColumnSplit(String columnLocalId, String columnName) {
        Log.debug((String)"Request Split Column Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.SPLITCOLUMNPANEL);
            e.setTrId(this.trId);
            e.setColumnLocalId(columnLocalId);
            e.setColumnName(columnName);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openColumnMerge() {
        this.openColumnMerge(null, null);
    }

    private void openColumnMerge(String columnLocalId, String columnName) {
        Log.debug((String)"Request Merge Column Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.MERGECOLUMNPANEL);
            e.setTrId(this.trId);
            e.setColumnLocalId(columnLocalId);
            e.setColumnName(columnName);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openGroupBy() {
        this.openGroupBy(null);
    }

    private void openGroupBy(String columnName) {
        Log.debug((String)"Request Group By Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.GROUPBYPANEL);
            e.setTrId(this.trId);
            e.setColumnName(columnName);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openTimeAggregate() {
        this.openTimeAggregate(null);
    }

    private void openTimeAggregate(String columnName) {
        Log.debug((String)"Request Time Aggregate Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.TIMEAGGREGATIONPANEL);
            e.setTrId(this.trId);
            e.setColumnName(columnName);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openPositionColumn() {
        this.openPositionColumn(null, null);
    }

    private void openPositionColumn(String columnLocalId, String columnName) {
        Log.debug((String)"Request Position Column Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.POSITIONCOLUMNPANEL);
            e.setTrId(this.trId);
            e.setColumnLocalId(columnLocalId);
            e.setColumnName(columnName);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openColumnLabel() {
        this.openColumnLabel(null, null);
    }

    private void openColumnLabel(String columnLocalId, String columnName) {
        Log.debug((String)"Request Column Label Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.LABELCOLUMNPANEL);
            e.setTrId(this.trId);
            e.setColumnLocalId(columnLocalId);
            e.setColumnName(columnName);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openTableType() {
        Log.debug((String)"Request Change Table Type Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.CHANGETABLETYPEPANEL);
            e.setTrId(this.trId);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openDuplicatesRowsDetection() {
        Log.debug((String)"Request Duplicates Rows Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.DUPLICATESROWSDETECTIONPANEL);
            e.setTrId(this.trId);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openDuplicatesRowsDelete() {
        Log.debug((String)"Request Duplicates Rows Delete Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.DUPLICATESROWSDELETEPANEL);
            e.setTrId(this.trId);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openGeospatialCSquare() {
        Log.debug((String)"Request Geospatial Create C-Square Coordiantes Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.GEOSPATIALCREATECOORDINATESPANEL);
            e.setTrId(this.trId);
            HashMap<RequestPropertiesParameterType, GeospatialCoordinatesType> map = new HashMap<RequestPropertiesParameterType, GeospatialCoordinatesType>();
            map.put(RequestPropertiesParameterType.Coordinates, GeospatialCoordinatesType.C_SQUARE);
            RequestProperties requestProperties = new RequestProperties(map);
            e.setRequestProperties(requestProperties);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openGeospatialOceanArea() {
        Log.debug((String)"Request Geospatial Create Ocean Area Coordiantes Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.GEOSPATIALCREATECOORDINATESPANEL);
            e.setTrId(this.trId);
            HashMap<RequestPropertiesParameterType, GeospatialCoordinatesType> map = new HashMap<RequestPropertiesParameterType, GeospatialCoordinatesType>();
            map.put(RequestPropertiesParameterType.Coordinates, GeospatialCoordinatesType.OCEAN_AREA);
            RequestProperties requestProperties = new RequestProperties(map);
            e.setRequestProperties(requestProperties);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openGeometryCreatePoint() {
        Log.debug((String)"Request Geometry Create Point Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.GEOMETRYCREATEPOINTPANEL);
            e.setTrId(this.trId);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openDownscaleCSquare() {
        this.openDownscaleCSquare(null, null);
    }

    private void openDownscaleCSquare(String columnLocalId, String columnName) {
        Log.debug((String)"Request Downscale C-Square Tab");
        if (this.trId != null) {
            WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.DOWNSCALECSQUAREPANEL);
            e.setTrId(this.trId);
            e.setColumnLocalId(columnLocalId);
            e.setColumnName(columnName);
            this.eventBus.fireEvent((GwtEvent)e);
        } else {
            Log.error((String)"TRId is null");
            UtilsGXT3.alert((String)"Error", (String)"No tabular resource present");
        }
    }

    private void openBackgroundMonitor() {
        Log.debug((String)"Request Open Monitor Background Tab");
        WidgetRequestEvent e = new WidgetRequestEvent(WidgetRequestType.MONITORBACKGROUNDPANEL);
        this.eventBus.fireEvent((GwtEvent)e);
    }

    private void doChangeTableRequestEventCommand(ChangeTableRequestEvent event) {
        Log.debug((String)("Change Table Request: " + event));
        switch (40.$SwitchMap$org$gcube$portlets$user$td$widgetcommonevent$client$type$ChangeTableWhy[event.getWhy().ordinal()]) {
            case 1: {
                this.updateTableForCuration(event.getTrId());
                break;
            }
            case 2: {
                this.updateTable(event.getTrId());
                break;
            }
            case 3: {
                this.addActiveTabularResourceAndOpen(event.getTrId());
                break;
            }
        }
    }

    private void addActiveTabularResourceAndOpen(TRId trId) {
        Log.debug((String)("Add Active TabResource Search: " + trId));
        TDGWTServiceAsync.INSTANCE.getTabResourceInformation(trId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addActiveTabularResourceAndOpen(TabResource tabResource) {
        Log.debug((String)("Add Active TabResource: " + tabResource));
        TDGWTServiceAsync.INSTANCE.setTabResource(tabResource, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doRowAdd() {
        this.onRowAdd();
    }

    private void doRowsDelete() {
        ArrayList rows = this.mainBoxPanel.getSelectedRowsId();
        this.onRowsDelete(rows);
    }

    private void onRowsDelete(ArrayList<String> rows) {
        if (rows == null || rows.size() == 0) {
            UtilsGXT3.alert((String)"No rows selected", (String)"No rows selected");
        } else {
            DeleteRows deleteRows = new DeleteRows(this.trId, rows, (EventBus)this.eventBus);
            deleteRows.delete();
        }
    }

    private void onReplace(CellData cellData) {
        if (cellData == null) {
            UtilsGXT3.alert((String)"No cell selected", (String)"No cell selected");
        } else {
            ReplaceAllDialog replaceDialog = new ReplaceAllDialog(cellData, this.trId, (EventBus)this.eventBus);
            replaceDialog.show();
        }
    }

    private void onRowEdit(ArrayList<RowRaw> rowsRaw) {
        if (rowsRaw == null || rowsRaw.isEmpty()) {
            UtilsGXT3.alert((String)"No rows selected", (String)"No rows selected");
        } else {
            EditRowDialog editRowDialog = new EditRowDialog(this.trId, rowsRaw, (EventBus)this.eventBus);
            editRowDialog.show();
        }
    }

    private void onRowAdd() {
        EditRowDialog editRowDialog = new EditRowDialog(this.trId, (EventBus)this.eventBus);
        editRowDialog.show();
    }

    private void doGridContextMenuCommand(GridContextMenuItemEvent event) {
        Log.debug((String)"GridContextMenu Fire Event", (String)("OperationId: " + event.getGridOperationId()));
        GridOperationId gridOperationId = event.getGridOperationId();
        ArrayList rows = event.getRows();
        ArrayList rowsRaw = event.getRowsRaw();
        CellData cellData = event.getCellData();
        switch (40.$SwitchMap$org$gcube$portlets$user$td$widgetcommonevent$shared$GridOperationId[gridOperationId.ordinal()]) {
            case 1: {
                this.onRowAdd();
                break;
            }
            case 2: {
                this.onRowEdit(rowsRaw);
                break;
            }
            case 3: {
                this.onRowsDelete(rows);
                break;
            }
            case 4: {
                this.onReplace(cellData);
            }
        }
    }

    private void doSessionExpiredCommand(SessionExpiredEvent event) {
        Log.debug((String)("Session Expired Event: " + event.getSessionExpiredType()));
        this.sessionExpiredShow();
    }

    private void doDataViewActiveCommand(DataViewActiveEvent event) {
        Log.debug((String)("DataViewActive Event: " + event));
        switch (40.$SwitchMap$org$gcube$portlets$user$td$widgetcommonevent$client$type$DataViewActiveType[event.getDataViewActiveType().ordinal()]) {
            case 1: {
                this.doActiveAfterClose(event);
                break;
            }
            case 2: {
                this.doNewActive(event);
                break;
            }
            case 3: {
                this.doDataViewClose(event);
            }
        }
    }

    private void doGridHeaderColumnMenuCommand(GridHeaderColumnMenuItemEvent event) {
        Log.debug((String)"GridHeaderColumnMenu Fire Event", (String)("OperationId: " + event.getOperationId() + " Column: \n" + event.getColumnSelected()));
        String opId = event.getOperationId();
        String columnLocalId = this.mainBoxPanel.getColumnLocalId(event.getColumnSelected());
        String columnName = this.mainBoxPanel.getColumnName(event.getColumnSelected());
        Log.debug((String)("Selected column[ColumnLocalId: " + columnLocalId + ", ColumnName: " + columnName + "]"));
        if (opId.compareTo(GridHeaderOperationId.COLUMNPOSITION.toString()) == 0) {
            this.openPositionColumn(columnLocalId, columnName);
        } else if (opId.compareTo(GridHeaderOperationId.COLUMNLABEL.toString()) == 0) {
            this.openColumnLabel(columnLocalId, columnName);
        } else if (opId.compareTo(GridHeaderOperationId.COLUMNADD.toString()) == 0) {
            this.openColumnAdd(columnLocalId, columnName);
        } else if (opId.compareTo(GridHeaderOperationId.COLUMNBATCHREPLACE.toString()) == 0) {
            this.openColumnBatchReplace(columnLocalId, columnName);
        } else if (opId.compareTo(GridHeaderOperationId.COLUMNDELETE.toString()) == 0) {
            this.openColumnDelete(columnLocalId, columnName);
        } else if (opId.compareTo(GridHeaderOperationId.COLUMNTYPE.toString()) == 0) {
            this.openChangeColumnType(columnLocalId, columnName);
        } else if (opId.compareTo(GridHeaderOperationId.COLUMNFILTER.toString()) == 0) {
            this.openColumnFilter(columnLocalId, columnName);
        } else if (opId.compareTo(GridHeaderOperationId.ANNOTATIONADD.toString()) != 0 && opId.compareTo(GridHeaderOperationId.DUPLICATEDETECTION.toString()) != 0) {
            if (opId.compareTo(GridHeaderOperationId.COLUMNSPLIT.toString()) == 0) {
                this.openColumnSplit(columnLocalId, columnName);
            } else if (opId.compareTo(GridHeaderOperationId.COLUMNMERGE.toString()) == 0) {
                this.openColumnMerge(columnLocalId, columnName);
            } else if (opId.compareTo(GridHeaderOperationId.COLUMNREPLACEBYEXPRESSION.toString()) == 0) {
                this.openColumnReplaceByExpression(columnLocalId, columnName);
            } else if (opId.compareTo(GridHeaderOperationId.COLUMNREPLACEBYEXTERNAL.toString()) == 0) {
                this.openReplaceByExternalColWizard(columnLocalId, columnName);
            } else if (opId.compareTo(GridHeaderOperationId.DOWNSCALECSQUARE.toString()) == 0) {
                this.openDownscaleCSquare(columnLocalId, columnName);
            }
        }
    }

    private void asyncCodeLoadingFailed(Throwable reason) {
        Log.error((String)"Async code loading failed", (Throwable)reason);
        this.eventBus.fireEvent((GwtEvent)new SessionExpiredEvent(SessionExpiredType.EXPIREDONSERVER));
    }

    static /* synthetic */ void access$000(TabularDataController x0) {
        x0.sessionExpiredShowDelayed();
    }

    static /* synthetic */ UserInfo access$102(TabularDataController x0, UserInfo x1) {
        x0.userInfo = x1;
        return x0.userInfo;
    }

    static /* synthetic */ void access$200(TabularDataController x0) {
        x0.sessionExpiredShow();
    }

    static /* synthetic */ void access$300(TabularDataController x0, SessionExpiredEvent x1) {
        x0.doSessionExpiredCommand(x1);
    }

    static /* synthetic */ void access$400(TabularDataController x0, DataViewActiveEvent x1) {
        x0.doDataViewActiveCommand(x1);
    }

    static /* synthetic */ void access$500(TabularDataController x0, GridHeaderColumnMenuItemEvent x1) {
        x0.doGridHeaderColumnMenuCommand(x1);
    }

    static /* synthetic */ void access$600(TabularDataController x0, GridContextMenuItemEvent x1) {
        x0.doGridContextMenuCommand(x1);
    }

    static /* synthetic */ void access$700(TabularDataController x0, ChangeTableRequestEvent x1) {
        x0.doChangeTableRequestEventCommand(x1);
    }

    static /* synthetic */ void access$800(TabularDataController x0, TasksMonitorEvent x1) {
        x0.doTasksMonitorCommand(x1);
    }

    static /* synthetic */ void access$900(TabularDataController x0, WidgetRequestEvent x1) {
        x0.doWidgetRequestCommand(x1);
    }

    static /* synthetic */ SimpleEventBus access$1000(TabularDataController x0) {
        return x0.eventBus;
    }

    static /* synthetic */ void access$1100(TabularDataController x0, TRId x1) {
        x0.openTable(x1);
    }

    static /* synthetic */ void access$1200(TabularDataController x0) {
        x0.doOpenTRIdAfterServerUpdate();
    }

    static /* synthetic */ TRId access$1302(TabularDataController x0, TRId x1) {
        x0.openTRIdAfterServerUpdate = x1;
        return x0.openTRIdAfterServerUpdate;
    }

    static /* synthetic */ TRId access$1400(TabularDataController x0) {
        return x0.trId;
    }

    static /* synthetic */ void access$1500(TabularDataController x0) {
        x0.requestCloseCurrent();
    }

    static /* synthetic */ void access$1600(TabularDataController x0) {
        x0.openWizard();
    }

    static /* synthetic */ void access$1700(TabularDataController x0) {
        x0.resumeUIState();
    }

    static /* synthetic */ void access$1800(TabularDataController x0, Throwable x1) {
        x0.asyncCodeLoadingFailed(x1);
    }

    static /* synthetic */ UserInfo access$100(TabularDataController x0) {
        return x0.userInfo;
    }

    static /* synthetic */ void access$1900(TabularDataController x0) {
        x0.initTaskManager();
    }

    static /* synthetic */ Window access$2000(TabularDataController x0) {
        return x0.tdTaskMainWindow;
    }

    static /* synthetic */ TdTaskController access$2100(TabularDataController x0) {
        return x0.tdTaskController;
    }

    static /* synthetic */ void access$2200(TabularDataController x0, TabResource x1) {
        x0.addActiveTabularResourceAndOpen(x1);
    }
}

