/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.client.rule;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.core.client.dom.ScrollSupport;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.filters.Filter;
import com.sencha.gxt.widget.core.client.grid.filters.GridFilters;
import com.sencha.gxt.widget.core.client.grid.filters.StringFilter;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.client.rule.RuleActiveDialog;
import org.gcube.portlets.user.td.client.rule.RuleInfoDialog;
import org.gcube.portlets.user.td.expressionwidget.client.rpc.ExpressionServiceAsync;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.RuleDescriptionDataProperties;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.rule.AppliedRulesResponseData;
import org.gcube.portlets.user.td.gwtservice.shared.rule.DetachColumnRulesSession;
import org.gcube.portlets.user.td.gwtservice.shared.rule.RuleDescriptionData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnData;

public class RuleActivePanel
extends FramedPanel {
    private static final int RULE_ON_COLUMN_FIELDSET_HEIGHT = 348;
    private static final String RULES_GRID_HEIGHT = "102px";
    private static final String WIDTH = "630px";
    private static final String HEIGHT = "418px";
    private EventBus eventBus;
    private RuleActiveDialog parent;
    private TRId trId;
    private ArrayList<ColumnData> columns;
    private AppliedRulesResponseData appliedRuleResponseData;
    private TextButton btnClose;
    private VerticalLayoutContainer mainLayoutContainer;

    public RuleActivePanel(RuleActiveDialog parent, TRId trId, EventBus eventBus) {
        this.parent = parent;
        this.trId = trId;
        Log.debug((String)"RuleActivePanel");
        this.setWidth(WIDTH);
        this.setHeight(HEIGHT);
        this.setHeaderVisible(false);
        this.setBodyBorder(false);
        this.eventBus = eventBus;
        this.retrieveColumns();
    }

    protected void retrieveColumns() {
        TDGWTServiceAsync.INSTANCE.getColumns(this.trId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void create() {
        Log.debug((String)("Create RuleActivePanel(): " + this.trId));
        FieldSet columnRulesFieldSet = new FieldSet();
        columnRulesFieldSet.setHeadingText("Rules On Column");
        columnRulesFieldSet.setCollapsible(false);
        VerticalLayoutContainer columnRulesFieldSetLayout = new VerticalLayoutContainer();
        columnRulesFieldSetLayout.setScrollMode(ScrollSupport.ScrollMode.AUTO);
        columnRulesFieldSetLayout.setAdjustForScroll(true);
        columnRulesFieldSet.add((Widget)columnRulesFieldSetLayout);
        HashMap columnRuleMapping = this.appliedRuleResponseData.getColumnRuleMapping();
        if (columnRuleMapping != null && columnRuleMapping.size() > 0) {
            for (ColumnData column : this.columns) {
                ArrayList columnAppliedRules = (ArrayList)columnRuleMapping.get(column.getColumnId());
                if (columnAppliedRules == null || columnAppliedRules.size() <= 0) continue;
                FieldLabel columnLabel = this.createColumnRules(column, columnAppliedRules);
                columnRulesFieldSetLayout.add((IsWidget)columnLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
            }
        } else {
            FieldLabel noRulesLabel = new FieldLabel(null, "No rules applied!");
            noRulesLabel.setLabelSeparator("");
            columnRulesFieldSetLayout.add((IsWidget)noRulesLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        }
        this.btnClose = new TextButton("Close");
        this.btnClose.setIcon(TabularDataResources.INSTANCE.close());
        this.btnClose.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.btnClose.setToolTip("Close");
        this.btnClose.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
        flowButton.setHBoxLayoutAlign(HBoxLayoutContainer.HBoxLayoutAlign.MIDDLE);
        flowButton.setPack(BoxLayoutContainer.BoxLayoutPack.CENTER);
        flowButton.add((IsWidget)this.btnClose, new BoxLayoutContainer.BoxLayoutData(new Margins(2, 4, 2, 4)));
        this.mainLayoutContainer = new VerticalLayoutContainer();
        this.mainLayoutContainer.add((IsWidget)columnRulesFieldSet, new VerticalLayoutContainer.VerticalLayoutData(-1.0, 348.0, new Margins(0)));
        this.mainLayoutContainer.add((IsWidget)flowButton, new VerticalLayoutContainer.VerticalLayoutData(1.0, 36.0, new Margins(5, 2, 5, 2)));
        this.add((Widget)this.mainLayoutContainer);
    }

    private FieldLabel createColumnRules(ColumnData column, ArrayList<RuleDescriptionData> columnAppliedRules) {
        RuleDescriptionDataProperties propsRules = (RuleDescriptionDataProperties)GWT.create(RuleDescriptionDataProperties.class);
        ColumnConfig nameCol = new ColumnConfig(propsRules.name(), 120, "Name");
        nameCol.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ColumnConfig descriptionCol = new ColumnConfig(propsRules.description(), 120, "Description");
        descriptionCol.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ColumnConfig ownerCol = new ColumnConfig(propsRules.ownerLogin(), 70, "Owner");
        ownerCol.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<ColumnConfig> l = new ArrayList<ColumnConfig>();
        l.add(nameCol);
        l.add(descriptionCol);
        l.add(ownerCol);
        ColumnModel cm = new ColumnModel(l);
        StringFilter nameFilter = new StringFilter(propsRules.name());
        StringFilter descriptionFilter = new StringFilter(propsRules.description());
        ListStore appliedRulesStore = new ListStore(propsRules.id());
        if (columnAppliedRules != null && columnAppliedRules.size() > 0) {
            appliedRulesStore.addAll(columnAppliedRules);
        }
        Grid gridAppliedRules = new Grid(appliedRulesStore, cm);
        gridAppliedRules.setItemId(column.getColumnId());
        gridAppliedRules.setHeight(RULES_GRID_HEIGHT);
        gridAppliedRules.getView().setStripeRows(true);
        gridAppliedRules.getView().setColumnLines(true);
        gridAppliedRules.getView().setAutoFill(true);
        gridAppliedRules.setBorders(false);
        gridAppliedRules.setLoadMask(true);
        gridAppliedRules.setColumnReordering(true);
        gridAppliedRules.setColumnResize(true);
        gridAppliedRules.getView().setAutoExpandColumn(descriptionCol);
        GridFilters filtersAppliesRules = new GridFilters();
        filtersAppliesRules.initPlugin(gridAppliedRules);
        filtersAppliesRules.setLocal(true);
        filtersAppliesRules.addFilter((Filter)nameFilter);
        filtersAppliesRules.addFilter((Filter)descriptionFilter);
        this.createContextMenu(gridAppliedRules);
        FieldLabel rulesAppliedLabel = new FieldLabel((IsWidget)gridAppliedRules, column.getLabel());
        return rulesAppliedLabel;
    }

    protected void getActiveRulesOnColumn() {
        ExpressionServiceAsync.INSTANCE.getActiveRulesByTabularResourceId(this.trId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void updateActiveRulesOnColumn() {
        ExpressionServiceAsync.INSTANCE.getActiveRulesByTabularResourceId(this.trId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void close() {
        this.parent.close();
    }

    protected void requestInfo(RuleDescriptionData rule) {
        RuleInfoDialog infoRuleDialog = new RuleInfoDialog(rule);
        infoRuleDialog.show();
    }

    protected void createContextMenu(Grid<RuleDescriptionData> grid) {
        Menu contextMenu = new Menu();
        MenuItem infoItem = new MenuItem();
        infoItem.setText("Info");
        infoItem.setToolTip("Info");
        infoItem.setIcon(TabularDataResources.INSTANCE.information());
        infoItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        MenuItem detachItem = new MenuItem();
        detachItem.setText("Detach");
        detachItem.setToolTip("Detach rule");
        detachItem.setIcon(TabularDataResources.INSTANCE.ruleColumnDetach());
        detachItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        contextMenu.add((Widget)infoItem);
        contextMenu.add((Widget)detachItem);
        grid.setContextMenu(contextMenu);
    }

    protected void requestDetach(RuleDescriptionData selected, Grid<RuleDescriptionData> grid) {
        String columnLocalId = grid.getItemId();
        ColumnData columnData = new ColumnData();
        columnData.setColumnId(columnLocalId);
        ArrayList<RuleDescriptionData> detachRules = new ArrayList<RuleDescriptionData>();
        detachRules.add(selected);
        DetachColumnRulesSession detachColumnRulesSession = new DetachColumnRulesSession(this.trId, columnData, detachRules);
        ExpressionServiceAsync.INSTANCE.setDetachColumnRules(detachColumnRulesSession, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void recreate() {
        this.remove((Widget)this.mainLayoutContainer);
        this.create();
        this.forceLayout();
    }

    static /* synthetic */ EventBus access$000(RuleActivePanel x0) {
        return x0.eventBus;
    }

    static /* synthetic */ ArrayList access$102(RuleActivePanel x0, ArrayList x1) {
        x0.columns = x1;
        return x0.columns;
    }

    static /* synthetic */ AppliedRulesResponseData access$202(RuleActivePanel x0, AppliedRulesResponseData x1) {
        x0.appliedRuleResponseData = x1;
        return x0.appliedRuleResponseData;
    }
}

