/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.client.rule;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.dnd.core.client.GridDragSource;
import com.sencha.gxt.dnd.core.client.GridDropTarget;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.filters.Filter;
import com.sencha.gxt.widget.core.client.grid.filters.GridFilters;
import com.sencha.gxt.widget.core.client.grid.filters.StringFilter;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.client.rule.RuleApplyDialog;
import org.gcube.portlets.user.td.client.rule.RuleInfoDialog;
import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnDataPropertiesCombo;
import org.gcube.portlets.user.td.expressionwidget.client.rpc.ExpressionServiceAsync;
import org.gcube.portlets.user.td.expressionwidget.shared.rule.RuleDescriptionDataProperties;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.rule.AppliedRulesResponseData;
import org.gcube.portlets.user.td.gwtservice.shared.rule.ApplyAndDetachColumnRulesSession;
import org.gcube.portlets.user.td.gwtservice.shared.rule.RuleDescriptionData;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnData;

public class RuleApplyPanel
extends FramedPanel {
    private static final String RULE_TIP = "<p>Tip.: Use drag and drop in order to change selected rules.</p>";
    private static final String RULES_GRID_HEIGHT = "184px";
    private static final String SET_RULES = "SetRules";
    private static final String WIDTH = "630px";
    private static final String HEIGHT = "520px";
    private EventBus eventBus;
    private RuleApplyDialog parent;
    private TRId trId;
    private ArrayList<ColumnData> columns;
    private ColumnData column;
    private AppliedRulesResponseData appliedRuleResponseData;
    private ArrayList<RuleDescriptionData> applicableRules;
    private ArrayList<RuleDescriptionData> appliedRules;
    private TextButton btnApply;
    private TextButton btnClose;
    private ComboBox<ColumnData> comboColumns;
    private ListStore<RuleDescriptionData> applicableRulesStore;
    private Grid<RuleDescriptionData> gridApplicableRules;
    private ListStore<RuleDescriptionData> selectedRulesStore;
    private Grid<RuleDescriptionData> gridSelectedRules;

    public RuleApplyPanel(RuleApplyDialog parent, TRId trId, EventBus eventBus) {
        this.parent = parent;
        this.trId = trId;
        this.applicableRules = new ArrayList();
        Log.debug((String)"RuleApplyPanel");
        this.setWidth(WIDTH);
        this.setHeight(HEIGHT);
        this.setHeaderVisible(false);
        this.setBodyBorder(false);
        this.eventBus = eventBus;
        this.retrieveColumns();
    }

    protected void retrieveColumns() {
        TDGWTServiceAsync.INSTANCE.getColumns(this.trId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void create() {
        Log.debug((String)("Create RuleApplyPanel(): " + this.trId));
        FieldSet configurationFieldSet = new FieldSet();
        configurationFieldSet.setHeadingText("Configuration");
        configurationFieldSet.setCollapsible(false);
        VerticalLayoutContainer configurationFieldSetLayout = new VerticalLayoutContainer();
        configurationFieldSet.add((Widget)configurationFieldSetLayout);
        ColumnDataPropertiesCombo propsColumnData = (ColumnDataPropertiesCombo)GWT.create(ColumnDataPropertiesCombo.class);
        ListStore storeCombo = new ListStore(propsColumnData.id());
        storeCombo.addAll((Collection)this.columns);
        Log.trace((String)"StoreCombo created");
        this.comboColumns = new ComboBox(storeCombo, propsColumnData.label());
        Log.trace((String)"Combo ColumnData created");
        this.addHandlersForComboColumn(propsColumnData.label());
        this.comboColumns.setEmptyText("Select a column...");
        this.comboColumns.setWidth(191);
        this.comboColumns.setTypeAhead(false);
        this.comboColumns.setEditable(false);
        this.comboColumns.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        FieldLabel comboColumnsLabel = new FieldLabel((IsWidget)this.comboColumns, "Column");
        configurationFieldSetLayout.add((IsWidget)comboColumnsLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        RuleDescriptionDataProperties propsRules = (RuleDescriptionDataProperties)GWT.create(RuleDescriptionDataProperties.class);
        ColumnConfig nameCol = new ColumnConfig(propsRules.name(), 120, "Name");
        nameCol.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ColumnConfig descriptionCol = new ColumnConfig(propsRules.description(), 120, "Description");
        descriptionCol.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ColumnConfig ownerCol = new ColumnConfig(propsRules.ownerLogin(), 70, "Owner");
        ownerCol.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<ColumnConfig> l = new ArrayList<ColumnConfig>();
        l.add(nameCol);
        l.add(descriptionCol);
        l.add(ownerCol);
        ColumnModel cm = new ColumnModel(l);
        StringFilter nameFilter = new StringFilter(propsRules.name());
        StringFilter descriptionFilter = new StringFilter(propsRules.description());
        this.applicableRulesStore = new ListStore(propsRules.id());
        this.gridApplicableRules = new Grid(this.applicableRulesStore, cm);
        this.gridApplicableRules.setHeight(RULES_GRID_HEIGHT);
        this.gridApplicableRules.getView().setStripeRows(true);
        this.gridApplicableRules.getView().setColumnLines(true);
        this.gridApplicableRules.getView().setAutoFill(true);
        this.gridApplicableRules.setBorders(false);
        this.gridApplicableRules.setLoadMask(true);
        this.gridApplicableRules.setColumnReordering(true);
        this.gridApplicableRules.setColumnResize(true);
        this.gridApplicableRules.getView().setAutoExpandColumn(descriptionCol);
        GridFilters filtersApplicableRules = new GridFilters();
        filtersApplicableRules.initPlugin(this.gridApplicableRules);
        filtersApplicableRules.setLocal(true);
        filtersApplicableRules.addFilter((Filter)nameFilter);
        filtersApplicableRules.addFilter((Filter)descriptionFilter);
        this.createContextMenu(this.gridApplicableRules);
        this.selectedRulesStore = new ListStore(propsRules.id());
        this.gridSelectedRules = new Grid(this.selectedRulesStore, cm);
        this.gridSelectedRules.setHeight(RULES_GRID_HEIGHT);
        this.gridSelectedRules.getView().setStripeRows(true);
        this.gridSelectedRules.getView().setColumnLines(true);
        this.gridSelectedRules.getView().setAutoFill(true);
        this.gridSelectedRules.setBorders(false);
        this.gridSelectedRules.setLoadMask(true);
        this.gridSelectedRules.setColumnReordering(true);
        this.gridSelectedRules.setColumnResize(true);
        this.gridSelectedRules.getView().setAutoExpandColumn(descriptionCol);
        GridFilters filtersSelectedRules = new GridFilters();
        filtersSelectedRules.initPlugin(this.gridSelectedRules);
        filtersSelectedRules.setLocal(true);
        filtersSelectedRules.addFilter((Filter)nameFilter);
        filtersSelectedRules.addFilter((Filter)descriptionFilter);
        this.createContextMenu(this.gridSelectedRules);
        new GridDragSource(this.gridApplicableRules).setGroup(SET_RULES);
        new GridDragSource(this.gridSelectedRules).setGroup(SET_RULES);
        new GridDropTarget(this.gridApplicableRules).setGroup(SET_RULES);
        new GridDropTarget(this.gridSelectedRules).setGroup(SET_RULES);
        FieldLabel rulesApplicableLabel = new FieldLabel((IsWidget)this.gridApplicableRules, "Applicable Rules");
        configurationFieldSetLayout.add((IsWidget)rulesApplicableLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        FieldLabel rulesSelectedLabel = new FieldLabel((IsWidget)this.gridSelectedRules, "Selected Rules");
        configurationFieldSetLayout.add((IsWidget)rulesSelectedLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        HTML rulesNote = new HTML(RULE_TIP);
        configurationFieldSetLayout.add((IsWidget)rulesNote, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        this.btnApply = new TextButton("Apply");
        this.btnApply.setIcon(TabularDataResources.INSTANCE.ruleColumnApply());
        this.btnApply.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.btnApply.setToolTip("Apply Rule");
        this.btnApply.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.btnClose = new TextButton("Close");
        this.btnClose.setIcon(TabularDataResources.INSTANCE.close());
        this.btnClose.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.btnClose.setToolTip("Close");
        this.btnClose.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
        flowButton.setHBoxLayoutAlign(HBoxLayoutContainer.HBoxLayoutAlign.MIDDLE);
        flowButton.setPack(BoxLayoutContainer.BoxLayoutPack.CENTER);
        flowButton.add((IsWidget)this.btnApply, new BoxLayoutContainer.BoxLayoutData(new Margins(2, 4, 2, 4)));
        flowButton.add((IsWidget)this.btnClose, new BoxLayoutContainer.BoxLayoutData(new Margins(2, 4, 2, 4)));
        VerticalLayoutContainer v = new VerticalLayoutContainer();
        v.add((IsWidget)configurationFieldSet, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        v.add((IsWidget)flowButton, new VerticalLayoutContainer.VerticalLayoutData(1.0, 36.0, new Margins(5, 2, 5, 2)));
        this.add((Widget)v);
    }

    private void addHandlersForComboColumn(LabelProvider<ColumnData> labelProvider) {
        this.comboColumns.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void updateRulesInGrids(ColumnData columnData) {
        ArrayList applied;
        this.column = columnData;
        this.applicableRulesStore.clear();
        this.selectedRulesStore.clear();
        HashMap columnRuleMapping = this.appliedRuleResponseData.getColumnRuleMapping();
        if (columnRuleMapping != null && (applied = (ArrayList)columnRuleMapping.get(columnData.getColumnId())) != null) {
            this.appliedRules = applied;
            this.selectedRulesStore.addAll(new ArrayList(applied));
        }
        this.getApplicableBaseColumnRules();
    }

    protected void getApplicableBaseColumnRules() {
        ExpressionServiceAsync.INSTANCE.getApplicableBaseColumnRules(this.column, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void getAppliedBaseColumnRules() {
        ExpressionServiceAsync.INSTANCE.getActiveRulesByTabularResourceId(this.trId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected ArrayList<RuleDescriptionData> getSelectedItems() {
        List selectedItems = this.selectedRulesStore.getAll();
        ArrayList<RuleDescriptionData> rulesSelected = new ArrayList<RuleDescriptionData>(selectedItems);
        return rulesSelected;
    }

    protected void apply() {
        ColumnData column = (ColumnData)this.comboColumns.getCurrentValue();
        if (column != null) {
            ArrayList rulesApplied;
            ArrayList selectedRules = this.getSelectedItems();
            if (selectedRules == null) {
                selectedRules = new ArrayList();
            }
            ArrayList<RuleDescriptionData> rulesThatWillBeDetach = new ArrayList<RuleDescriptionData>();
            ArrayList<RuleDescriptionData> rulesThatWillBeApplied = new ArrayList<RuleDescriptionData>();
            HashMap columnRuleMapping = this.appliedRuleResponseData.getColumnRuleMapping();
            if (columnRuleMapping != null && (rulesApplied = (ArrayList)columnRuleMapping.get(column.getColumnId())) != null && rulesApplied.size() > 0) {
                for (RuleDescriptionData ruleApplied : rulesApplied) {
                    boolean ruleStillApplied = false;
                    for (RuleDescriptionData ruleSelected : selectedRules) {
                        if (ruleSelected.getId() != ruleApplied.getId()) continue;
                        ruleStillApplied = true;
                        break;
                    }
                    if (ruleStillApplied) continue;
                    rulesThatWillBeDetach.add(ruleApplied);
                }
            }
            for (RuleDescriptionData ruleSelected : selectedRules) {
                ArrayList rulesApplied2;
                boolean ruleApplied = false;
                if (columnRuleMapping != null && (rulesApplied2 = (ArrayList)columnRuleMapping.get(column.getColumnId())) != null) {
                    for (RuleDescriptionData ruleAlreadyApplied : rulesApplied2) {
                        if (ruleSelected.getId() != ruleAlreadyApplied.getId()) continue;
                        ruleApplied = true;
                        break;
                    }
                }
                if (ruleApplied) continue;
                rulesThatWillBeApplied.add(ruleSelected);
            }
            if (rulesThatWillBeApplied.size() <= 0 && rulesThatWillBeDetach.size() <= 0) {
                Log.error((String)"Select a rule!");
                UtilsGXT3.alert((String)"Attention", (String)"Select a rule!");
                return;
            }
            ApplyAndDetachColumnRulesSession applyColumnRulesSession = new ApplyAndDetachColumnRulesSession(this.trId, column, rulesThatWillBeApplied, rulesThatWillBeDetach);
            this.parent.applyRules(applyColumnRulesSession);
        } else {
            Log.error((String)"No column selected");
            UtilsGXT3.alert((String)"Attention", (String)"Select a column");
        }
    }

    protected void close() {
        this.parent.close();
    }

    protected void requestInfo(RuleDescriptionData rule) {
        RuleInfoDialog infoRuleDialog = new RuleInfoDialog(rule);
        infoRuleDialog.show();
    }

    protected void createContextMenu(Grid<RuleDescriptionData> grid) {
        Menu contextMenu = new Menu();
        MenuItem infoItem = new MenuItem();
        infoItem.setText("Info");
        infoItem.setIcon(TabularDataResources.INSTANCE.information());
        infoItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        contextMenu.add((Widget)infoItem);
        grid.setContextMenu(contextMenu);
    }

    static /* synthetic */ EventBus access$000(RuleApplyPanel x0) {
        return x0.eventBus;
    }

    static /* synthetic */ ArrayList access$102(RuleApplyPanel x0, ArrayList x1) {
        x0.columns = x1;
        return x0.columns;
    }

    static /* synthetic */ ArrayList access$200(RuleApplyPanel x0) {
        return x0.appliedRules;
    }

    static /* synthetic */ ArrayList access$302(RuleApplyPanel x0, ArrayList x1) {
        x0.applicableRules = x1;
        return x0.applicableRules;
    }

    static /* synthetic */ ArrayList access$300(RuleApplyPanel x0) {
        return x0.applicableRules;
    }

    static /* synthetic */ ListStore access$400(RuleApplyPanel x0) {
        return x0.applicableRulesStore;
    }

    static /* synthetic */ AppliedRulesResponseData access$502(RuleApplyPanel x0, AppliedRulesResponseData x1) {
        x0.appliedRuleResponseData = x1;
        return x0.appliedRuleResponseData;
    }
}

