/**
 * 
 */
package org.gcube.portlets.user.td.openwidget.client;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.wizardwidget.client.WizardCard;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class TabResourcesSelectionCard extends WizardCard {
	protected final String GRIDWIDTH = "538px";
	protected final String GRIDHEIGHT = "430px";
	
	protected TabResourcesSelectionCard thisCard;
	protected TDOpenSession tdOpenSession;
	protected TabResourcesSelectionPanel tabResourcesSelectionPanel;
	protected TabResource selectedTabResource = null;

	public TabResourcesSelectionCard(final TDOpenSession tdOpenSession) {
		super("Select a Tabular Resource", "");

		this.tdOpenSession = tdOpenSession;
		thisCard = this;

		tabResourcesSelectionPanel = new TabResourcesSelectionPanel(res);

		//tabResourcesSelectionPanel.setResize(false);
		//tabResourcesSelectionPanel.setSize(GRIDWIDTH, GRIDHEIGHT);
		
		tabResourcesSelectionPanel
				.addSelectionHandler(new SelectionHandler<TabResource>() {

					
					public void onSelection(SelectionEvent<TabResource> event) {
						tdOpenSession
								.setSelectedTabResource(tabResourcesSelectionPanel
										.getSelectedItem());
						getWizardWindow().setEnableNextButton(true);
					}

				});

		setContent(tabResourcesSelectionPanel);

	}

	@Override
	public void setup() {
		Command sayFinish = new Command() {

			public void execute() {
				
				TDGWTServiceAsync.INSTANCE.setTabResource(tdOpenSession
						.getSelectedTabResource(),
						new AsyncCallback<Void>() {
							public void onFailure(Throwable caught) {
								AlertMessageBox d = new AlertMessageBox(
										"Error", "Error on set TabResource: "
												+ caught.getLocalizedMessage());
								d.addHideHandler(new HideHandler() {

									public void onHide(HideEvent event) {
										// TODO Auto-generated method stub

									}

								});
								d.show();

							}

							public void onSuccess(Void result) {
								getWizardWindow().fireCompleted(tdOpenSession
										.getSelectedTabResource().getTrId());
								getWizardWindow().close(false);
								Log.info("OpenTD Tabular Resource selected :" + tdOpenSession
										.getSelectedTabResource());
							}

						});
				
			
			}

		};

		getWizardWindow().setNextButtonCommand(sayFinish);
		//getWizardWindow().setFinishCommand(sayFinish);

	}

}
