package org.gcube.portlets.user.td.sharewidget.client;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.share.Contacts;
import org.gcube.portlets.user.td.gwtservice.shared.share.ShareInfo;
import org.gcube.portlets.user.td.sharewidget.client.util.InfoMessageBox;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ChangeTableRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableWhy;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.widgets.workspacesharingwidget.client.WorkspaceSmartSharingController;
import org.gcube.portlets.widgets.workspacesharingwidget.client.view.sharing.SmartShare;
import org.gcube.portlets.widgets.workspacesharingwidget.shared.CredentialModel;
import org.gcube.portlets.widgets.workspacesharingwidget.shared.FileModel;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class TRShare {
	private TRId trId;

	private EventBus eventBus;
	private ShareInfo shareInfo;

	public TRShare(TRId trId, EventBus eventBus) {
		this.trId = trId;
		this.eventBus = eventBus;

		retrieveInfo();

	}

	protected void retrieveInfo() {
		TDGWTServiceAsync.INSTANCE.getShareInfo(trId,
				new AsyncCallback<ShareInfo>() {

					public void onFailure(Throwable caught) {
						Log.debug("ShareInfo Error: "
								+ caught.getLocalizedMessage());
						alert("Error retrienving share info",
								"Error retrieving share info");

					}

					public void onSuccess(ShareInfo result) {
						shareInfo = result;
						shareWindow();
					}

				});
	}

	/**
	 * Call Window
	 */
	protected void shareWindow() {

		FileModel file = new FileModel(shareInfo.getTabResource().getTrId()
				.getId(), shareInfo.getTabResource().getName(), false);

		List<CredentialModel> listAlreadySharedContact = new ArrayList<CredentialModel>();
		for (Contacts contacts : shareInfo.getContacts()) {
			CredentialModel cm = new CredentialModel(null, contacts.getLogin(),
					false);
			listAlreadySharedContact.add(cm);
		}

		WorkspaceSmartSharingController controller = new WorkspaceSmartSharingController(
				file, listAlreadySharedContact,false,true);

		final SmartShare sharingWindow = controller.getSharingDialog();

		sharingWindow.show();

		sharingWindow.getButtonById(Dialog.OK).addListener(Events.Select,
				new Listener<BaseEvent>() {

					@Override
					public void handleEvent(BaseEvent be) {

						if (sharingWindow.isValidForm(true)) {
							shareCall(sharingWindow
									.getSharedListUsersCredential());

						}

					}
				});

	}

	protected void shareCall(List<CredentialModel> credentials) {
		ArrayList<Contacts> listContacts = new ArrayList<Contacts>();
		for (CredentialModel cred : credentials) {
			Contacts cont = new Contacts(cred.getId(), cred.getLogin(),
					cred.isGroup());
			listContacts.add(cont);
		}

		shareInfo.setContacts(listContacts);

		TDGWTServiceAsync.INSTANCE.setShare(shareInfo,
				new AsyncCallback<Void>() {

					public void onFailure(Throwable caught) {
						Log.debug("Share Error: "
								+ caught.getLocalizedMessage());
						alert("Error sharing tabular resource",
								"Error sharing tabular resource: "+caught.getLocalizedMessage());

					}

					public void onSuccess(Void result) {
						Log.debug("Tabular Resource Shared: "
								+ shareInfo.getTabResource().getTrId()
										.toString());
						info("Shared",
								"Tabular Resource is shared");
						
						ChangeTableWhy why = ChangeTableWhy.TABLEUPDATED;
						ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
								ChangeTableRequestType.SHARE, trId, why);
						eventBus.fireEvent(changeTableRequestEvent);
						
					}

				});

	}

	private void alert(String title, String message) {
		final AlertMessageBox d = new AlertMessageBox(title, message);
		d.addHideHandler(new HideHandler() {

			public void onHide(HideEvent event) {

			}
		});
		d.show();

	}

	private void info(String title, String message) {
		final InfoMessageBox d = new InfoMessageBox(title, message);
		d.addHideHandler(new HideHandler() {

			public void onHide(HideEvent event) {

			}
		});
		d.show();

	}

}