/**
 * 
 */
package org.gcube.portlets.user.td.tablewidget.client.progress;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.history.RollBackSessionMonitor;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class RollBackProgressUpdater extends Timer {

	protected ArrayList<RollBackProgressListener> listeners = new ArrayList<RollBackProgressListener>();

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() {
		Log.debug("requesting operation progress");
		TDGWTServiceAsync.INSTANCE
				.getRollBackMonitor(new AsyncCallback<RollBackSessionMonitor>() {

					
					public void onFailure(Throwable caught) {
						cancel();
						Log.error("Error retrieving the operation state",
								caught);
						String message = getStack(caught);
						fireOperationFailed(caught,
								"Failed getting operation updates", message);
					}

					public void onSuccess(RollBackSessionMonitor result) {
						Log.info("retrieved DeleteRowsMonitor: "
								+ result.getStatus());
						switch (result.getStatus()) {
						case INITIALIZING:
							Log.info("Initializing...");
							fireOperationInitializing();
							break;
						case ABORTED:
							cancel();
							Log.info("Delete Rows Operation Aborted");
							break;
						case IN_PROGRESS:
							fireOperationUpdate(result.getProgress());
							break;
						case VALIDATING_RULES:
							fireOperationValidate(result.getProgress());
							break;	
						case GENERATING_VIEW:
							Log.info("Generating View...");
							fireOperationGeneratingView();
							break;				
						case STOPPED:
							cancel();
							stopMessage(result);
							break;		
						case FAILED:
							cancel();
							errorMessage(result);
							break;
						case SUCCEDED:
							cancel();
							Log.info("Fisnish TableId :"
									+ result.getTrId());
							fireOperationComplete(result.getTrId());
							break;
						default:
							Log.info("Unknow State");
							break;
						}

					}

					

				});

	}

	protected void errorMessage(RollBackSessionMonitor result) {
		Log.info("RollBack Failed");
		Throwable th = null;
		String failure = null;
		String details = null;
		if (result.getError() != null) {
			th = result.getError();
			failure = "Failed Client Library rollback";
			details = result.getError().getLocalizedMessage();
		} else {
			th = new Throwable("Failed");
			failure = "Failed Client Library rollback";
			details = "Rollback failed";
		}
		
		fireOperationFailed(th, failure, details);
	}
	
	protected void stopMessage(RollBackSessionMonitor result) {
		Log.info("RollBack Stopped");
		String failure = null;
		String details = null;
		if (result.getError() != null) {	
			failure = "Stopped rollback";
			details = result.getError().getLocalizedMessage();
		} else {
			failure = "Stopped rollback";
			details = "Rollback stopped";
		}
	
		fireOperationStopped(result.getTrId(),failure, details);
	}
	

	protected String getStack(Throwable e) {
		String message = e.getLocalizedMessage() + " -> <br>";
		Throwable c = e.getCause();
		if (c != null)
			message += getStack(c);
		return message;
	}

	protected void fireOperationInitializing() {
		for (RollBackProgressListener listener : listeners)
			listener.operationInitializing();
	}
	
	protected void fireOperationGeneratingView() {
		for (RollBackProgressListener listener : listeners)
			listener.operationGeneratingView();
	}

	protected void fireOperationUpdate(float elaborated) {
		for (RollBackProgressListener listener : listeners)
			listener.operationUpdate(elaborated);
	}
	
	protected void fireOperationValidate(float elaborated) {
		for (RollBackProgressListener listener : listeners)
			listener.operationValidate(elaborated);
	}

	protected void fireOperationComplete(TRId trId) {
		for (RollBackProgressListener listener : listeners)
			listener.operationComplete(trId);
	}

	protected void fireOperationFailed(Throwable caught, String failure,
			String failureDetails) {
		for (RollBackProgressListener listener : listeners)
			listener.operationFailed(caught, failure, failureDetails);
	}

	protected void fireOperationStopped(TRId trId, String reason, String details) {
		for (RollBackProgressListener listener : listeners)
			listener.operationStopped(trId,reason, details);
	}
	
	
	/**
	 * Add a new {@link RollBackProgressListener} to this
	 * {@link RollBackProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to add.
	 */
	public void addListener(RollBackProgressListener listener) {
		listeners.add(listener);
	}

	/**
	 * Removes the specified {@link RollBackProgressListener} from this
	 * {@link RollBackProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to remove.
	 */
	public void removeListener(RollBackProgressListener listener) {
		listeners.remove(listener);
	}
}
