package org.gcube.portlets.user.td.tablewidget.client.rows;

import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsSession;
import org.gcube.portlets.user.td.tablewidget.client.progress.DeleteRowsProgressDialog;
import org.gcube.portlets.user.td.tablewidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.grid.model.RowRaw;

import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * Edit Row
 * 
 * @author "Giancarlo Panichi"
 * 
 */
public class EditRowDialog extends Window {
	protected String WIDTH = "600px";
	protected String HEIGHT = "456px";
	protected TRId trId;
	protected EventBus eventBus;
	protected RowRaw row;
	protected DeleteRowsSession deleteRowsSession;
	protected DeleteRowsProgressDialog deleteRowsProgressDialog;

	private boolean addRow;

	/**
	 * Edit selected row
	 * 
	 * @param trId
	 * @param row
	 * @param eventBus
	 */
	public EditRowDialog(TRId trId, RowRaw row, EventBus eventBus) {
		this.trId = trId;
		this.row = row;
		this.eventBus = eventBus;
		addRow = false;
		if (row == null) {
			UtilsGXT3.alert("Attentions", "No row selected");
		} else {

			initWindow();
			EditRowPanel editRowPanel = new EditRowPanel(this, trId, row,
					eventBus);
			add(editRowPanel);
		}
	}

	/**
	 * Add a new row to the table
	 * 
	 * @param trId
	 * @param eventBus
	 */
	public EditRowDialog(TRId trId, EventBus eventBus) {
		this.trId = trId;
		this.eventBus = eventBus;
		addRow = true;
		initWindow();
		EditRowPanel editRowPanel = new EditRowPanel(this, trId, eventBus);
		add(editRowPanel);

	}

	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		
		setClosable(true);
		setModal(true);
		forceLayoutOnResize = true;
		if (addRow) {
			getHeader().setIcon(ResourceBundle.INSTANCE.rowInsert());
			setHeadingText("Add Row");
		} else {
			getHeader().setIcon(ResourceBundle.INSTANCE.rowEdit());
			setHeadingText("Edit");
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}

	protected void close() {
		hide();

	}

}
