package org.gcube.portlets.user.td.tablewidget.client.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.OperationsId;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.task.InvocationS;
import org.gcube.portlets.user.td.gwtservice.shared.task.ValidationsTasksMetadata;
import org.gcube.portlets.user.td.tablewidget.client.custom.ValidationCell;
import org.gcube.portlets.user.td.tablewidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.tablewidget.client.validation.tree.BaseDto;
import org.gcube.portlets.user.td.tablewidget.client.validation.tree.FolderDto;
import org.gcube.portlets.user.td.tablewidget.client.validation.tree.TreeDataGenerator;
import org.gcube.portlets.user.td.tablewidget.client.validation.tree.ValidationDto;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.WidgetRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.WidgetRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.RequestProperties;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell.Context;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.ToStringValueProvider;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.data.shared.IconProvider;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.TreeStore;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.CollapseItemEvent;
import com.sencha.gxt.widget.core.client.event.CollapseItemEvent.CollapseItemHandler;
import com.sencha.gxt.widget.core.client.event.ExpandItemEvent;
import com.sencha.gxt.widget.core.client.event.ExpandItemEvent.ExpandItemHandler;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import com.sencha.gxt.widget.core.client.treegrid.TreeGrid;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ValidationsTasksPanel extends FramedPanel {
	protected String WIDTH = "298px";
	protected String HEIGHT = "520px";

	protected TRId trId;
	protected VerticalLayoutContainer con;
	protected EventBus eventBus;
	protected ValidationsTasksMetadata validationsTasksMetadata;

	protected TreeDataGenerator gen;
	protected TreeStore<BaseDto> store;
	protected TreeGrid<BaseDto> tree;

	// TODO remove this variable
	@SuppressWarnings("rawtypes")
	protected AbstractCell actionButton = new AbstractCell<Boolean>() {

		@Override
		public void render(Context context, Boolean value, SafeHtmlBuilder sb) {

			if (value == null) {
				sb.appendHtmlConstant("");
			} else {
				Log.debug("Context: pos=" + context.getIndex() + ", key="
						+ context.getKey() + ", column=" + context.getColumn());
				String key = (String) context.getKey();
				BaseDto d = store.findModelWithKey(key);

				/*
				 * List<BaseDto> list = ;
				 * Log.debug("List: ["+list.toString()+"]"); int i = 0; BaseDto
				 * d=null; for (; i < list.size(); i++) { BaseDto dt =
				 * list.get(i); if (dt.getId().compareTo((String)
				 * context.getKey()) == 0) { d=dt;
				 * Log.debug("Retrieved: "+d+" at pos:"+i); break; } }
				 */

				String title = "";
				if (d != null) {
					Log.debug(d.toString());
					if (d instanceof ValidationDto) {
						ValidationDto v = (ValidationDto) d;
						Log.debug("ValidationDto: [" + v.getId() + ", "
								+ v.getDescription() + ", " + v.getValid()
								+ ", " + v.getInvocation() + "]");
						if (v.getInvocation() != null) {
							title = v.getInvocation().toString();
						}
					}
				}

				if (value) {

					sb.appendHtmlConstant("<img src='"
							+ ResourceBundle.INSTANCE.ok().getSafeUri()
									.asString() + "' alt='true' title='"
							+ title + "'>");

				} else {
					sb.appendHtmlConstant("<img src='"
							+ ResourceBundle.INSTANCE.exit().getSafeUri()
									.asString() + "' alt='false' title='"
							+ title + "'>");

				}
			}

		}
	};

	class KeyProvider implements ModelKeyProvider<BaseDto> {
		@Override
		public String getKey(BaseDto item) {
			return (item instanceof FolderDto ? "f-" : "v-") + item.getId();
		}
	}

	public ValidationsTasksPanel(EventBus eventBus) {
		super();
		Log.debug("ValidationsTasksPanel");
		this.eventBus = eventBus;
		forceLayoutOnResize = true;
		retrieveCurrentTR();

	}

	public ValidationsTasksPanel(TRId trId, EventBus eventBus) {
		super();
		Log.debug("ValidationsTasksPanel: " + trId);
		this.trId = trId;
		this.eventBus = eventBus;
		forceLayoutOnResize = true;
		draw();
	}

	protected void draw() {
		if (tree != null) {
			remove(tree);
		}
		init();
		retrieveValidations();
	}

	protected void init() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
	}

	protected void createTreeData() {
		gen = new TreeDataGenerator(validationsTasksMetadata);
		create();
	}

	protected void create() {
		con = new VerticalLayoutContainer();
		con.setScrollMode(ScrollMode.AUTO);
		// con.setAdjustForScroll(true);

		store = new TreeStore<BaseDto>(new KeyProvider());

		FolderDto root = gen.getRoot();
		for (BaseDto base : root.getChildrens()) {
			store.add(base);
			if (base instanceof FolderDto) {
				processFolder(store, (FolderDto) base);
			}
		}

		ColumnConfig<BaseDto, String> cc1 = new ColumnConfig<BaseDto, String>(
				new ToStringValueProvider<BaseDto>("task"), 168, "Task");
		cc1.setHeader("Task");
		cc1.setCell(new AbstractCell<String>() {

			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				sb.appendHtmlConstant("<span title='"
						+ SafeHtmlUtils.htmlEscape(value) + "'>" + value
						+ "</span>");

			}
		});

		/*
		 * ColumnConfig<BaseDto, String> cc2 = new ColumnConfig<BaseDto,
		 * String>( new ValueProvider<BaseDto, String>() {
		 * 
		 * @Override public String getValue(BaseDto object) { return object
		 * instanceof ValidationDto ? ((ValidationDto) object) .getDescription()
		 * : ""; }
		 * 
		 * @Override public void setValue(BaseDto object, String value) { if
		 * (object instanceof ValidationDto) { ((ValidationDto)
		 * object).setDescription(value); } }
		 * 
		 * @Override public String getPath() { return "description"; } });
		 * cc2.setHeader("Description");
		 */

		ColumnConfig<BaseDto, Boolean> cc3 = new ColumnConfig<BaseDto, Boolean>(
				new ValueProvider<BaseDto, Boolean>() {

					@Override
					public Boolean getValue(BaseDto object) {
						return object instanceof ValidationDto ? ((ValidationDto) object).getValid()
								: null;
					}

					@Override
					public void setValue(BaseDto object, Boolean value) {
						if (object instanceof ValidationDto) {
							((ValidationDto) object).setValid(value);
						}
					}

					@Override
					public String getPath() {
						return "valid";
					}
				}, 38, "Valid");
		cc3.setHeader("Valid");

		ValidationCell validationButton = new ValidationCell();
		validationButton.setTrueIcon(ResourceBundle.INSTANCE.ok());
		validationButton.setFalseIcon(ResourceBundle.INSTANCE.error());
		validationButton.setTrueTitle("Valid");
		validationButton.setFalseTitle("Resolve");
		validationButton.addSelectHandler(new SelectHandler() {

			@Override
			public void onSelect(SelectEvent event) {
				Log.debug("Button ValidationCell Pressed");
				Context context = event.getContext();
				requestSolution(context);

			}
		});

		cc3.setCell(validationButton);

		List<ColumnConfig<BaseDto, ?>> l = new ArrayList<ColumnConfig<BaseDto, ?>>();
		l.add(cc1);
		// l.add(cc2);
		l.add(cc3);
		ColumnModel<BaseDto> cm = new ColumnModel<BaseDto>(l);

		tree = new TreeGrid<BaseDto>(store, cm, cc1);
		// tree.getStyle().setLeafIcon(ResourceBundle.INSTANCE.tableValidation());

		// tree.getView().setStripeRows(true);
		// tree.getView().setColumnLines(true);
		tree.getView().setAutoFill(true);
		tree.setBorders(false);
		tree.setLoadMask(true);
		tree.setColumnResize(true);
		tree.getView().setAutoExpandColumn(cc1);

		IconProvider<BaseDto> iconProvider = new IconProvider<BaseDto>() {

			@Override
			public ImageResource getIcon(BaseDto model) {
				ImageResource img = null;
				if (model instanceof FolderDto) {
					String type = ((FolderDto) model).getType();
					if (type.compareTo("job") == 0) {
						img = ResourceBundle.INSTANCE.cog();
					} else {
						if (type.compareTo("task") == 0) {
							img = ResourceBundle.INSTANCE.basket();
						} else {

						}
					}
				} else {
					img = ResourceBundle.INSTANCE.tableValidation();
				}
				return img;
			}
		};
		tree.setIconProvider(iconProvider);

		tree.addExpandHandler(new ExpandItemHandler<BaseDto>() {

			@Override
			public void onExpand(ExpandItemEvent<BaseDto> event) {
				forceLayout();

			}
		});

		tree.addCollapseHandler(new CollapseItemHandler<BaseDto>() {

			@Override
			public void onCollapse(CollapseItemEvent<BaseDto> event) {
				forceLayout();

			}
		});

		ToolBar toolBar = new ToolBar();

		TextButton btnExpandAll = new TextButton();
		// btnReload.setText("Expand All");
		btnExpandAll.setIcon(ResourceBundle.INSTANCE.collapseAll12());
		btnExpandAll.setToolTip("Expand All");
		btnExpandAll.addSelectHandler(new SelectHandler() {

			@Override
			public void onSelect(SelectEvent event) {
				tree.expandAll();
				forceLayout();
			}
		});
		toolBar.add(btnExpandAll);

		TextButton btnCollapseAll = new TextButton();
		// btnReload.setText("Expand All");
		btnCollapseAll.setIcon(ResourceBundle.INSTANCE.expandAll12());
		btnCollapseAll.setToolTip("Collapse All");
		btnCollapseAll.addSelectHandler(new SelectHandler() {

			@Override
			public void onSelect(SelectEvent event) {
				tree.collapseAll();
				forceLayout();
			}
		});
		toolBar.add(btnCollapseAll);

		con.add(toolBar, new VerticalLayoutData(1, -1));
		con.add(tree, new VerticalLayoutData(1, -1));

		add(con, new MarginData(0));

	}

	// TODO
	protected void requestSolution(Context context) {
		String key = (String) context.getKey();
		BaseDto d = store.findModelWithKey(key);

		String title = "";
		if (d != null) {
			Log.debug(d.toString());
			if (d instanceof ValidationDto) {
				ValidationDto v = (ValidationDto) d;
				Log.debug("ValidationDto: [" + v.getId() + ", "
						+ v.getDescription() + ", " + v.getValid() + ", "
						+ v.getInvocation() + "]");
				if (v.getValid()) {
					
				} else {
					if (v.getInvocation() != null) {
						InvocationS invocationS = v.getInvocation();
						title = invocationS.toString();
						Long op = invocationS.getOperationId();
						if (op.compareTo(OperationsId.ChangeToDimensionColumn
								.toLong()) == 0) {
							WidgetRequestEvent widgetRequestEvent = new WidgetRequestEvent(
									WidgetRequestType.CURATIONBYREPLACEBATCHDIALOG);
							widgetRequestEvent.setTrId(trId);
							HashMap<String, Object> map = new HashMap<String, Object>();
							map.put(Constants.REQUEST_PROPERTIES_REFCOLUMN,
									invocationS.getRefColumn());
							map.put(Constants.REQUEST_PROPERTIES_COLUMNID,
									invocationS.getColumnId());
							map.put(Constants.REQUEST_PROPERTIES_TASKID, invocationS.getTaskId());
							RequestProperties props = new RequestProperties(map);
							widgetRequestEvent.setRequestProperties(props);
							eventBus.fireEvent(widgetRequestEvent);
						} else {
							UtilsGXT3.info("Invocation Info", title);
						}
					}
				}

			}
		}

	}

	protected void retrieveValidations() {

		TDGWTServiceAsync.INSTANCE.getValidationsTasksMetadata(trId,
				new AsyncCallback<ValidationsTasksMetadata>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("Load validations metadata failure: "
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert(
									"Error retrieving validations metadata",
									"Error retrieving validations metadata");
						}
					}

					public void onSuccess(ValidationsTasksMetadata result) {
						Log.debug("Loaded " + result.getId());
						validationsTasksMetadata = result;
						createTreeData();

					}

				});

	}

	public void update() {
		retrieveCurrentTR();
	}

	public void update(TRId trId) {
		this.trId = trId;
		draw();
	}

	protected void retrieveCurrentTR() {
		TDGWTServiceAsync.INSTANCE.getCurrentTRId(new AsyncCallback<TRId>() {

			public void onFailure(Throwable caught) {
				if (caught instanceof TDGWTSessionExpiredException) {
					eventBus.fireEvent(new SessionExpiredEvent(
							SessionExpiredType.EXPIREDONSERVER));
				} else {
					Log.error("Error retrieving current TRId: "
							+ caught.getLocalizedMessage());
					UtilsGXT3.alert("Error",
							"Error retrieving current tabular resource id");
				}
			}

			public void onSuccess(TRId result) {
				Log.debug("retrieved " + result);
				trId = result;
				draw();

			}

		});
	}

	private void processFolder(TreeStore<BaseDto> store, FolderDto folder) {
		for (BaseDto child : folder.getChildrens()) {
			store.add(folder, child);
			if (child instanceof FolderDto) {
				processFolder(store, (FolderDto) child);
			}
		}
	}

}
