package org.gcube.portlets.user.td.tablewidget.client.rows;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

import org.gcube.portlets.user.td.columnwidget.client.dimension.DimensionRowSelectionDialog;
import org.gcube.portlets.user.td.columnwidget.client.dimension.DimensionRowSelectionListener;
import org.gcube.portlets.user.td.columnwidget.client.dimension.DimensionRowsProperties;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.DimensionRow;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.EditRowSession;
import org.gcube.portlets.user.td.tablewidget.client.progress.EditRowProgressDialog;
import org.gcube.portlets.user.td.tablewidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.CellData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.grid.model.RowRaw;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.core.client.util.ToggleGroup;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer.HBoxLayoutAlign;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.event.TriggerClickEvent;
import com.sencha.gxt.widget.core.client.event.TriggerClickEvent.TriggerClickHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.DateField;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.Radio;
import com.sencha.gxt.widget.core.client.form.TextField;

/**
 * 
 * @author "Giancarlo Panichi"
 * 
 */
public class EditRowPanel extends FramedPanel {
	protected String WIDTH = "510px";
	protected String HEIGHT = "370px";
	protected String FIELDSHEIGHT = "370px";
	protected int LABELSIZE = 140;

	protected EditRowDialog parent;
	protected TRId trId;
	protected EventBus eventBus;
	protected ArrayList<ColumnData> columns;
	protected RowRaw rowRaw;
	protected boolean editRow;

	protected EditRowProgressDialog editRowProgressDialog;

	protected VerticalLayoutContainer v;
	private TextButton btnSave;
	private TextButton btnClose;

	private DateTimeFormat sdf = DateTimeFormat.getFormat("yyyy-MM-dd");

	/**
	 * Edit Row
	 * 
	 * @param parent
	 * @param trId
	 * @param rowRaw
	 * @param eventBus
	 */
	public EditRowPanel(EditRowDialog parent, TRId trId, RowRaw rowRaw,
			EventBus eventBus) {
		super();
		this.parent = parent;
		this.trId = trId;
		this.rowRaw = rowRaw;
		this.eventBus = eventBus;
		this.editRow = true;
		Log.debug("Create EditRowPanel(): [" + trId.toString() + " , RowRaw:"
				+ rowRaw + "]");
		if (rowRaw == null) {
			UtilsGXT3.alert("Attentions", "No row selected");
		} else {
			init();
			retrieveColumn();
		}
	}

	/**
	 * Add a new rowe
	 * 
	 * @param parent
	 * @param trId
	 * @param eventBus
	 */
	public EditRowPanel(EditRowDialog parent, TRId trId, EventBus eventBus) {
		super();
		this.parent = parent;
		this.trId = trId;
		this.eventBus = eventBus;
		this.editRow = false;
		Log.debug("Create For Add Row EditRowPanel(): [" + trId.toString()
				+ "]");
		init();
		retrieveColumn();

	}

	protected void init() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
	}

	protected void create() {
		SimpleContainer container = new SimpleContainer();
		container.setHeight(FIELDSHEIGHT);

		v = new VerticalLayoutContainer();
		v.setScrollMode(ScrollMode.AUTO);
		container.add(v);

		btnSave = new TextButton("Save");
		btnSave.setIcon(ResourceBundle.INSTANCE.save());
		btnSave.setIconAlign(IconAlign.RIGHT);
		btnSave.setTitle("Save");
		btnSave.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Save");
				btnSave.disable();
				save();

			}
		});

		btnClose = new TextButton("Close");
		btnClose.setIcon(ResourceBundle.INSTANCE.close());
		btnClose.setIconAlign(IconAlign.RIGHT);
		btnClose.setTitle("Close");
		btnClose.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Close");
				close();
			}
		});

		HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
		flowButton.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		flowButton.setPack(BoxLayoutPack.CENTER);

		flowButton.add(btnSave, new BoxLayoutData(new Margins(2, 4, 2, 4)));
		flowButton.add(btnClose, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		ArrayList<FieldLabel> fields = generateFields();
		for (FieldLabel fl : fields) {
			v.add(fl, new VerticalLayoutData(1, -1, new Margins(1)));

		}

		container.forceLayout();

		VerticalLayoutContainer vPanel = new VerticalLayoutContainer();
		vPanel.add(container, new VerticalLayoutData(1, -1));
		vPanel.add(flowButton, new VerticalLayoutData(1, -1, new Margins(1)));
		add(vPanel);

	}

	protected void retrieveColumn() {
		TDGWTServiceAsync.INSTANCE.getColumns(trId,
				new AsyncCallback<ArrayList<ColumnData>>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("load columns failure:"
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving columns",
									"Error retrieving columns");
						}
					}

					public void onSuccess(ArrayList<ColumnData> result) {
						Log.trace("loaded " + result.size() + " ColumnData");
						columns = result;
						create();
					}
				});

	}

	protected ArrayList<FieldLabel> generateFields() {
		ArrayList<FieldLabel> fields = new ArrayList<FieldLabel>();

		for (ColumnData col : columns) {
			String label = new String();
			if (col != null && col.getLabel() != null) {
				label = SafeHtmlUtils.htmlEscape(col.getLabel());
				if (label.length() > LABELSIZE - 1) {
					label = label.substring(0, LABELSIZE - 3);
					label += "..";
				}
			}
			if (!col.isViewColumn()) {
				if (col.getTypeCode().compareTo(
						ColumnTypeCode.DIMENSION.toString()) == 0
						|| col.getTypeCode().compareTo(
								ColumnTypeCode.TIMEDIMENSION.toString()) == 0) {

					FieldLabel dimensionLabel = retrieveDimensionLabel(col,
							label);
					dimensionLabel.setLabelWidth(LABELSIZE);
					fields.add(dimensionLabel);
				} else {
					if (col.getDataTypeName().compareTo(
							ColumnDataType.Boolean.toString()) == 0) {
						Radio radioTrue = new Radio();
						radioTrue.setBoxLabel("true");
						Radio radioFalse = new Radio();
						radioFalse.setBoxLabel("false");

						String value = "true";
						if (editRow) {
							value = rowRaw.getMap().get(col.getColumnId());
						}

						if (new Boolean(value)) {
							radioTrue.setValue(true);
						} else {
							radioFalse.setValue(true);
						}
						ToggleGroup toggleGroup = new ToggleGroup();
						toggleGroup.add(radioTrue);
						toggleGroup.add(radioFalse);

						HorizontalPanel hp = new HorizontalPanel();
						hp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
						hp.add(radioTrue);
						hp.add(radioFalse);
						FieldLabel booleanLabel = new FieldLabel(hp, label);
						booleanLabel.setLabelWidth(LABELSIZE);
						booleanLabel.setId(col.getColumnId());
						fields.add(booleanLabel);
					} else {
						if (col.getDataTypeName().compareTo(
								ColumnDataType.Date.toString()) == 0) {
							DateField date = new DateField();
							Date d = null;
							if (editRow) {
								String value = rowRaw.getMap().get(
										col.getColumnId());

								try {
									d = sdf.parse(value);
								} catch (Throwable e) {
									Log.error("Error parsing date string: "
											+ e.getLocalizedMessage());
								}
							}
							if (d != null) {
								date.setValue(d);
							}
							FieldLabel dateLabel = new FieldLabel(date, label);
							dateLabel.setLabelWidth(LABELSIZE);
							dateLabel.setId(col.getColumnId());
							fields.add(dateLabel);
						} else {
							if (col.getDataTypeName().compareTo(
									ColumnDataType.Text.toString()) == 0) {
								TextField text = new TextField();
								String value = "";
								if (editRow) {
									value = rowRaw.getMap().get(
											col.getColumnId());
								}
								text.setValue(value);
								text.addValueChangeHandler(new ValueChangeHandler<String>() {
									@Override
									public void onValueChange(
											ValueChangeEvent<String> event) {

									}
								});

								FieldLabel textLabel = new FieldLabel(text,
										label);
								textLabel.setLabelWidth(LABELSIZE);
								textLabel.setId(col.getColumnId());
								fields.add(textLabel);
							} else {
								if (col.getDataTypeName().compareTo(
										ColumnDataType.Geometry.toString()) == 0) {
									TextField geometry = new TextField();
									String value = "";
									if (editRow) {
										value = rowRaw.getMap().get(
												col.getColumnId());
									}
									geometry.setValue(value);
									geometry.addValueChangeHandler(new ValueChangeHandler<String>() {
										@Override
										public void onValueChange(
												ValueChangeEvent<String> event) {

										}
									});

									FieldLabel geometryLabel = new FieldLabel(
											geometry, label);
									geometryLabel.setLabelWidth(LABELSIZE);
									geometryLabel.setId(col.getColumnId());
									fields.add(geometryLabel);
								} else {
									if (col.getDataTypeName().compareTo(
											ColumnDataType.Integer.toString()) == 0) {
										TextField integ = new TextField();
										String value = "";
										if (editRow) {
											value = rowRaw.getMap().get(
													col.getColumnId());
										}
										integ.setValue(value);
										integ.addValueChangeHandler(new ValueChangeHandler<String>() {
											@Override
											public void onValueChange(
													ValueChangeEvent<String> event) {

											}
										});

										FieldLabel integLabel = new FieldLabel(
												integ, label);
										integLabel.setLabelWidth(LABELSIZE);
										integLabel.setId(col.getColumnId());
										fields.add(integLabel);
									} else {
										if (col.getDataTypeName().compareTo(
												ColumnDataType.Numeric
														.toString()) == 0) {
											TextField numeric = new TextField();
											String value = "";
											if (editRow) {
												value = rowRaw.getMap().get(
														col.getColumnId());
											}
											numeric.setValue(value);
											numeric.setId(col.getColumnId());
											numeric.addValueChangeHandler(new ValueChangeHandler<String>() {
												@Override
												public void onValueChange(
														ValueChangeEvent<String> event) {

												}
											});
											FieldLabel numericLabel = new FieldLabel(
													numeric, label);
											numericLabel
													.setLabelWidth(LABELSIZE);
											numericLabel.setId(col
													.getColumnId());
											fields.add(numericLabel);
										} else {

										}
									}
								}
							}
						}
					}
				}
			}
		}
		return fields;

	}

	protected FieldLabel retrieveDimensionLabel(final ColumnData col,
			String label) {
		// comboDimension
		DimensionRowsProperties propsDimension = GWT
				.create(DimensionRowsProperties.class);
		ListStore<DimensionRow> storeComboDimensionType = new ListStore<DimensionRow>(
				propsDimension.rowId());

		final ComboBox<DimensionRow> comboDimension = new ComboBox<DimensionRow>(
				storeComboDimensionType, propsDimension.value());

		Log.debug("ComboDimensionType created");

		final DimensionRowSelectionListener listener = new DimensionRowSelectionListener() {

			@Override
			public void selectedDimensionRow(DimensionRow dimensionRow) {
				comboDimension.setValue(dimensionRow);

			}

			@Override
			public void failedDimensionRowSelection(String reason, String detail) {
				Log.error("Change Value Failed:" + reason + " " + detail);

			}

			@Override
			public void abortedDimensionRowSelection() {
				Log.debug("Change Value Aborted");

			}
		};

		String viewColumn = col.getRelationship().getTargetColumnId();

		String valueOnViewColumn = null;
		String rowId = null;
		if (editRow) {
			valueOnViewColumn = rowRaw.getMap().get(viewColumn);
			rowId = rowRaw.getRowId();
			DimensionRow dimR = new DimensionRow(rowId, valueOnViewColumn);
			comboDimension.setValue(dimR);
		}

		final CellData cellData = new CellData(valueOnViewColumn, "",
				viewColumn, "", rowId, 0, 0);

		comboDimension.addTriggerClickHandler(new TriggerClickHandler() {

			@Override
			public void onTriggerClick(TriggerClickEvent event) {
				Log.debug("ComboDimensionRows TriggerClickEvent");
				comboDimension.collapse();

				DimensionRowSelectionDialog dialogDimensionRowSelection = new DimensionRowSelectionDialog(
						col, cellData, eventBus);
				dialogDimensionRowSelection.addListener(listener);
				dialogDimensionRowSelection.show();

			}

		});

		comboDimension.setEmptyText("Select a Value...");
		comboDimension.setWidth(300);
		comboDimension.setEditable(false);
		comboDimension.setTriggerAction(TriggerAction.ALL);

		FieldLabel dimensionLabel = new FieldLabel(comboDimension, label);
		dimensionLabel.setId(col.getColumnId());
		return dimensionLabel;
	}

	protected void save() {
		int i = 0;
		int lenght = v.getWidgetCount();
		HashMap<String, String> maps = new HashMap<String, String>();

		for (; i < lenght; i++) {
			FieldLabel fieldLabel = (FieldLabel) v.getWidget(i);
			String columnId = fieldLabel.getId();
			ColumnData colCurrent = null;
			for (ColumnData col : columns) {
				if (col.getColumnId().compareTo(columnId) == 0) {
					colCurrent = col;
					break;
				}
			}
			if (colCurrent == null) {
				return;
			}
			if (colCurrent.getTypeCode().compareTo(
					ColumnTypeCode.DIMENSION.toString()) == 0
					|| colCurrent.getTypeCode().compareTo(
							ColumnTypeCode.TIMEDIMENSION.toString()) == 0) {
				@SuppressWarnings("unchecked")
				ComboBox<DimensionRow> comboDimension=(ComboBox<DimensionRow>)fieldLabel.getWidget();
				DimensionRow dimRow=comboDimension.getValue();
				maps.put(columnId, dimRow.getRowId());
			} else {
				if (colCurrent.getDataTypeName().compareTo(
						ColumnDataType.Boolean.toString()) == 0) {
					HorizontalPanel hpanel=(HorizontalPanel)fieldLabel.getWidget();
					Radio radioTrue = (Radio)hpanel.getWidget(0) ;
					maps.put(columnId, radioTrue.getValue().toString());
				} else {
					if (colCurrent.getDataTypeName().compareTo(
							ColumnDataType.Date.toString()) == 0) {
						DateField date = (DateField) fieldLabel.getWidget();
						if (date == null || date.getCurrentValue() == null) {
							maps.put(columnId, null);
						} else {
							Date d = date.getCurrentValue();
							String dateS = sdf.format(d);
							maps.put(columnId, dateS);
						}
					} else {
						if (colCurrent.getDataTypeName().compareTo(
								ColumnDataType.Text.toString()) == 0) {
							TextField text = (TextField) fieldLabel.getWidget();
							maps.put(columnId, text.getCurrentValue());
						} else {
							if (colCurrent.getDataTypeName().compareTo(
									ColumnDataType.Geometry.toString()) == 0) {
								TextField geometry = (TextField) fieldLabel
										.getWidget();
								maps.put(columnId, geometry.getCurrentValue());
							} else {
								if (colCurrent.getDataTypeName().compareTo(
										ColumnDataType.Integer.toString()) == 0) {
									TextField integ = (TextField) fieldLabel
											.getWidget();
									@SuppressWarnings("unused")
									Integer intege;
									try {
										intege = new Integer(
												integ.getCurrentValue());
									} catch (NumberFormatException e) {
										UtilsGXT3
												.alert("Attentions",
														colCurrent.getLabel()
																+ " is no a valid Integer type");
										return;
									}

									maps.put(columnId, integ.getCurrentValue());
								} else {
									if (colCurrent.getDataTypeName().compareTo(
											ColumnDataType.Numeric.toString()) == 0) {
										TextField numeric = (TextField) fieldLabel
												.getWidget();
										@SuppressWarnings("unused")
										Double d;
										try {
											d = new Double(
													numeric.getCurrentValue());
										} catch (NumberFormatException e) {
											UtilsGXT3
													.alert("Attentions",
															colCurrent
																	.getLabel()
																	+ " is no a valid Numeric type");
											return;
										}
										maps.put(columnId,
												numeric.getCurrentValue());
									} else {

									}
								}
							}
						}
					}
				}
			}
		}

		EditRowSession editRowSession;
		if (editRow) {
			editRowSession = new EditRowSession(trId, columns, maps,
					rowRaw.getRowId());
		} else {
			editRowSession = new EditRowSession(trId, columns, maps);
		}

		callEditRow(editRowSession);

	}

	public void close() {
		if (parent != null) {
			parent.close();
		}
	}

	protected void callEditRow(EditRowSession editRowSession) {
		final EditRowPanel panel = this;

		TDGWTServiceAsync.INSTANCE.startEditRow(editRowSession,
				new AsyncCallback<Void>() {

					public void onFailure(Throwable caught) {
						Log.debug("EditRow: " + caught.getLocalizedMessage());
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							UtilsGXT3.alert("Error",
									"Error in operation invocation!");
						}
					}

					public void onSuccess(Void result) {
						editRowProgressDialog = new EditRowProgressDialog(
								panel, eventBus);
					}

				});

	}

}
