/**
 * 
 */
package org.gcube.portlets.user.td.taskswidget.shared.job;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public enum TdJobClassifierType {

		CLASSIFIER_UNKNOWN("Classifier_Unknown"), 
		PROCESSING("Processing"),
		VALIDATION("Validation"), 
		PREPROCESSING("Pre-Processing"), 
		POSTPROCESSING("Post-Processing"), 
		FALLBACK("Fallback");
		
		protected String label;
		
		TdJobClassifierType(String label)
		{
			this.label = label;
		}

		/**
		 * @return the label
		 */
		public String getLabel() {
			return label;
		}

		public static List<String> getListLabels(){
			
			List<String> listLabels = new ArrayList<String>();
			
			for (TdJobClassifierType item : TdJobClassifierType.values()) 
				listLabels.add(item.getLabel());
			
			return listLabels;
		}
		
		/* (non-Javadoc)
		 * @see java.lang.Enum#toString()
		 */
		@Override
		public String toString() {
			return this.getLabel();
		}
}
