/**
 * 
 */
package org.gcube.portlets.user.tdtemplateoperation.shared.action;

import java.io.Serializable;

import org.gcube.portlets.user.tdtemplateoperation.shared.ServerObjectId;
import org.gcube.portlets.user.tdtemplateoperation.shared.TdColumnData;
import org.gcube.portlets.user.tdtemplateoperation.shared.TdPeriodType;

/**
 * The Class AggregationColumnSession.
 *
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jun 9, 2014
 */
public class CreateTimeDimensionColumnAction implements TabularDataAction, Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 4553301976630440150L;

	/**
	 * 
	 */
	public static final String CREATE_TIME_DIMENSION = "Create Time Column";
	
	private TdColumnData yearColumn;
	private TdPeriodType periodTypeYear;
//	private TdPeriodType periodTypeYear = null;
	private TdColumnData otherColumn;
	private TdPeriodType otherPeriodTypeColumn;
	
	private ServerObjectId serverObjectId;
	
	/**
	 * 
	 */
	public CreateTimeDimensionColumnAction() {
	}
	
	/**
	 * Instantiates a new group time column action.
	 *
	 * @param yearColumn the year column
	 * @param year the year
	 */
	public CreateTimeDimensionColumnAction(TdColumnData yearColumn, TdPeriodType year){
		this.yearColumn = yearColumn;
		this.periodTypeYear = year;
	}
	
	/**
	 * Instantiates a new group time column action.
	 *
	 * @param yearColumn the year column
	 * @param year the year
	 * @param otherColumn the other column
	 * @param otherPeriodTypeColumn the other period type column
	 */
	public CreateTimeDimensionColumnAction(TdColumnData yearColumn,  TdPeriodType year, TdColumnData otherColumn, TdPeriodType otherPeriodTypeColumn) {
		this(yearColumn, year);
		this.otherColumn = otherColumn;
		this.otherPeriodTypeColumn = otherPeriodTypeColumn;
	}
	
	/**
	 * @return the yearColumn
	 */
	public TdColumnData getYearColumn() {
		return yearColumn;
	}

	/**
	 * @param yearColumn the yearColumn to set
	 */
	public void setYearColumn(TdColumnData yearColumn) {
		this.yearColumn = yearColumn;
	}

	/**
	 * @return the otherColumn
	 */
	public TdColumnData getOtherColumn() {
		return otherColumn;
	}

	/**
	 * @param otherColumn the otherColumn to set
	 */
	public void setOtherColumn(TdColumnData otherColumn) {
		this.otherColumn = otherColumn;
	}

	/**
	 * @return the otherPeriodTypeColumn
	 */
	public TdPeriodType getOtherPeriodTypeColumn() {
		return otherPeriodTypeColumn;
	}

	/**
	 * @param otherPeriodTypeColumn the otherPeriodTypeColumn to set
	 */
	public void setOtherPeriodTypeColumn(TdPeriodType otherPeriodTypeColumn) {
		this.otherPeriodTypeColumn = otherPeriodTypeColumn;
	}

	/**
	 * @return the serverObjectId
	 */
	public ServerObjectId getServerObjectId() {
		return serverObjectId;
	}

	/**
	 * @param serverObjectId the serverObjectId to set
	 */
	public void setServerObjectId(ServerObjectId serverObjectId) {
		this.serverObjectId = serverObjectId;
	}

	/**
	 * @return the periodTypeYear
	 */
	public TdPeriodType getPeriodTypeYear() {
		return periodTypeYear;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.tdtemplateoperation.shared.action.TabularDataAction#getDescription()
	 */
	@Override
	public String getDescription() {
		return CREATE_TIME_DIMENSION;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.tdtemplateoperation.shared.action.TabularDataAction#getId()
	 */
	@Override
	public String getId() {
		return CreateTimeDimensionColumnAction.class.getSimpleName();
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("CreateTimeDimensionColumnAction [yearColumn=");
		builder.append(yearColumn);
		builder.append(", periodTypeYear=");
		builder.append(periodTypeYear);
		builder.append(", otherColumn=");
		builder.append(otherColumn);
		builder.append(", otherPeriodTypeColumn=");
		builder.append(otherPeriodTypeColumn);
		builder.append(", serverObjectId=");
		builder.append(serverObjectId);
		builder.append("]");
		return builder.toString();
	}
}
