package org.gcube.portlets.user.td.widgetcommonevent.client.event;

import org.gcube.portlets.user.td.widgetcommonevent.client.type.UIStateType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class UIStateEvent extends GwtEvent<UIStateEvent.UIStateHandler> {

	public static Type<UIStateHandler> TYPE = new Type<UIStateHandler>();
	private UIStateType uiStateType;
	private TRId trId;
	
	public interface UIStateHandler extends EventHandler {
		void onUIState(UIStateEvent event);
	}
	
	public interface HasUIStateHandler extends HasHandlers{
		public HandlerRegistration addUIStateHandler(UIStateHandler handler);
	}

	public UIStateEvent(UIStateType uiStateType) {
		this.uiStateType = uiStateType;
	}

	public UIStateType getUIStateType() {
		return uiStateType;
	}
		
	@Override
	protected void dispatch(UIStateHandler handler) {
		handler.onUIState(this);
	}

	@Override
	public Type<UIStateHandler> getAssociatedType() {
		return TYPE;
	}

	public static Type<UIStateHandler> getType() {
		return TYPE;
	}

	public static void fire(HasHandlers source, UIStateType uiStateType) {
		source.fireEvent(new UIStateEvent(uiStateType));
	}
	

	
	public TRId getTrId() {
		return trId;
	}

	public void setTrId(TRId trId) {
		this.trId = trId;
	}

	@Override
	public String toString() {
		return "UIStateEvent [uiStateType=" + uiStateType + ", trId=" + trId
				+ "]";
	}
	
	
	

}
