package org.gcube.portlets.user.td.widgetcommonevent.client.event;

import org.gcube.portlets.user.td.widgetcommonevent.client.type.ExpressionType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_ExpressionContainer;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ExpressionEvent extends GwtEvent<ExpressionEvent.ExpressionEventHandler> {

	public static Type<ExpressionEventHandler> TYPE = new Type<ExpressionEventHandler>();
	private ExpressionType expressionType;
	private TRId trId;
	private String columnId;
	private String columnName;
	private C_ExpressionContainer c_ExpressionContainer;
	
	public interface ExpressionEventHandler extends EventHandler {
		void onExpression(ExpressionEvent event);
	}

	public interface HasExpressionEventHandler extends HasHandlers{
		public HandlerRegistration addExpressionEventHandler(ExpressionEventHandler handler);
	}
	
	public ExpressionEvent(ExpressionType expressionType) {
		this.expressionType = expressionType;
	}

	public ExpressionType getExpressionType() {
		return expressionType;
	}

	@Override
	protected void dispatch(ExpressionEventHandler handler) {
		handler.onExpression(this);
	}

	@Override
	public Type<ExpressionEventHandler> getAssociatedType() {
		return TYPE;
	}

	public static Type<ExpressionEventHandler> getType() {
		return TYPE;
	}

	public static void fire(HasHandlers source, ExpressionType expressionType) {
		source.fireEvent(new ExpressionEvent(expressionType));
	}
	
	public TRId getTrId() {
		return trId;
	}

	public void setTrId(TRId trId) {
		this.trId = trId;
	}
	
	public String getColumnName() {
		return columnName;
	}

	public void setColumnName(String columnName) {
		this.columnName = columnName;
	}

	public C_ExpressionContainer getC_ExpressionContainer() {
		return c_ExpressionContainer;
	}

	public void setC_ExpressionContainer(C_ExpressionContainer c_ExpressionContainer) {
		this.c_ExpressionContainer = c_ExpressionContainer;
	}

	public String getColumnId() {
		return columnId;
	}

	public void setColumnId(String columnId) {
		this.columnId = columnId;
	}

	@Override
	public String toString() {
		return "ExpressionEvent [expressionType=" + expressionType + ", trId="
				+ trId + ", columnId=" + columnId + ", columnName="
				+ columnName + ", c_ExpressionContainer="
				+ c_ExpressionContainer + "]";
	}
	
	
	
	

}
