package org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public enum PeriodDataType {
	DAY("Day"), 
	MONTH("Month"),  
	QUARTER("Quarter_of_year"),  
	YEAR("Year");
	
	
	private static Map<PeriodDataType, List<PeriodDataType>> hierarchicalRelation = new HashMap<PeriodDataType, List<PeriodDataType>>();
	
	static {
		hierarchicalRelation.put(DAY, Arrays.asList(MONTH, QUARTER, YEAR));
		hierarchicalRelation.put(MONTH, Arrays.asList(QUARTER, YEAR));
		hierarchicalRelation.put(QUARTER, Arrays.asList(YEAR));
	}
	
	
	/**
	 * @param text
	 */
	private PeriodDataType(final String id) {
		this.id = id;
	}

	private final String id;

	@Override
	public String toString() {
		return id;
	}

	public List<PeriodDataType> getHierarchicalRelationOfPeriodDataType(PeriodDataType periodDataType){
		return hierarchicalRelation.get(periodDataType);
	}
	
	public Map<PeriodDataType, List<PeriodDataType>> getHierarchicalRelation(){
		return hierarchicalRelation;
	}

	public String getPeriodDataTypeLabel() {
		switch (this) {
		case DAY:
			return "Day";
		case MONTH:
			return "Month";
		case QUARTER:
			return "Quarter of year";
		case YEAR:
			return "Year";
		default:
			return null;
		}
		
	}

}
