/**
 * 
 */
package org.gcube.portlets.user.tdw.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.gcube.portlets.user.tdw.client.event.CloseTableEvent;
import org.gcube.portlets.user.tdw.client.event.CloseTableEventHandler;
import org.gcube.portlets.user.tdw.client.event.OpenTableEvent;
import org.gcube.portlets.user.tdw.client.event.OpenTableEventHandler;
import org.gcube.portlets.user.tdw.client.event.TableReadyEvent;
import org.gcube.portlets.user.tdw.client.event.TableReadyEventHandler;
import org.gcube.portlets.user.tdw.client.model.grid.DataRowModelKeyProvider;
import org.gcube.portlets.user.tdw.client.model.grid.DataRowPagingReader;
import org.gcube.portlets.user.tdw.client.model.util.ColumnConfigGenerator;
import org.gcube.portlets.user.tdw.client.util.ColumnPositionComparator;
import org.gcube.portlets.user.tdw.client.util.PagingLoadUrlEncoder;
import org.gcube.portlets.user.tdw.shared.ServletParameters;
import org.gcube.portlets.user.tdw.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdw.shared.model.ColumnType;
import org.gcube.portlets.user.tdw.shared.model.DataRow;
import org.gcube.portlets.user.tdw.shared.model.TableDefinition;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.http.client.RequestBuilder;
import com.sencha.gxt.data.client.loader.HttpProxy;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.loader.PagingLoadConfig;
import com.sencha.gxt.data.shared.loader.PagingLoadConfigBean;
import com.sencha.gxt.data.shared.loader.PagingLoadResult;
import com.sencha.gxt.data.shared.loader.PagingLoader;
import com.sencha.gxt.widget.core.client.ContentPanel;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.LiveGridView;
import com.sencha.gxt.widget.core.client.grid.LiveToolItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class TabularDataGridPanel extends ContentPanel {

	protected int tdSessionId;
	
	protected EventBus eventBus;

	protected Grid<DataRow> grid;	
	protected VerticalLayoutContainer container;

	protected LiveGridView<DataRow> liveGridView;

	protected DataRowPagingReader reader;

	protected PagingLoader<PagingLoadConfig, PagingLoadResult<DataRow>> loader;

	/**
	 * @param eventBus
	 */
	protected TabularDataGridPanel(int tdSessionId, EventBus eventBus) {
		super();
		this.tdSessionId = tdSessionId;
		this.eventBus = eventBus;
		bindEventBus();
		container = new VerticalLayoutContainer();
		setWidget(container);
	}

	/**
	 * @return the grid
	 */
	public Grid<DataRow> getGrid() {
		return grid;
	}

	protected void bindEventBus()
	{
		eventBus.addHandler(OpenTableEvent.TYPE, new OpenTableEventHandler() {

			@Override
			public void onOpenTable(OpenTableEvent event) {
				doOpenTable();
			}
		});

		eventBus.addHandler(TableReadyEvent.TYPE, new TableReadyEventHandler() {

			@Override
			public void onTableReady(TableReadyEvent event) {
				doTableReady(event.getTableDefinition());
			}
		});
		
		eventBus.addHandler(CloseTableEvent.TYPE, new CloseTableEventHandler() {

			@Override
			public void onCloseTable(CloseTableEvent event) {
				doCloseTable();
			}
		});
	}

	protected void doOpenTable()
	{
		mask();
	}

	protected void doTableReady(TableDefinition definition)
	{
		Log.trace("table ready, setting grid up");
		mask("Loading table "+definition.getName()+"... ");
		setupGrid(definition);
		unmask();
	}
	
	protected void doCloseTable()
	{
		mask();
		grid = null;
		container.clear();
		unmask();
	}

	protected void setupGrid(TableDefinition tableDefinition)
	{
	
		ColumnDefinition modelKeyColumn = tableDefinition.getModelKeyColumn();
		ListStore<DataRow> store = new ListStore<DataRow>(new DataRowModelKeyProvider(modelKeyColumn.getKey()));

		List<ColumnConfig<DataRow, ?>> columnsConfig = new ArrayList<ColumnConfig<DataRow, ?>>();
		
		List<ColumnDefinition> columns = tableDefinition.getColumnsAsList();
		Collections.sort(columns, new ColumnPositionComparator(false));
		
		for (ColumnDefinition columnDefinition:columns) {
			if (columnDefinition.getType()==ColumnType.USER) columnsConfig.add(ColumnConfigGenerator.generateConfiguration(columnDefinition));
		}
		
	    //IdentityValueProvider<DataRow> identity = new IdentityValueProvider<DataRow>();
	    
	    //LiveRowNumberer<DataRow> numberer = new LiveRowNumberer<DataRow>(identity);
	    
	    //columnsConfig.add(numberer);

		ColumnModel<DataRow> columnModel = new ColumnModel<DataRow>(columnsConfig);

		if (grid == null) {
			reader = new DataRowPagingReader(tableDefinition);

			String path = GWT.getModuleBaseURL()+"tdwdata";
			RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, path);
			builder.setHeader(ServletParameters.TD_SESSION_ID, String.valueOf(tdSessionId));
			HttpProxy<PagingLoadConfig> proxy = new HttpProxy<PagingLoadConfig>(builder);
			proxy.setWriter(new PagingLoadUrlEncoder());

			loader = new PagingLoader<PagingLoadConfig, PagingLoadResult<DataRow>>(proxy, reader);
			loader.setRemoteSort(true);
			
			liveGridView = new LiveGridView<DataRow>();
			grid = new Grid<DataRow>(store, columnModel);
			grid.setLoadMask(true);
			grid.setLoader(loader);
			grid.setView(liveGridView);
			
			//grid.setBorders(true);
			//TODO remove(0);
			container.add(grid, new VerticalLayoutData(1, 1));
			
			//numberer.initPlugin(grid);
			
		    ToolBar toolBar = new ToolBar();
		    toolBar.add(new LiveToolItem(grid));
		    //toolBar.add(new LabelToolItem("my label"));
		    container.add(toolBar, new VerticalLayoutData(1, 25));
		    //toolBar.addStyleName(ThemeStyles.getStyle().borderTop());
		    //toolBar.getElement().getStyle().setProperty("borderBottom", "none");
		    
			container.forceLayout();
			
			Scheduler.get().scheduleDeferred(new ScheduledCommand() {
				
				@Override
				public void execute() {
					container.forceLayout();
				}
			});
			
			loader.load(0, liveGridView.getCacheSize());
			
		} else {
			//TODO we need to manually reset the sort
			loader.clearSortInfo();
			reader.setDefinition(tableDefinition);
			grid.reconfigure(store, columnModel);
			//TODO workaround: the loader is called only if the scroll bar is in the middle
			if (loader.getOffset()==0) loader.load(new PagingLoadConfigBean(0, liveGridView.getCacheSize()));
		}
	}

}
