/**
 * 
 */
package org.gcube.portlets.user.tdw.server.datasource.jdbc.dialect;

import org.apache.log4j.Logger;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class SQLDialectManager {
	
	protected static Logger logger = Logger.getLogger(SQLDialectManager.class);
	
	protected static GenericSQLDialect generic = new GenericSQLDialect();
	
	protected static SQLDialect[] dialects = new SQLDialect[]{
		new Derby_10_7_SQLDialect(),
		new PostgresSQL_8_x_x_SQLDialect(),
		new MySQL_5_x_x_SQLDialect()
	};
	
	public static SQLDialect getDialect(String databaseProductName, int databaseMajorVersion, int databaseMinorVersion) throws Exception
	{
		logger.trace("getting dialect for databaseProductName: "+databaseProductName+" databaseMajorVersion: "+databaseMajorVersion+" databaseMinorVersion: "+databaseMinorVersion);
		for (SQLDialect dialect:dialects) if (dialect.supportDataBase(databaseProductName, databaseMajorVersion, databaseMinorVersion)) {
			
			logger.trace("selected dialect: "+dialect.getName());
			return dialect;
		}
		logger.warn("No SQL dialect found for databaseProductName: "+databaseProductName+ " databaseMajorVersion: "+ databaseMajorVersion + " databaseMinorVersion: "+databaseMinorVersion);
		return generic;
	}
	
}
