/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.datasource.td.map;

import java.util.List;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ViewColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.RelationshipData;
import org.gcube.portlets.user.tdwx.datasource.td.map.ColumnTypeMap;
import org.gcube.portlets.user.tdwx.datasource.td.map.DataTypeMap;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ColumnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnDefinitionBuilder {
    protected Logger logger = LoggerFactory.getLogger(ColumnDefinitionBuilder.class);
    protected Column serviceColumn;
    protected String tooltipMessage;
    protected String columnName;
    protected String columnLocalId;
    protected boolean visible;
    protected boolean editable;
    protected ColumnType type;
    protected String columnLabel;
    protected String locale;
    protected int ordinalPosition;
    protected RelationshipData relationshipData;
    protected String sourceTableDimensionColumnId;
    protected String targetTableColumnId;
    protected long targetTableId;
    protected boolean viewColumn;

    public ColumnDefinitionBuilder(Column serviceColumn, int ordinalPosition) {
        this.serviceColumn = serviceColumn;
        this.ordinalPosition = ordinalPosition;
        this.visible = true;
        this.type = ColumnType.USER;
        this.editable = true;
        org.gcube.data.analysis.tabulardata.model.column.ColumnType ct = serviceColumn.getColumnType();
        if (ColumnTypeMap.isIdColumnType(ct)) {
            this.columnLabel = "Id";
            this.visible = false;
            this.editable = false;
            this.type = ColumnType.COLUMNID;
        } else {
            if (ColumnTypeMap.isValidationColumnType(ct)) {
                this.type = ColumnType.VALIDATION;
                this.editable = false;
            }
            if (ColumnTypeMap.isTimeDimensionColumnType(ct)) {
                this.type = ColumnType.TIMEDIMENSION;
                this.visible = false;
                this.retrieveRelationship();
            }
            if (ColumnTypeMap.isDimensionColumnType(ct)) {
                this.type = ColumnType.DIMENSION;
                this.visible = false;
                this.retrieveRelationship();
            }
            if (serviceColumn.contains(ViewColumnMetadata.class)) {
                ViewColumnMetadata viewMetadata = (ViewColumnMetadata)serviceColumn.getMetadata(ViewColumnMetadata.class);
                this.logger.debug("ViewColumnMetadata: " + viewMetadata.toString());
                this.viewColumn = true;
                this.sourceTableDimensionColumnId = viewMetadata.getSourceTableDimensionColumnId().getValue();
                this.targetTableColumnId = viewMetadata.getTargetTableColumnId().getValue();
                this.targetTableId = viewMetadata.getTargetTableId().getValue();
                this.type = ColumnType.VIEWCOLUMN;
                this.visible = false;
            } else {
                this.viewColumn = false;
            }
            NamesMetadata labelsMetadata = null;
            try {
                labelsMetadata = (NamesMetadata)serviceColumn.getMetadata(NamesMetadata.class);
            }
            catch (NoSuchMetadataException e) {
                this.logger.debug("labelMetadata: NoSuchMetadataException " + e.getLocalizedMessage());
            }
            if (labelsMetadata == null) {
                this.columnLabel = "nolabel";
            } else {
                LocalizedText cl = null;
                cl = labelsMetadata.getTextWithLocale("en");
                if (cl == null) {
                    this.columnLabel = "nolabel";
                    this.logger.debug("ColumnLabel no label in en");
                } else {
                    this.columnLabel = cl.getValue();
                    if (this.columnLabel == null || this.columnLabel.isEmpty()) {
                        this.columnLabel = "nolabel";
                    }
                }
            }
            DataLocaleMetadata dataLocaleMetadata = null;
            try {
                dataLocaleMetadata = (DataLocaleMetadata)serviceColumn.getMetadata(DataLocaleMetadata.class);
            }
            catch (NoSuchMetadataException e) {
                this.logger.debug("DataLocaleMetadata: NoSuchMetadataException " + e.getLocalizedMessage());
            }
            if (dataLocaleMetadata == null) {
                this.logger.debug("No DataLocaleMetadata");
                this.locale = "";
            } else {
                this.locale = dataLocaleMetadata.getLocale();
            }
        }
    }

    protected void retrieveRelationship() {
        ColumnRelationship rel = this.serviceColumn.getRelationship();
        if (rel != null) {
            this.relationshipData = new RelationshipData(Long.valueOf(rel.getTargetTableId().getValue()), rel.getTargetColumnId().getValue());
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public ColumnType getType() {
        return this.type;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public String getColumnName() {
        this.columnName = this.serviceColumn.getName();
        return this.columnName;
    }

    public String getColumnLocalId() {
        this.columnLocalId = this.serviceColumn.getLocalId().getValue();
        return this.columnLocalId;
    }

    public ValidationReferencesMetadata getValidationReferencesMetadata() {
        ValidationReferencesMetadata refs = null;
        try {
            refs = (ValidationReferencesMetadata)this.serviceColumn.getMetadata(ValidationReferencesMetadata.class);
        }
        catch (NoSuchMetadataException e) {
            this.logger.debug("ValidationReferencesMetadata: NoSuchMetadataException " + e.getLocalizedMessage());
        }
        return refs;
    }

    public String getTooltipMessage() {
        String valids = new String();
        ValidationsMetadata val = null;
        try {
            val = (ValidationsMetadata)this.serviceColumn.getMetadata(ValidationsMetadata.class);
        }
        catch (NoSuchMetadataException e) {
            this.logger.debug("No validatationsMetadata present: " + e.getLocalizedMessage());
        }
        if (val != null) {
            List listValidationsMetadata = val.getValidations();
            for (Validation validation : listValidationsMetadata) {
                valids.concat(validation.getDescription() + "\n");
            }
        }
        this.tooltipMessage = valids;
        return this.tooltipMessage;
    }

    public ColumnDefinition build() {
        ColumnDefinition columnDefinition = new ColumnDefinition(this.getColumnName(), this.getColumnLocalId(), this.getColumnLabel());
        columnDefinition.setLocale(this.locale);
        columnDefinition.setRelationshipData(this.relationshipData);
        columnDefinition.setViewColumn(this.viewColumn);
        columnDefinition.setTargetTableId(this.targetTableId);
        columnDefinition.setTargetTableColumnId(this.targetTableColumnId);
        columnDefinition.setSourceTableDimensionColumnId(this.sourceTableDimensionColumnId);
        DataType dataType = this.serviceColumn.getDataType();
        columnDefinition.setVisible(this.visible);
        columnDefinition.setEditable(this.editable);
        columnDefinition.setValueType(DataTypeMap.getValueType(dataType));
        columnDefinition.setType(this.getType());
        columnDefinition.setPosition(this.ordinalPosition);
        columnDefinition.setTooltipMessage(this.getTooltipMessage());
        columnDefinition.setColumnTypeName(this.serviceColumn.getColumnType().getName());
        columnDefinition.setColumnDataType(this.serviceColumn.getDataType().getName());
        columnDefinition.setWidth(100);
        return columnDefinition;
    }
}

