/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.datasource.td.map;

import java.util.List;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.PeriodTypeMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ViewColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.RelationshipData;
import org.gcube.portlets.user.tdwx.datasource.td.map.ColumnTypeMap;
import org.gcube.portlets.user.tdwx.datasource.td.map.DataTypeMap;
import org.gcube.portlets.user.tdwx.server.datasource.DataSourceXException;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ColumnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnDefinitionBuilder {
    private static final String PRIMARY_KEY_COLUMN = "id";
    private Logger logger = LoggerFactory.getLogger(ColumnDefinitionBuilder.class);
    private TabularDataService service;
    private Table serviceTable;
    private Column serviceColumn;
    private String tooltipMessage;
    private String columnName;
    private String columnLocalId;
    private boolean visible;
    private boolean editable;
    private ColumnType type;
    private String columnLabel;
    private String locale;
    private int ordinalPosition;
    private PeriodTypeMetadata periodTypeMetadata;
    protected PeriodType periodType;
    private RelationshipData relationshipData;
    private String sourceTableDimensionColumnId;
    private String targetTableColumnId;
    private long targetTableId;
    private boolean viewColumn;

    public ColumnDefinitionBuilder(TabularDataService service, Table serviceTable, Column serviceColumn, int ordinalPosition) throws DataSourceXException {
        this.service = service;
        this.serviceTable = serviceTable;
        this.serviceColumn = serviceColumn;
        this.ordinalPosition = ordinalPosition;
        this.visible = true;
        this.type = ColumnType.USER;
        this.editable = true;
        org.gcube.data.analysis.tabulardata.model.column.ColumnType ct = serviceColumn.getColumnType();
        if (ColumnTypeMap.isIdColumnType(ct)) {
            this.columnLabel = PRIMARY_KEY_COLUMN;
            this.visible = false;
            this.editable = false;
            this.type = ColumnType.COLUMNID;
        } else {
            this.periodTypeMetadata = null;
            if (serviceColumn.contains(PeriodTypeMetadata.class)) {
                this.periodTypeMetadata = (PeriodTypeMetadata)serviceColumn.getMetadata(PeriodTypeMetadata.class);
                this.periodType = this.periodTypeMetadata.getType();
            }
            if (ColumnTypeMap.isValidationColumnType(ct)) {
                this.type = ColumnType.VALIDATION;
                this.editable = false;
            } else if (ColumnTypeMap.isTimeDimensionColumnType(ct)) {
                this.type = ColumnType.TIMEDIMENSION;
                this.visible = false;
                this.retrieveRelationship();
            } else if (ColumnTypeMap.isDimensionColumnType(ct)) {
                this.type = ColumnType.DIMENSION;
                this.visible = false;
                this.retrieveRelationship();
            } else if (ColumnTypeMap.isMeasureColumnType(ct)) {
                this.type = ColumnType.MEASURE;
            } else if (ColumnTypeMap.isCodeColumnType(ct)) {
                this.type = ColumnType.CODE;
            }
            if (serviceColumn.contains(ViewColumnMetadata.class)) {
                this.retrieveViewColumnMetadata();
                this.visible = false;
                this.viewColumn = true;
            } else {
                this.viewColumn = false;
            }
            NamesMetadata labelsMetadata = null;
            try {
                labelsMetadata = (NamesMetadata)serviceColumn.getMetadata(NamesMetadata.class);
            }
            catch (NoSuchMetadataException e) {
                this.logger.debug("labelMetadata: NoSuchMetadataException " + e.getLocalizedMessage());
            }
            if (labelsMetadata == null) {
                this.columnLabel = "nolabel";
            } else {
                LocalizedText cl = null;
                cl = labelsMetadata.getTextWithLocale("en");
                if (cl == null) {
                    this.columnLabel = "nolabel";
                    this.logger.debug("ColumnLabel no label in en");
                } else {
                    this.columnLabel = cl.getValue();
                    if (this.columnLabel == null || this.columnLabel.isEmpty()) {
                        this.columnLabel = "nolabel";
                    }
                }
            }
            DataLocaleMetadata dataLocaleMetadata = null;
            try {
                dataLocaleMetadata = (DataLocaleMetadata)serviceColumn.getMetadata(DataLocaleMetadata.class);
            }
            catch (NoSuchMetadataException e) {
                this.logger.debug("DataLocaleMetadata: NoSuchMetadataException " + e.getLocalizedMessage());
            }
            if (dataLocaleMetadata == null) {
                this.logger.debug("No DataLocaleMetadata");
                this.locale = "";
            } else {
                this.locale = dataLocaleMetadata.getLocale();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void retrieveViewColumnMetadata() throws DataSourceXException {
        ViewColumnMetadata viewMetadata = (ViewColumnMetadata)this.serviceColumn.getMetadata(ViewColumnMetadata.class);
        Column sourceColumn = this.serviceTable.getColumnById(viewMetadata.getSourceTableDimensionColumnId());
        if (sourceColumn.getColumnType().getCode().compareTo(ColumnTypeCode.TIMEDIMENSION.toString()) != 0) {
            this.type = ColumnType.VIEWCOLUMN_OF_DIMENSION;
            this.sourceTableDimensionColumnId = viewMetadata.getSourceTableDimensionColumnId().getValue();
            this.targetTableColumnId = viewMetadata.getTargetTableColumnId().getValue();
            this.targetTableId = viewMetadata.getTargetTableId().getValue();
            return;
        }
        this.type = ColumnType.VIEWCOLUMN_OF_TIMEDIMENSION;
        PeriodTypeMetadata periodTypeMetadataSourceColumn = null;
        if (!sourceColumn.contains(PeriodTypeMetadata.class)) {
            this.logger.error("Error retrieving Time Table for view column:" + this.serviceColumn + " , source column do not have a PeriodTypeMetadata: " + sourceColumn);
            throw new DataSourceXException("Error retrieving Time Table, source column do not have a PeriodTypeMetadata");
        }
        periodTypeMetadataSourceColumn = (PeriodTypeMetadata)sourceColumn.getMetadata(PeriodTypeMetadata.class);
        Table timeTable = this.service.getTimeTable(periodTypeMetadataSourceColumn.getType());
        if (timeTable == null) throw new DataSourceXException("Error retrieving Time Table: " + timeTable);
        if (timeTable.getId() == null) {
            throw new DataSourceXException("Error retrieving Time Table: " + timeTable);
        }
        Column timeColumn = timeTable.getColumnByName(periodTypeMetadataSourceColumn.getType().getName());
        this.sourceTableDimensionColumnId = viewMetadata.getSourceTableDimensionColumnId().getValue();
        this.targetTableColumnId = timeColumn.getLocalId().getValue();
        this.targetTableId = timeTable.getId().getValue();
    }

    private void retrieveRelationship() throws DataSourceXException {
        if (this.serviceColumn.getColumnType().getCode().compareTo(ColumnTypeCode.TIMEDIMENSION.toString()) == 0) {
            Table timeTable = this.service.getTimeTable(this.periodTypeMetadata.getType());
            if (timeTable == null || timeTable.getId() == null) {
                throw new DataSourceXException("Error retrieving Time Table: " + timeTable);
            }
            Column timeColumn = timeTable.getColumnByName(this.periodTypeMetadata.getType().getName());
            this.relationshipData = new RelationshipData(Long.valueOf(timeTable.getId().getValue()), timeColumn.getLocalId().getValue());
        } else {
            ColumnRelationship rel = this.serviceColumn.getRelationship();
            if (rel != null) {
                this.relationshipData = new RelationshipData(Long.valueOf(rel.getTargetTableId().getValue()), rel.getTargetColumnId().getValue());
            } else {
                this.logger.error("No valid relationship for column: " + this.serviceColumn.toString());
                throw new DataSourceXException("Column  has not valid relationship");
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public ColumnType getType() {
        return this.type;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public String getColumnName() {
        this.columnName = this.serviceColumn.getName();
        return this.columnName;
    }

    public String getColumnLocalId() {
        this.columnLocalId = this.serviceColumn.getLocalId().getValue();
        return this.columnLocalId;
    }

    public ValidationReferencesMetadata getValidationReferencesMetadata() {
        ValidationReferencesMetadata refs = null;
        try {
            refs = (ValidationReferencesMetadata)this.serviceColumn.getMetadata(ValidationReferencesMetadata.class);
        }
        catch (NoSuchMetadataException e) {
            this.logger.debug("ValidationReferencesMetadata: NoSuchMetadataException " + e.getLocalizedMessage());
        }
        return refs;
    }

    public String getTooltipMessage() {
        String valids = new String();
        ValidationsMetadata val = null;
        try {
            val = (ValidationsMetadata)this.serviceColumn.getMetadata(ValidationsMetadata.class);
        }
        catch (NoSuchMetadataException e) {
            // empty catch block
        }
        if (val != null) {
            List listValidationsMetadata = val.getValidations();
            for (Validation validation : listValidationsMetadata) {
                valids.concat(validation.getDescription() + "\n");
            }
        }
        this.tooltipMessage = valids;
        return this.tooltipMessage;
    }

    public ColumnDefinition build() {
        ColumnDefinition columnDefinition = new ColumnDefinition(this.getColumnName(), this.getColumnLocalId(), this.getColumnLabel());
        columnDefinition.setLocale(this.locale);
        columnDefinition.setRelationshipData(this.relationshipData);
        columnDefinition.setViewColumn(this.viewColumn);
        columnDefinition.setTargetTableId(this.targetTableId);
        columnDefinition.setTargetTableColumnId(this.targetTableColumnId);
        columnDefinition.setSourceTableDimensionColumnId(this.sourceTableDimensionColumnId);
        DataType dataType = this.serviceColumn.getDataType();
        columnDefinition.setVisible(this.visible);
        columnDefinition.setEditable(this.editable);
        columnDefinition.setValueType(DataTypeMap.getValueType(dataType));
        columnDefinition.setType(this.getType());
        columnDefinition.setPosition(this.ordinalPosition);
        columnDefinition.setTooltipMessage(this.getTooltipMessage());
        columnDefinition.setColumnTypeName(this.serviceColumn.getColumnType().getName());
        columnDefinition.setColumnDataType(this.serviceColumn.getDataType().getName());
        columnDefinition.setWidth(100);
        return columnDefinition;
    }
}

