/**
 * 
 */
package org.gcube.portlets.user.tdwx.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.gcube.portlets.user.td.widgetcommonevent.client.event.GridHeaderColumnMenuItemEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.GridHeaderColumnMenuItemType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.CellData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.grid.model.RowRaw;
import org.gcube.portlets.user.tdwx.client.config.GridAndCellSelectionModel;
import org.gcube.portlets.user.tdwx.client.config.Row;
import org.gcube.portlets.user.tdwx.client.config.TableViewConfig;
import org.gcube.portlets.user.tdwx.client.config.TabularDataGridViewConfig;
import org.gcube.portlets.user.tdwx.client.event.CloseTableEvent;
import org.gcube.portlets.user.tdwx.client.event.CloseTableEventHandler;
import org.gcube.portlets.user.tdwx.client.event.GridReadyEvent;
import org.gcube.portlets.user.tdwx.client.event.OpenTableEvent;
import org.gcube.portlets.user.tdwx.client.event.OpenTableEventHandler;
import org.gcube.portlets.user.tdwx.client.event.TableReadyEvent;
import org.gcube.portlets.user.tdwx.client.event.TableReadyEventHandler;
import org.gcube.portlets.user.tdwx.client.filter.ExtendedGridFilters;
import org.gcube.portlets.user.tdwx.client.filter.FiltersGenerator;
import org.gcube.portlets.user.tdwx.client.model.grid.DataRowColumnConfig;
import org.gcube.portlets.user.tdwx.client.model.grid.DataRowModelKeyProvider;
import org.gcube.portlets.user.tdwx.client.model.grid.DataRowPagingReader;
import org.gcube.portlets.user.tdwx.client.model.util.ColumnConfigGenerator;
import org.gcube.portlets.user.tdwx.client.style.DefaultRowStyle;
import org.gcube.portlets.user.tdwx.client.util.ColumnPositionComparator;
import org.gcube.portlets.user.tdwx.client.util.PagingLoadUrlEncoder;
import org.gcube.portlets.user.tdwx.shared.ServletParameters;
import org.gcube.portlets.user.tdwx.shared.StaticFilterInformation;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ColumnKey;
import org.gcube.portlets.user.tdwx.shared.model.ColumnType;
import org.gcube.portlets.user.tdwx.shared.model.DataRow;
import org.gcube.portlets.user.tdwx.shared.model.TableDefinition;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.http.client.RequestBuilder;
import com.sencha.gxt.core.client.Style.SelectionMode;
import com.sencha.gxt.core.client.resources.ThemeStyles;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.client.loader.HttpProxy;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.event.StoreUpdateEvent;
import com.sencha.gxt.data.shared.loader.FilterPagingLoadConfig;
import com.sencha.gxt.data.shared.loader.FilterPagingLoadConfigBean;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.data.shared.loader.PagingLoadResult;
import com.sencha.gxt.data.shared.loader.PagingLoader;
import com.sencha.gxt.widget.core.client.ContentPanel;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.HeaderContextMenuEvent;
import com.sencha.gxt.widget.core.client.event.HeaderContextMenuEvent.HeaderContextMenuHandler;
import com.sencha.gxt.widget.core.client.event.HeaderMouseDownEvent;
import com.sencha.gxt.widget.core.client.event.HeaderMouseDownEvent.HeaderMouseDownHandler;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.LiveGridView;
import com.sencha.gxt.widget.core.client.grid.LiveToolItem;
import com.sencha.gxt.widget.core.client.grid.filters.Filter;
import com.sencha.gxt.widget.core.client.menu.Item;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import com.sencha.gxt.widget.core.client.menu.SeparatorMenuItem;
import com.sencha.gxt.widget.core.client.selection.CellSelection;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 *         Defines the panel that will contain the grid
 * 
 */
public class TabularDataXGridPanel extends ContentPanel {

	protected int tdSessionId;

	protected EventBus eventBus;

	protected List<MenuItem> headerColumnMenuItems;

	protected com.google.web.bindery.event.shared.EventBus externalBus;

	protected ListStore<DataRow> store;
	protected Grid<DataRow> grid;
	protected ToolBar toolBar;
	// protected GridInlineEditing<DataRow> editing;
	protected TableDefinition tableDefinition;
	
	protected VerticalLayoutContainer container;

	protected ExtendedLiveGridView liveGridView;

	protected DataRowPagingReader reader;

	protected PagingLoader<FilterPagingLoadConfig, PagingLoadResult<DataRow>> loader;

	protected ExtendedGridFilters<DataRow> gridFilters;
	
	protected ArrayList<StaticFilterInformation> staticFilters;

	protected TableViewConfig tableViewConfig;

	protected Menu contextMenu;

	protected TableDefinition currentTableDefinition;
	protected Map<String, ColumnKey> keys;

	private String visibleOnlyColumn;
	
	protected boolean errorNotColored=false;
	
	

	/**
	 * @param eventBus
	 */
	protected TabularDataXGridPanel(int tdSessionId, EventBus eventBus) {
		super();
		this.tdSessionId = tdSessionId;
		this.eventBus = eventBus;
		setBodyBorder(false);
		setBorders(false);
		setHeaderVisible(false);
		forceLayoutOnResize=true;
		setResize(true);
		bindEventBus();
		container = new VerticalLayoutContainer();
		container.setBorders(false);
		add(container,new MarginData(0));
		//setWidget(container);
	}

	/**
	 * @return the tableViewConfig
	 */
	public TableViewConfig getTableViewConfig() {
		return tableViewConfig;
	}

	/**
	 * @param tableViewConfig
	 *            the tableViewConfig to set
	 */
	public void setTableViewConfig(TableViewConfig tableViewConfig) {
		this.tableViewConfig = tableViewConfig;
	}

	/**
	 * @return the grid
	 */
	public Grid<DataRow> getGrid() {
		return grid;
	}

	/**
	 * Return the context menu of grid
	 * 
	 * @return context menu of grid
	 */
	public Menu getGridContextMenu() {
		return contextMenu;
	}

	/**
	 * Add context menu of grid
	 * 
	 */
	public void setGridContextMenu(Menu contextMenu) {
		this.contextMenu = contextMenu;
	}

	/**
	 * Return table definition
	 * 
	 * @return
	 */
	public TableDefinition getTableDefinition() {
		return tableDefinition;
	}

	/**
	 * Get static filters
	 * 
	 * @return
	 */
	public ArrayList<StaticFilterInformation> getStaticFilters() {
		return staticFilters;
	}

	/**
	 * Set static filters
	 * 
	 * @param staticFilters
	 */
	public void setStaticFilters(ArrayList<StaticFilterInformation> staticFilters) {
		this.staticFilters = staticFilters;
	}
	
	/**
	 * Returns the selected row.
	 * 
	 * @return the selected row, <code>null</code> if no row is selected.
	 */
	public Row getSelectedRow() {
		if (grid != null) {
			DataRow dataRow = grid.getSelectionModel().getSelectedItem();
			if (dataRow != null)
				return new Row(dataRow, keys);
		}

		return null;
	}

	/**
	 * 
	 * 
	 * Set SelectionMode
	 * 
	 * The selection model supports 3 different selection modes: SINGLE - Only
	 * single selections allowed SIMPLE - Multiple selections without having to
	 * use the control and shift keys MULTI - Multiple selections
	 * 
	 * 
	 * @param mode
	 */
	public void setSelectionModel(SelectionMode mode) {
		if (grid != null && grid.getSelectionModel() != null) {
			grid.getSelectionModel().setSelectionMode(mode);
		}
	}

	/**
	 * 
	 * 
	 * getSelectedRows
	 * 
	 * @return List<Row> when multiple selection is enable
	 */
	public List<Row> getSelectedRows() {

		if (grid != null && grid.getSelectionModel() != null) {
			List<DataRow> dataRows = grid.getSelectionModel()
					.getSelectedItems();
			List<Row> rows = new ArrayList<Row>();
			for (DataRow dataRow : dataRows) {
				if (dataRow != null) {
					rows.add(new Row(dataRow, keys));
				}
			}
			return rows;
		}

		return null;
	}
	
	

	/**
	 * 
	 * 
	 * @return Selected Row as RowRaw
	 */
	public RowRaw getSelectedRowAsRaw() {
		if (grid != null && grid.getSelectionModel() != null) {
			List<DataRow> dataRows = grid.getSelectionModel()
					.getSelectedItems();
			List<Row> rows = new ArrayList<Row>();
			for (DataRow dataRow : dataRows) {
				if (dataRow != null) {
					rows.add(new Row(dataRow, keys));
				}
			}

			RowRaw r = null;
			
			if (rows.size() > 0) {
				HashMap<String, String> map = new HashMap<String, String>();
				ColumnModel<DataRow> columnModel = grid.getColumnModel();
				List<ColumnConfig<DataRow, ?>> columns = columnModel
						.getColumns();
				Row rowFirst = rows.get(0);
				DataRowColumnConfig<?> columnDataRow = null;
				String rowId=null;
				for (ColumnConfig<DataRow, ?> col : columns) {
					columnDataRow = (DataRowColumnConfig<?>) col;
					ColumnDefinition colDef = columnDataRow.getDefinition();
					if (colDef != null) {
						String value;
						if (colDef.getColumnDataType()
								.compareTo("Date") == 0) {
							value = rowFirst.getFieldAsDate(colDef
									.getColumnLocalId());
						} else {
							value = rowFirst.getFieldAsText(colDef
									.getColumnLocalId());
						}
						map.put(colDef.getColumnLocalId(), value);
						ColumnType ctype = colDef.getType();
						if (ctype == ColumnType.COLUMNID) {
							rowId=value;
						}
					
					}
				}
				if(rowId!=null && !rowId.isEmpty() && map.size()>0){
					r=new RowRaw(rowId,map);
				}

			}
			return r;
		}

		return null;
	}

	/**
	 * Retrieve selected cell value
	 * 
	 * @return
	 */
	public CellData getSelectedCell() {

		if (grid != null && grid.getSelectionModel() != null) {

			CellSelection<DataRow> cell = ((GridAndCellSelectionModel<DataRow>) grid
					.getSelectionModel()).getCellSelected();
			if (cell != null) {
				DataRow dataRow = cell.getModel();
				Row row = new Row(dataRow, keys);

				ColumnModel<DataRow> columnModel = grid.getColumnModel();
				List<ColumnConfig<DataRow, ?>> columns = columnModel
						.getColumns();

				// Retrive ColumnId
				DataRowColumnConfig<?> columnId = null;
				boolean columnIdRetrieved = false;
				for (ColumnConfig<DataRow, ?> col : columns) {
					columnId = (DataRowColumnConfig<?>) col;
					ColumnType ctype = columnId.getDefinition().getType();
					if (ctype == ColumnType.COLUMNID) {
						columnIdRetrieved = true;
						break;
					}
				}
				if (columnIdRetrieved) {
					Log.debug("ColumnId Retrieved");
					ColumnDefinition columnIdSelected = columnId
							.getDefinition();
					// Retrive ColumnSelected
					ColumnConfig<DataRow, ?> colSelected = columns.get(cell
							.getCell());
					DataRowColumnConfig<?> cSelected = (DataRowColumnConfig<?>) colSelected;
					ColumnDefinition cdSelected = cSelected.getDefinition();

					String cellValue;
					if (cdSelected.getColumnDataType().compareTo("Date") == 0) {
						cellValue = row.getFieldAsDate(cdSelected
								.getColumnLocalId());
					} else {
						cellValue = row.getFieldAsText(cdSelected
								.getColumnLocalId());
					}

					String columnIdValue = row.getFieldAsText(columnIdSelected
							.getColumnLocalId());

					CellData tdCell = new CellData(cellValue,
							cdSelected.getId(), cdSelected.getColumnLocalId(),
							cdSelected.getLabel(), columnIdValue,
							cell.getRow(), cell.getCell());

					Log.debug("Selected Cell: " + tdCell);
					return tdCell;
				} else {
					Log.debug("No ColumnId Retrieved");
					return null;
				}
			} else {
				Log.debug("No cell selected");
			}
		} else {
			Log.debug("No gridSelectionModel set");
		}

		return null;
	}

	/**
	 * Set one and only one visible column
	 * 
	 * @param columnLocalId
	 */
	public void setVisibleOnlyColumn(String columnLocalId) {
		Log.debug("setVisibleOnlyColumn: " + columnLocalId);
		visibleOnlyColumn = columnLocalId;

	}
	
	/**
	 * 
	 * @return
	 */
	public boolean isErrorNotColored() {
		return errorNotColored;
	}
	
	/**
	 * 
	 * @param errorNotColored if true set background withe for rows with error
	 */
	public void setErrorNotColored(boolean errorNotColored) {
		Log.debug("ErrorNotColored set :"+errorNotColored);
		this.errorNotColored = errorNotColored;
	}
	

	/**
	 * 
	 * @param columnModel
	 * @return
	 */
	protected ColumnModel<DataRow> checkOnlyColumn(
			ColumnModel<DataRow> columnModel) {
		if (visibleOnlyColumn != null && !visibleOnlyColumn.isEmpty()) {
			Log.debug("setVisibleOnlyColumn: Grid not null");

			List<ColumnConfig<DataRow, ?>> columns = columnModel.getColumns();

			List<ColumnConfig<DataRow, ?>> columnsNew = new ArrayList<ColumnConfig<DataRow, ?>>();
			// Retrive Column with conlumnLocalId
			DataRowColumnConfig<?> columnTarget = null;
			// boolean columnTargetRetrieved = false;
			for (ColumnConfig<DataRow, ?> col : columns) {
				columnTarget = (DataRowColumnConfig<?>) col;
				String columnLocal = columnTarget.getDefinition()
						.getColumnLocalId();
				if (visibleOnlyColumn.compareTo(columnLocal) == 0) {
					// columnTargetRetrieved = true;
					columnTarget.setHidden(false);
					columnsNew.add(columnTarget);
				} else {
					columnTarget.setHidden(true);
					columnsNew.add(columnTarget);
				}
			}
			columnModel = new ColumnModel<DataRow>(columnsNew);

		} else {
			Log.debug("visibleOnlyColumn null");
		}
		return columnModel;

	}

	/**
	 * Retrieve selected cell value
	 * 
	 * @param columnLocalId
	 * @return
	 */
	public ArrayList<String> getCellValue(String columnLocalId) {
		ArrayList<String> value = null;
		if (grid != null) {
			ColumnModel<DataRow> columnModel = grid.getColumnModel();

			List<ColumnConfig<DataRow, ?>> columns = columnModel.getColumns();

			// Retrive Column with conlumnLocalId
			DataRowColumnConfig<?> columnTarget = null;
			boolean columnTargetRetrieved = false;
			for (ColumnConfig<DataRow, ?> col : columns) {
				columnTarget = (DataRowColumnConfig<?>) col;
				String columnLocal = columnTarget.getDefinition()
						.getColumnLocalId();
				if (columnLocalId.compareTo(columnLocal) == 0) {
					columnTargetRetrieved = true;
					break;
				}
			}

			if (columnTargetRetrieved) {
				ColumnDefinition cd = columnTarget.getDefinition();
				Log.debug("CD - Definition:" + cd.getId() + " ColumnLocalId:"
						+ cd.getColumnLocalId() + " Label:" + cd.getLabel()
						+ " Key:" + cd.getKey());
				List<Row> rowsSelected = getSelectedRows();
				Log.debug("Retriving rows selected");
				String rowS = "";
				ArrayList<String> rows = new ArrayList<String>();
				if (rowsSelected != null) {
					for (Row row : rowsSelected) {
						rowS = row.getFieldAsText(cd.getColumnLocalId());
						Log.debug("Selected Row:" + rowS);
						rows.add(rowS);
					}
				} else {
					Log.debug("no selected rows retrieved");
				}
				return rows;
			} else {
				Log.debug("no column target retrieved");
			}
		}
		return value;
	}

	/**
	 * getSelectedRowsId
	 * 
	 * @return List<String> list of identifiers of the selected rows
	 */
	public ArrayList<String> getSelectedRowsId() {
		if (grid != null) {
			ColumnModel<DataRow> columnModel = grid.getColumnModel();

			List<ColumnConfig<DataRow, ?>> columns = columnModel.getColumns();
			DataRowColumnConfig<?> c = null;
			boolean columnIdRetrieved = false;
			for (ColumnConfig<DataRow, ?> col : columns) {
				c = (DataRowColumnConfig<?>) col;
				ColumnType ctype = c.getDefinition().getType();
				if (ctype == ColumnType.COLUMNID) {
					columnIdRetrieved = true;
					break;
				}
			}

			if (columnIdRetrieved) {
				ColumnDefinition cd = c.getDefinition();
				Log.debug("CD - Definition:" + cd.getId() + " ColumnLocalId:"
						+ cd.getColumnLocalId() + " Label:" + cd.getLabel()
						+ " Key:" + cd.getKey());
				List<Row> rowsSelected = getSelectedRows();
				Log.debug("Retriving rows selected");
				String rowS = "";
				ArrayList<String> rows = new ArrayList<String>();
				if (rowsSelected != null) {
					for (Row row : rowsSelected) {
						rowS = row.getFieldAsText(cd.getColumnLocalId());
						Log.debug("Selected Row:" + rowS);
						rows.add(rowS);
					}
				} else {
					Log.debug("no selected rows retrived");
				}
				return rows;
			} else {
				Log.debug("no COLUMNID retrived");
				return null;
			}

		} else {
			return null;
		}

	}

	/**
	 * 
	 */
	protected void bindEventBus() {
		eventBus.addHandler(OpenTableEvent.TYPE, new OpenTableEventHandler() {

			public void onOpenTable(OpenTableEvent event) {
				doOpenTable();
			}
		});

		eventBus.addHandler(TableReadyEvent.TYPE, new TableReadyEventHandler() {

			public void onTableReady(TableReadyEvent event) {
				doTableReady(event.getTableDefinition());
			}
		});

		eventBus.addHandler(CloseTableEvent.TYPE, new CloseTableEventHandler() {

			public void onCloseTable(CloseTableEvent event) {
				doCloseTable();
			}
		});
	}

	protected void doOpenTable() {
		mask();
	}

	protected void doTableReady(TableDefinition definition) {
		Log.trace("table ready, setting grid up");
		mask("Loading table " + definition.getName() + "... ");
		setupGrid(definition);
		this.currentTableDefinition = definition;
		keys = new HashMap<String, ColumnKey>();
		for (ColumnDefinition column : definition.getColumnsAsList())
			keys.put(column.getColumnLocalId(), column.getKey());
		unmask();
	}

	protected void doCloseTable() {
		mask();
		grid = null;
		this.currentTableDefinition = null;
		this.keys.clear();
		container.clear();
		unmask();
	}

	/**
	 * 
	 * @param handler
	 */
	protected void addHeaderMouseDownHandler(HeaderMouseDownHandler handler) {
		if (grid != null) {

			if (handler == null) {
				handler = new HeaderMouseDownHandler() {

					@Override
					public void onHeaderMouseDown(HeaderMouseDownEvent event) {
						Log.debug("HeaderMouseDownEvent :"
								+ event.toDebugString());
						if (event.getEvent().getButton() == NativeEvent.BUTTON_RIGHT) {
							event.getEvent().stopPropagation();
						} else {

						}

					}
				};
			}
			;
			grid.addHeaderMouseDownHandler(handler);
		}
	}

	/**
	 * Define the grid
	 * 
	 * 
	 * @param tableDefinition
	 */
	protected void setupGrid(TableDefinition tableDefinition) {
		this.tableDefinition = tableDefinition;

		ColumnDefinition modelKeyColumn = tableDefinition.getModelKeyColumn();
		store = new ListStore<DataRow>(new DataRowModelKeyProvider(
				modelKeyColumn.getKey()));

		store.addStoreUpdateHandler(new StoreUpdateEvent.StoreUpdateHandler<DataRow>() {

			@Override
			public void onUpdate(StoreUpdateEvent<DataRow> event) {
				Log.debug("UPDATE ROWS");
				Log.debug(event.getItems().toString());
			}
		});

		List<ColumnConfig<DataRow, ?>> columnsConfig = new ArrayList<ColumnConfig<DataRow, ?>>();

		List<ColumnDefinition> columns = tableDefinition.getColumnsAsList();
		Collections.sort(columns, new ColumnPositionComparator(false));

		for (ColumnDefinition columnDefinition : columns) {
			if (columnDefinition.getType() != ColumnType.SYSTEM)
				columnsConfig.add(ColumnConfigGenerator
						.generateConfiguration(columnDefinition));
		}

		// IdentityValueProvider<DataRow> identity = new
		// IdentityValueProvider<DataRow>();
		// LiveRowNumberer<DataRow> numberer = new
		// LiveRowNumberer<DataRow>(identity);
		// columnsConfig.add(numberer);

		ColumnModel<DataRow> columnModel = new ColumnModel<DataRow>(
				columnsConfig);

		columnModel = checkOnlyColumn(columnModel);

		if (grid == null) {

			reader = new DataRowPagingReader(tableDefinition);

			String path = GWT.getModuleBaseURL() + "tdwxdata";
			RequestBuilder builder = new RequestBuilder(RequestBuilder.POST,
					path);
			builder.setHeader(ServletParameters.TD_SESSION_ID,
					String.valueOf(tdSessionId));
			// builder.setHeader("Content-Type",
			// "application/x-www-form-urlencoded");

			HttpProxy<FilterPagingLoadConfig> proxy = new HttpProxy<FilterPagingLoadConfig>(
					builder);
			proxy.setWriter(new PagingLoadUrlEncoder(staticFilters));

			loader = new PagingLoader<FilterPagingLoadConfig, PagingLoadResult<DataRow>>(
					proxy, reader) {
				@Override
				protected FilterPagingLoadConfig newLoadConfig() {
					return new FilterPagingLoadConfigBean();
				}
			};

			/*
			 * HttpProxy<PagingLoadConfig> proxy = new
			 * HttpProxy<PagingLoadConfig>( builder); proxy.setWriter(new
			 * PagingLoadUrlEncoder());
			 * 
			 * loader = new PagingLoader<PagingLoadConfig,
			 * PagingLoadResult<DataRow>>( proxy, reader) {
			 * 
			 * @Override protected PagingLoadConfig newLoadConfig() { return new
			 * PagingLoadConfigBean(); } };
			 */

			loader.setRemoteSort(true);

			loader.addLoadHandler(new LoadResultListStoreBinding<FilterPagingLoadConfig, DataRow, PagingLoadResult<DataRow>>(
					store));

			liveGridView = new ExtendedLiveGridView();

			// liveGridView.setRowHeight(19);

			grid = new Grid<DataRow>(store, columnModel);
			GridAndCellSelectionModel<DataRow> sm = new GridAndCellSelectionModel<DataRow>();

			grid.setSelectionModel(sm);
			grid.setLoadMask(true);
			grid.setLoader(loader);
			grid.setView(liveGridView);
			grid.setBorders(false);
			
			// TODO disabled editing rows
			/*
			 * editing = new GridInlineEditing<DataRow>(grid);
			 * editing.setClicksToEdit(ClicksToEdit.TWO);
			 * 
			 * for (ColumnConfig<DataRow, ?> c : columnsConfig) {
			 * ColumnConfigGenerator.setEditor(editing, c); }
			 */

			// numberer.initPlugin(grid);

			// Filter
			ArrayList<Filter<DataRow, ?>> filters = FiltersGenerator
					.generate(columnModel);
			gridFilters = new ExtendedGridFilters<DataRow>(loader);

			gridFilters.initPlugin(grid);
			gridFilters.setLocal(false);
			Log.debug("Filters: " + filters.size());
			for (Filter<DataRow, ?> filterGeneric : filters) {
				gridFilters.addFilter(filterGeneric);
			}

			//
			container.add(grid, new VerticalLayoutData(1, 1, new Margins(0)));
			
			toolBar = new ToolBar();
			toolBar.add(new LiveToolItem(grid));
			toolBar.addStyleName(ThemeStyles.getStyle().borderTop());
			toolBar.getElement().getStyle().setProperty("borderBottom", "none");

			container.add(toolBar,
					new VerticalLayoutData(1, 24, new Margins(0)));

			container.forceLayout();

			loader.load(0, liveGridView.getCacheSize());

			if (contextMenu != null) {
				grid.setContextMenu(contextMenu);
			} else
				grid.setContextMenu(null);

			if (headerColumnMenuItems != null) {
				setHeaderContextMenuHandler();
			}

		} else {
			// TODO we need to manually reset the sort
			loader.clearSortInfo();
			reader.setDefinition(tableDefinition);

			grid.reconfigure(store, columnModel);

			ArrayList<Filter<DataRow, ?>> filters = FiltersGenerator
					.generate(columnModel);
			gridFilters.removeAll();

			Log.debug("Filters: " + filters.size());
			for (Filter<DataRow, ?> filterGeneric : filters) {
				gridFilters.addFilter(filterGeneric);
			}

			// TODO Disabled editing rows
			//
			// editing = new GridInlineEditing<DataRow>(grid);
			// editing.setClicksToEdit(ClicksToEdit.TWO);
			//
			// for (ColumnConfig<DataRow, ?> c : columnsConfig) {
			// ColumnConfigGenerator.setEditor(editing, c); }
			//

			// TODO workaround: the loader is called only if the scroll bar is
			// in the middle
			// if (loader.getOffset() == 0)
			// loader.load();
			loader.load(0, liveGridView.getCacheSize());
		}

		if (tableViewConfig != null) {
			Log.debug("Use specific grid View");
			if (tableViewConfig.getRowStyleProvider() != null) {
				grid.getView().setViewConfig(
						new TabularDataGridViewConfig(tableViewConfig,
								tableDefinition));
			}
		} else {
			Log.debug("Use default grid View");
			tableViewConfig= new TableViewConfig();
			Log.debug("Error Not Colored: "+errorNotColored);
			DefaultRowStyle rowStyle=new DefaultRowStyle(errorNotColored);
			
			tableViewConfig.setRowStyleProvider(rowStyle);
			grid.getView().setViewConfig(
					new TabularDataGridViewConfig(tableViewConfig,
							tableDefinition));
			//	grid.getView().setViewConfig(null);
		}

		container.forceLayout();

		Scheduler.get().scheduleDeferred(new ScheduledCommand() {

			public void execute() {
				container.forceLayout();
			}
		});

		eventBus.fireEvent(new GridReadyEvent());
		
		
		
		
	}

	/**
	 * 
	 * Add Items to menu of Columns
	 * 
	 * @param items
	 * @param externalBus
	 */
	public void addGridHeaderContextMenuItems(final List<MenuItem> items,
			com.google.web.bindery.event.shared.EventBus externalBus) {
		this.headerColumnMenuItems = items;
		this.externalBus = externalBus;
	}

	/**
	 * Set Items on Menu of Columns
	 * 
	 */
	protected void setHeaderContextMenuHandler() {

		HeaderContextMenuHandler headerContextMenuHandler = new HeaderContextMenuEvent.HeaderContextMenuHandler() {

			public void onHeaderContextMenu(HeaderContextMenuEvent event) {
				Log.debug("Header Menu");
				final Menu menu = event.getMenu();
				final int colIndex = event.getColumnIndex();
				SelectionHandler<Item> handlerHeaderContextMenu = new SelectionHandler<Item>() {

					public void onSelection(SelectionEvent<Item> event) {
						Log.debug("Selected: "
								+ event.getSelectedItem().getId());
						if (event.getSelectedItem() instanceof MenuItem) {
							Log.debug("Event instanceof MenuItem");
							MenuItem menuItem = (MenuItem) event
									.getSelectedItem();
							if (headerColumnMenuItems.contains(menuItem)) {
								Log.debug("Event Fire on EventBus");
								externalBus
										.fireEvent(new GridHeaderColumnMenuItemEvent(
												GridHeaderColumnMenuItemType.SELECTED,
												menuItem.getId(), colIndex));

								menu.hide();
							}
						}
					}
				};

				menu.addSelectionHandler(handlerHeaderContextMenu);

				Log.debug("Adding Items to menu");
				SeparatorMenuItem separatorItem = new SeparatorMenuItem();
				menu.add(separatorItem);
				for (MenuItem m : headerColumnMenuItems) {
					menu.add(m);
				}
				menu.show();
			}
		};
		Log.debug("Created Handler");
		grid.addHeaderContextMenuHandler(headerContextMenuHandler);
		Log.debug("Header Column Menu Added");

	}

	/**
	 * 
	 * @param i
	 *            index of column in ColumnModel
	 * @return id of column and equals to column name on service
	 */
	public String getColumnName(int i) {
		Log.debug("Retrive Column Id of column:" + i);
		String columnName = null;
		if (grid != null) {
			ColumnModel<DataRow> columnModel = grid.getColumnModel();
			List<ColumnConfig<DataRow, ?>> columns = columnModel.getColumns();

			DataRowColumnConfig<?> dc = (DataRowColumnConfig<?>) columns.get(i);

			columnName = dc.getDefinition().getId();
			Log.debug("Column - Definition: Id: " + columnName);

		}
		return columnName;
	}

	
	/**
	 * 
	 * @param i
	 *            index of column in ColumnModel
	 * @return id of column and equals to column name on service
	 */
	public String getColumnLocalId(int i) {
		Log.debug("Retrive Column Local Id of column:" + i);
		String columnLocalId = null;
		if (grid != null) {
			ColumnModel<DataRow> columnModel = grid.getColumnModel();
			List<ColumnConfig<DataRow, ?>> columns = columnModel.getColumns();

			DataRowColumnConfig<?> dc = (DataRowColumnConfig<?>) columns.get(i);

			columnLocalId = dc.getDefinition().getColumnLocalId();
			Log.debug("Column - Definition: Column Local Id: " + columnLocalId);

		}
		return columnLocalId;
	}
	
	
	/**
	 * 
	 * @param rows
	 */
	public void addRow(ArrayList<String> rows) {
		// TODO Disabled AddROW
		/*
		 * if (grid != null && editing != null) {
		 * 
		 * List<ColumnKey> keys = tableDefinition.getKeys();
		 * 
		 * DataRow dataRow = new DataRow(keys.size()); for (ColumnKey key :
		 * keys) { dataRow.set(key, null); }
		 * 
		 * editing.cancelEditing(); int pos = 0; if (rows != null && rows.size()
		 * > 0) { pos = new Integer(rows.get(0)); }
		 * 
		 * store.add(pos, dataRow);
		 * 
		 * int row = store.indexOf(dataRow); editing.startEditing(new
		 * GridCell(row, pos)); }
		 */
	}

	protected class ExtendedLiveGridView extends LiveGridView<DataRow> {
		// TODO bug in gxt3 3.0.0 fixed in future

		@Override
		public void refresh(boolean headerToo) {
			preventScrollToTopOnRefresh = true;
			super.refresh(headerToo);
		}

	};

}
