package org.gcube.portlets.user.templates.client;

import java.util.Vector;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DecoratorPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * <code> StaticElementsPanel </code> class is the component of the UI which contains the buttons for enabling user add 
 * static elements in the current template  
 *
 * @author Massimiliano Assante, ISTI-CNR - massimiliano.assante@isti.cnr.it
 * 
 * @version september 2008 (0.1) 
 * @see <code>ToolBoxPanel</code> 
 */

public class StaticElementsPanel extends Composite {
	
	private VerticalPanel mainLayout = new VerticalPanel();

	Grid grid = new Grid(5, 2);

	ToggleButton insertTextButton = new ToggleButton(new Image(TGenConstants.IMAGE_INSERT_TEXT));
	ToggleButton insertImageButton = new ToggleButton(new Image(TGenConstants.IMAGE_INSERT_IMAGE));
	ToggleButton insertTableButton = new ToggleButton(new Image(TGenConstants.IMAGE_INSERT_TABLE));
//	ToggleButton insertWorkFlowButton = new ToggleButton(new Image(TGenConstants.IMAGE_INSERT_WORKFLOW));
	ToggleButton insertDroppingButton = new ToggleButton(new Image(TGenConstants.IMAGE_INSERT_DROPPING));
	ToggleButton insertInputTextButton = new ToggleButton(new Image(TGenConstants.IMAGE_INSERT_INPUT_TEXTBOX));

	private Vector<ToggleButton> tools = new Vector<ToggleButton>();

	/**
	 *
	 */
	public StaticElementsPanel() {
		
		//****  features not supported so far
//		insertWorkFlowButton.setEnabled(false);
		insertTableButton.setEnabled(true);
		
		
		mainLayout.setWidth("100%");
		mainLayout.setHeight("100%");

		grid.setCellSpacing(10);
		grid.setCellPadding(10);

		DecoratorPanel dec = new DecoratorPanel();
		dec.add(insertTextButton);
		insertTextButton.setTitle("Insert a static text");
		tools.add(insertTextButton);

		DecoratorPanel dec2 = new DecoratorPanel();
		dec2.add(insertImageButton);
		insertImageButton.setTitle("Insert a static image");
		tools.add(insertImageButton);

		DecoratorPanel dec3 = new DecoratorPanel();
		dec3.add(insertTableButton);
		insertTableButton.setTitle("Insert a static table (not available so far)");
		tools.add(insertTableButton);
//		
//		DecoratorPanel dec4 = new DecoratorPanel();
//		dec4.add(insertWorkFlowButton);
//		insertWorkFlowButton.setTitle("Insert a static workflow (not available so far)");
//		tools.add(insertWorkFlowButton);
		
		DecoratorPanel dec5 = new DecoratorPanel();
		dec5.add(insertDroppingButton);
		insertDroppingButton.setTitle("Insert a Dropping Image Area");
		tools.add(insertDroppingButton);
		
		DecoratorPanel dec6 = new DecoratorPanel();
		dec6.add(insertInputTextButton);
		insertInputTextButton.setTitle("Insert an input Text Area");
		tools.add(insertInputTextButton);

		
		//place command buttons
		grid.setWidget(0, 0, dec);
		grid.setWidget(0, 1, dec2);
		grid.setWidget(1, 0, dec6);
		grid.setWidget(1, 1, dec5);
		grid.setWidget(2, 0, dec3);
//		grid.setWidget(2, 1, dec4);
//		
		mainLayout.add(grid);
		initWidget(mainLayout);

//		insertTextButton.addClickListener(new ClickListener() {
//			public void onClick(Widget sender) {
//				if (insertTextButton.isDown()) {
//					WorkspacePanel.get().enableDrawing();
//					WorkspacePanel.get().setSelectedButton(CommonConstants.STATIC_TEXT);
//				}					
//				else
//					WorkspacePanel.get().disableDrawing();
//
//				setAllButtonsUp(sender);
//			}
//		});
//
//		insertImageButton.addClickListener(new ClickListener() {
//			public void onClick(Widget sender) {
//				if (insertImageButton.isDown()) {
//					WorkspacePanel.get().enableDrawing();
//					WorkspacePanel.get().setSelectedButton(CommonConstants.STATIC_IMAGE);
//				}					
//				else
//					WorkspacePanel.get().disableDrawing();
//
//				setAllButtonsUp(sender);
//			}
//		});
//		
//		insertDroppingButton.addClickListener(new ClickListener() {
//			public void onClick(Widget sender) {
//				if (insertDroppingButton.isDown()) {
//					WorkspacePanel.get().enableDrawing();
//					WorkspacePanel.get().setSelectedButton(CommonConstants.DROPPING_AREA);
//				}					
//				else
//					WorkspacePanel.get().disableDrawing();
//
//				setAllButtonsUp(sender);
//			}
//		});
//		
//		insertInputTextButton.addClickListener(new ClickListener() {
//			public void onClick(Widget sender) {
//				if (insertInputTextButton.isDown()) {
//					WorkspacePanel.get().enableDrawing();
//					WorkspacePanel.get().setSelectedButton(CommonConstants.INPUT_TEXTBOX_AREA);
//				}					
//				else
//					WorkspacePanel.get().disableDrawing();
//
//				setAllButtonsUp(sender);
//			}
//		});
		
		

//		insertTableButton.addClickListener(new ClickListener() {
//			public void onClick(Widget sender) {
//				if (insertTableButton.isDown())
//					TemplateGenerator.get().getMainLayout().addStyleName("crossCursor");
//				else
//					TemplateGenerator.get().getMainLayout().removeStyleName("crossCursor");
//				setAllButtonsUp(sender);
//			} 	
//		});
//		
//		insertWorkFlowButton.addClickListener(new ClickListener() {
//			public void onClick(Widget sender) {
//				if (insertWorkFlowButton.isDown())
//					TemplateGenerator.get().getMainLayout().addStyleName("crossCursor");
//				else
//					TemplateGenerator.get().getMainLayout().removeStyleName("crossCursor");
//				setAllButtonsUp(sender);
//			} 	
//		});

	}


	/**
	 * 
	 * @param sender the only toggle button not to be put up
	 */

	public void setAllButtonsUp(Widget sender) {

		for (int i = 0; i < tools.size(); i++) {
			ToggleButton temp = tools.elementAt(i);
			if (! temp.equals(sender))
				temp.setDown(false);
		}
	}
	
	/**
	 * Set the toggle buttons all up 
	 */
	public void resetButtons() {
		for (int i = 0; i < tools.size(); i++) 
			tools.elementAt(i).setDown(false);		
	}
}
