/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.templates.client.dialogs;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.user.templates.client.components.Coords;
import org.gcube.portlets.user.templates.client.components.DoubleColumnPanel;
import org.gcube.portlets.user.templates.client.components.DroppingArea;
import org.gcube.portlets.user.templates.client.components.FancyFileUpload;
import org.gcube.portlets.user.templates.client.components.ImageArea;
import org.gcube.portlets.user.templates.client.dialogs.ImageUploaderDialog;
import org.gcube.portlets.user.templates.client.model.TemplateComponent;
import org.gcube.portlets.user.templates.client.presenter.Presenter;

public class ImageUploaderDialog
extends DialogBox {
    private int width;
    private int height;
    private Coords start;
    private Presenter controller;
    private DroppingArea placeHolder;
    private String currTemplateName = "";
    private HorizontalPanel topLabel = new HorizontalPanel();
    private EventListener listener = new EventListener(this, null);
    private RadioButton local = new RadioButton("");
    private RadioButton web = new RadioButton("");
    private VerticalPanel mainLayout = new VerticalPanel();
    private VerticalPanel dialogPanel = new VerticalPanel();

    public ImageUploaderDialog(Presenter controller, Coords start, int width, int height, DroppingArea toRemove) {
        this.placeHolder = toRemove;
        this.width = 400;
        this.height = 200;
        this.start = start;
        this.controller = controller;
        this.setText("Insert Image");
        this.local.setHTML(" From this computer");
        this.topLabel.add((Widget)this.local);
        this.local.setChecked(true);
        this.web.setHTML(" From the web (URL)");
        this.topLabel.add((Widget)this.web);
        this.web.addClickListener((ClickListener)this.listener);
        this.local.addClickListener((ClickListener)this.listener);
        this.dialogPanel.add((Widget)this.topLabel);
        this.currTemplateName = controller.getModel().getTemplateName();
        FancyFileUpload uploader = new FancyFileUpload(this, this.currTemplateName);
        HTML theLabel = new HTML("<strong>Browse your computer for the image file to upload:</strong>");
        this.dialogPanel.add((Widget)theLabel);
        this.dialogPanel.add((Widget)uploader);
        this.dialogPanel.setSpacing(4);
        this.dialogPanel.setStyleName("uploadDialog");
        this.dialogPanel.setPixelSize(this.width, this.height);
        this.mainLayout.add((Widget)this.topLabel);
        this.mainLayout.add((Widget)this.dialogPanel);
        this.setWidget((Widget)this.mainLayout);
    }

    public ImageUploaderDialog(Presenter controller) {
        this.width = 400;
        this.height = 200;
        this.controller = controller;
        this.setText("Insert Image");
        this.local.setHTML(" From this computer");
        this.topLabel.add((Widget)this.local);
        this.local.setChecked(true);
        this.web.setHTML(" From the web (URL)");
        this.topLabel.add((Widget)this.web);
        this.web.addClickListener((ClickListener)this.listener);
        this.local.addClickListener((ClickListener)this.listener);
        this.currTemplateName = controller.getModel().getTemplateName();
        this.dialogPanel.add((Widget)this.getFromLocalPanel());
        this.dialogPanel.setPixelSize(this.width, this.height);
        this.mainLayout.add((Widget)this.topLabel);
        this.mainLayout.add((Widget)this.dialogPanel);
        this.setWidget((Widget)this.mainLayout);
    }

    private VerticalPanel getFromLocalPanel() {
        VerticalPanel toReturn = new VerticalPanel();
        FancyFileUpload uploader = new FancyFileUpload(this, this.currTemplateName);
        HTML theLabel = new HTML("<strong>Browse your computer for the image file to upload:</strong>");
        toReturn.add((Widget)theLabel);
        toReturn.add((Widget)uploader);
        toReturn.setSpacing(4);
        toReturn.setStyleName("uploadDialog");
        toReturn.setPixelSize(this.width, this.height);
        return toReturn;
    }

    private VerticalPanel getFromURLPanel() {
        VerticalPanel toReturn = new VerticalPanel();
        toReturn.setSpacing(5);
        HTML theLabel = new HTML("<strong>Enter image web address:</strong>");
        TextBox urlTextbox = new TextBox();
        urlTextbox.setWidth("90%");
        HTML previewBox = new HTML("<div style=\"text-align:center;\"><font style=\"color: rgb(136, 136, 136);\"><br /> Image preview will be displayed here. <br><br> *Remember: Using others' images on the web without their permission may be bad manners, or worse, copyright infringement. <br><br></font></div>", true);
        previewBox.setStyleName("imagePreviewBox");
        toReturn.add((Widget)theLabel);
        toReturn.add((Widget)urlTextbox);
        toReturn.add((Widget)previewBox);
        urlTextbox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel buttonsPanel = new HorizontalPanel();
        buttonsPanel.add((Widget)new Button("Insert", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
        buttonsPanel.add((Widget)new Button("Cancel", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
        buttonsPanel.setSpacing(5);
        toReturn.add((Widget)buttonsPanel);
        return toReturn;
    }

    public void insertImage(String imageName) {
        String imgURL = this.getImageURL(imageName, "CURRENT_OPEN");
        this.controller.getCurrentSelected().getExtendedFormatter().insertImage(imgURL);
    }

    public void placeImage(String imageName) {
        this.start.setX(this.start.getX() - 1);
        this.start.setY(this.start.getY() - this.controller.getWp().getAbsoluteTop() - 1);
        String templateName = this.controller.getModel().getTemplateName();
        int index = this.controller.getWorkSpacePanel().getMainLayout().getWidgetIndex((Widget)this.placeHolder);
        ImageArea imgToPlace = new ImageArea(this.controller, false, imageName, templateName, this.start.getX(), this.start.getY(), this.width, this.height);
        if (index == -1) {
            index = this.controller.getWorkSpacePanel().getMainLayout().getWidgetIndex(this.placeHolder.getParent());
            DoubleColumnPanel dblCp = (DoubleColumnPanel)this.controller.getWorkSpacePanel().getMainLayout().getWidget(index);
            dblCp.insertImage((Widget)this.placeHolder, imgToPlace);
            TemplateComponent tc = this.controller.getModel().removeComponentFromModel((Widget)this.placeHolder);
            tc.setType(ComponentType.STATIC_IMAGE);
            tc.setContent((Widget)imgToPlace);
            tc.setDoubleColLayout(true);
            this.controller.setCurrCursorPos(index);
            this.controller.getModel().addComponentToModel(tc, index);
        } else {
            this.controller.getWp().removeComponentFromLayout((Widget)this.placeHolder);
            TemplateComponent tc = this.controller.getModel().removeComponentFromModel((Widget)this.placeHolder);
            this.controller.setCurrCursorPos(index);
            this.controller.insertStaticImage(this.start, this.width, this.height, imgToPlace, tc.isDoubleColLayout());
        }
        this.controller.setCurrCursorPos(index);
    }

    public String getImageURL(String imageName, String templateName) {
        String currentUser = this.controller.getCurrentUser();
        String currentScope = this.controller.getCurrentScope();
        String host = GWT.getModuleBaseURL().substring(0, GWT.getModuleBaseURL().length() - 6);
        int lastSlash = host.lastIndexOf("/");
        host = host.substring(0, lastSlash + 1);
        String imgURL = String.valueOf(host) + "usersArea/" + currentScope + "/templates/" + currentUser + "/" + "CURRENT_OPEN" + "/images/" + imageName;
        return imgURL;
    }

    static /* synthetic */ RadioButton access$0(ImageUploaderDialog imageUploaderDialog) {
        return imageUploaderDialog.web;
    }

    static /* synthetic */ VerticalPanel access$1(ImageUploaderDialog imageUploaderDialog) {
        return imageUploaderDialog.dialogPanel;
    }

    static /* synthetic */ VerticalPanel access$2(ImageUploaderDialog imageUploaderDialog) {
        return imageUploaderDialog.getFromURLPanel();
    }

    static /* synthetic */ RadioButton access$3(ImageUploaderDialog imageUploaderDialog) {
        return imageUploaderDialog.local;
    }

    static /* synthetic */ VerticalPanel access$4(ImageUploaderDialog imageUploaderDialog) {
        return imageUploaderDialog.getFromLocalPanel();
    }

    static /* synthetic */ Presenter access$5(ImageUploaderDialog imageUploaderDialog) {
        return imageUploaderDialog.controller;
    }
}

