/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.templates.client.components;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.d4sreporting.common.client.uicomponents.ReportUIComponent;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.user.templates.client.presenter.Presenter;

public class ImageArea
extends ReportUIComponent {
    private String templateName;
    private String imageName;
    private String currentUser;
    private String currentScope;
    private Image myImage = new Image();
    private Presenter presenter = this.presenter;

    public ImageArea(Presenter controller, boolean isURL, String param, String myTemplate, int left, int top, int width, int height) {
        super(ComponentType.STATIC_IMAGE, left, top, width, height);
        this.currentUser = controller.getCurrentUser();
        this.currentScope = controller.getCurrentScope();
        if (isURL) {
            int lastSlash = param.lastIndexOf("/");
            this.imageName = lastSlash > -1 ? param.substring(lastSlash + 1, param.length()) : param;
            this.templateName = "CURRENT_OPEN";
            this.myImage.setUrl(param);
        } else {
            this.imageName = param;
            this.templateName = myTemplate;
            String imgURL = this.getImageURL(this.imageName, "CURRENT_OPEN");
            this.myImage.setUrl(imgURL);
        }
        VerticalPanel myPanel = this.getResizablePanel();
        myPanel.add((Widget)this.myImage);
        this.myImage.setPixelSize(width - 2, height - 6);
    }

    public void resizePanel(int width, int height) {
        super.resizePanel(width, height);
        this.myImage.setPixelSize(width - 4, height - 6);
    }

    public String getImageURL(String imageName, String templateName) {
        String host = Window.Location.getProtocol() + "//" + Window.Location.getHost() + "/";
        String imgURL = host + "usersArea/" + this.currentScope + "/templates/" + this.currentUser + "/" + "CURRENT_OPEN" + "/images/" + imageName;
        return imgURL;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String myTemplate) {
        this.templateName = myTemplate;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void lockComponent(ReportUIComponent toLock, boolean locked) {
        this.presenter.lockComponent((Widget)this, locked);
    }

    public void removeTemplateComponent(ReportUIComponent toRemove) {
        this.presenter.removeTemplateComponent((Widget)this);
    }
}

