/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.templates.client.model;

import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.BasicSection;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;
import org.gcube.portlets.d4sreporting.common.shared.Model;
import org.gcube.portlets.user.templates.client.TemplateService;
import org.gcube.portlets.user.templates.client.TemplateServiceAsync;
import org.gcube.portlets.user.templates.client.components.Coords;
import org.gcube.portlets.user.templates.client.model.TemplateComponent;
import org.gcube.portlets.user.templates.client.model.TemplateModel;
import org.gcube.portlets.user.templates.client.model.TemplateSection;
import org.gcube.portlets.user.templates.client.presenter.Presenter;

public class TemplateModel {
    private final TemplateServiceAsync modelService = (TemplateServiceAsync)GWT.create(TemplateService.class);
    public static final int OLD_TEMPLATE_WIDTH = 950;
    public static final int TEMPLATE_WIDTH = 750;
    public static final int TEMPLATE_HEIGHT = 1000;
    public static final String DEFAULT_NAME = "UnnamedTemplate";
    private String uniqueID = "";
    private String templateName = "UnnamedTemplate";
    private String author = null;
    private String lastEditBy;
    private Date dateCreated = null;
    private Date lastEdit = null;
    private int pageWidth = 750;
    private int pageHeight = 1000;
    private int currentPage = 1;
    private int totalPages = 1;
    private int marginLeft = 25;
    private int marginRight = 25;
    private int marginTop = 20;
    private int marginBottom = 20;
    private int columnWidth = this.pageWidth - (this.marginLeft + this.marginRight);
    private HashMap<String, TemplateSection> sections = new HashMap();
    private List<Metadata> metadata = new LinkedList();

    public void addComponentToModel(TemplateComponent tc, int index) {
        String tcPage = "" + tc.getTemplatePage();
        GWT.log((String)("ADDING TO MODEL-> X=" + tc.getX() + " Y: " + tc.getY() + " Type: " + tc.getType()), null);
        if (this.sections.containsKey(tcPage)) {
            TemplateSection singleSection = (TemplateSection)this.sections.get(tcPage);
            singleSection.addComponent(tc, index);
        } else {
            TemplateSection singleSection = new TemplateSection();
            singleSection.addComponent(tc, 0);
            this.sections.put(tcPage, singleSection);
        }
        this.storeInSession();
    }

    public TemplateComponent removeComponentFromModel(Widget toRemove) {
        String tcPage = "" + this.currentPage;
        TemplateSection singleSection = (TemplateSection)this.sections.get(tcPage);
        TemplateComponent toReturn = singleSection.removeComponent(toRemove);
        this.storeInSession();
        return toReturn;
    }

    public void updateModelComponentIndex(Widget toUpdate, int newIndex) {
        String tcPage = "" + this.currentPage;
        TemplateSection singleSection = (TemplateSection)this.sections.get(tcPage);
        singleSection.updateModelComponentIndex(toUpdate, newIndex);
    }

    public void storeInSession() {
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        Model modelToSend = this.getSerializableModel();
        this.modelService.storeTemplateInSession(modelToSend, (AsyncCallback)callback);
    }

    public void resetModelInSession() {
        2 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.modelService.storeTemplateInSession(null, (AsyncCallback)callback);
    }

    public void serializeModel(String basketidToSaveIn) {
        MessageBox box = MessageBox.wait((String)"Saving Operation", (String)"saving template", (String)"please wait...");
        3 callback = new /* Unavailable Anonymous Inner Class!! */;
        Model modelToSend = this.getSerializableModel();
        this.modelService.saveTemplate(basketidToSaveIn, modelToSend, (AsyncCallback)callback);
        4 t = new /* Unavailable Anonymous Inner Class!! */;
        t.schedule(2500);
    }

    private Model getSerializableModel() {
        Vector<BasicSection> serializedsections = new Vector<BasicSection>();
        int i = 1;
        while (i <= this.sections.size()) {
            String pageNo = "" + i;
            if (this.sections.get(pageNo) != null) {
                TemplateSection singleSection = (TemplateSection)this.sections.get(pageNo);
                List templateElements = singleSection.getAllComponents();
                LinkedList<BasicComponent> serialazableComponents = new LinkedList<BasicComponent>();
                BasicSection aSection = new BasicSection();
                for (TemplateComponent tc : templateElements) {
                    serialazableComponents.add(tc.getSerializable());
                }
                aSection.setComponents(serialazableComponents);
                aSection.setMetadata(singleSection.getAllMetadata());
                serializedsections.add(aSection);
            }
            ++i;
        }
        Model toReturn = new Model(this.uniqueID, this.author, this.dateCreated, this.lastEdit, this.lastEditBy, this.templateName, this.columnWidth, this.currentPage, this.marginBottom, this.marginLeft, this.marginRight, this.marginTop, this.pageHeight, this.pageWidth, serializedsections, this.totalPages, this.metadata);
        return toReturn;
    }

    public TemplateSection discardSection(int sectNo) {
        TemplateSection toRemove = (TemplateSection)this.sections.remove("" + sectNo);
        int i = sectNo + 1;
        while (i <= this.totalPages) {
            this.sections.put("" + (i - 1), (TemplateSection)this.sections.get("" + i));
            ++i;
        }
        --this.totalPages;
        return toRemove;
    }

    public void resizeModelComponent(Widget toResize, int newWidth, int newHeight) {
        GWT.log((String)"LOOKING CORRESPONDANCE", null);
        String tcPage = "" + this.currentPage;
        TemplateSection singleSection = (TemplateSection)this.sections.get(tcPage);
        singleSection.resizeModelComponent(toResize, newWidth, newHeight);
        this.storeInSession();
    }

    public void lockComponent(Widget toLock, boolean locked) {
        String tcPage = "" + this.currentPage;
        TemplateSection singleSection = (TemplateSection)this.sections.get(tcPage);
        singleSection.lockComponent(toLock, locked);
        this.storeInSession();
    }

    public void repositionModelComponent(Widget toRepos, int newX, int newY) {
        String tcPage = "" + this.currentPage;
        TemplateSection singleSection = (TemplateSection)this.sections.get(tcPage);
        singleSection.repositionModelComponent(toRepos, newX, newY);
        this.storeInSession();
    }

    public void insertNewPage() {
        ++this.currentPage;
        ++this.totalPages;
        this.storeInSession();
    }

    public List<TemplateComponent> getSectionComponent(int pageNo) {
        return ((TemplateSection)this.sections.get("" + pageNo)).getAllComponents();
    }

    public TemplateSection getSection(int pageNo) {
        return (TemplateSection)this.sections.get("" + pageNo);
    }

    public void loadModel(Model toLoad, Presenter controller) {
        this.author = toLoad.getAuthor();
        this.dateCreated = toLoad.getDateCreated();
        this.lastEdit = toLoad.getLastEdit();
        this.lastEditBy = toLoad.getLastEditBy();
        this.templateName = toLoad.getTemplateName();
        this.pageWidth = toLoad.getPageWidth();
        this.pageHeight = toLoad.getPageHeight();
        this.currentPage = toLoad.getCurrPage();
        this.totalPages = toLoad.getTotalPages();
        this.marginLeft = toLoad.getMarginLeft();
        this.marginRight = toLoad.getMarginRight();
        this.marginTop = toLoad.getMarginTop();
        this.marginBottom = toLoad.getMarginBottom();
        this.metadata = toLoad.getMetadata();
        this.columnWidth = this.pageWidth - (this.marginLeft + this.marginRight);
        Vector sectionsSerialized = toLoad.getSections();
        this.sections = new HashMap();
        int pageNo = 1;
        for (BasicSection serialazableSection : sectionsSerialized) {
            Vector<TemplateComponent> myTemplateSection = new Vector<TemplateComponent>();
            for (BasicComponent sc : serialazableSection.getComponents()) {
                myTemplateSection.add(new TemplateComponent(this, sc, controller, true));
            }
            GWT.log((String)("Section Metadata:" + serialazableSection.getMetadata().size()), null);
            this.sections.put("" + pageNo, new TemplateSection(myTemplateSection, serialazableSection.getMetadata()));
            ++pageNo;
        }
    }

    public void importSectionInModel(Presenter controller, Model toLoad, int sectionNoToimport, int beforeSection, boolean asLastSection) {
        int pageNo = this.totalPages + 1;
        BasicSection toImport = (BasicSection)toLoad.getSections().get(sectionNoToimport - 1);
        Vector<TemplateComponent> myTemplateSection = new Vector<TemplateComponent>();
        for (BasicComponent sc : toImport.getComponents()) {
            myTemplateSection.add(new TemplateComponent(this, sc, controller, true));
        }
        GWT.log((String)("Section Metadata:" + toImport.getMetadata().size()), null);
        if (asLastSection) {
            this.sections.put("" + pageNo, new TemplateSection(myTemplateSection, toImport.getMetadata()));
        } else {
            HashMap<String, TemplateSection> newSections = new HashMap<String, TemplateSection>();
            boolean isAdded = false;
            int i = 1;
            while (i <= this.totalPages + 1) {
                if (beforeSection == i) {
                    newSections.put("" + i, new TemplateSection(myTemplateSection, toImport.getMetadata()));
                    isAdded = true;
                } else {
                    int insertIn = isAdded ? i - 1 : i;
                    newSections.put("" + i, (TemplateSection)this.sections.get("" + insertIn));
                    GWT.log((String)("Inserting " + insertIn + " into section " + i + " isAdded =" + isAdded), null);
                }
                ++i;
            }
            this.sections = newSections;
            GWT.log((String)("NEW SECTION SIZE" + this.sections.size()), null);
        }
        ++this.totalPages;
    }

    public Vector<TemplateComponent> getOthersPageTC(Widget toCheck) {
        String tcPage = "" + this.currentPage;
        TemplateSection singleSection = (TemplateSection)this.sections.get(tcPage);
        Vector<TemplateComponent> toReturn = new Vector<TemplateComponent>();
        int i = 0;
        while (i < singleSection.getAllComponents().size()) {
            TemplateComponent tc = singleSection.getComponent(i);
            if (!tc.getContent().equals(toCheck)) {
                toReturn.add(tc);
            }
            ++i;
        }
        return toReturn;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
        this.storeInSession();
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
        this.storeInSession();
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
        this.columnWidth = this.pageWidth - (marginLeft + this.marginRight);
        this.storeInSession();
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
        this.columnWidth = this.pageWidth - (this.marginLeft + marginRight);
        this.storeInSession();
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
        this.storeInSession();
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
        this.storeInSession();
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
        this.columnWidth = pageWidth - (this.marginLeft + this.marginRight);
        this.storeInSession();
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
        this.storeInSession();
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
        this.storeInSession();
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getLastEdit() {
        return this.lastEdit;
    }

    public void setLastEdit(Date lastEdit) {
        this.lastEdit = lastEdit;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
        this.storeInSession();
    }

    public TemplateServiceAsync getModelService() {
        return this.modelService;
    }

    public List<Metadata> getMetadata() {
        return this.metadata;
    }

    public String getLastEditBy() {
        return this.lastEditBy;
    }

    public void setLastEditBy(String lastEditBy) {
        this.lastEditBy = lastEditBy;
    }

    public Coords getNewInsertionPoint(int currSection) {
        List elems = this.getSectionComponent(currSection);
        if (elems == null) {
            return new Coords(25, 25);
        }
        int maxY = 0;
        for (TemplateComponent templateComponent : elems) {
            GWT.log((String)("->" + templateComponent.getY() + " height: " + templateComponent.getHeight()), null);
            if (maxY >= templateComponent.getY() + templateComponent.getHeight()) continue;
            maxY = templateComponent.getY() + templateComponent.getHeight();
        }
        GWT.log((String)("New insertion Point-> " + maxY), null);
        return new Coords(25, maxY - 25);
    }
}

