/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.topics.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portlets.user.topics.client.TopicService;
import org.gcube.portlets.user.topics.shared.HashTagAndOccurrence;
import org.gcube.portlets.user.topics.shared.HashtagsWrapper;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicServiceImpl
extends RemoteServiceServlet
implements TopicService {
    private static final Logger _log = LoggerFactory.getLogger(TopicServiceImpl.class);
    public static final String TEST_USER = "test.user";
    private DatabookStore store;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devsec/devVRE");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getDevelopmentUser() {
        String user = TEST_USER;
        return user;
    }

    public HashtagsWrapper getHashtags() {
        ArrayList<String> hashtagsChart = new ArrayList<String>();
        ASLSession session = this.getASLSession();
        String userName = session.getUsername();
        boolean isInfrastructure = this.isInfrastructureScope();
        try {
            if (userName.compareTo(TEST_USER) == 0) {
                _log.debug("Found " + userName + " returning nothing");
                return null;
            }
            ArrayList<HashTagAndOccurrence> toSort = new ArrayList<HashTagAndOccurrence>();
            if (isInfrastructure) {
                _log.debug("****** retrieving hashtags for user VREs");
                User currUser = OrganizationsUtil.validateUser((String)userName);
                LiferayGroupManager gm = new LiferayGroupManager();
                for (Organization org : currUser.getOrganizations()) {
                    if (!gm.isVRE(org.getOrganizationId() + "").booleanValue()) continue;
                    String vreid = gm.getScope("" + org.getOrganizationId());
                    Map map = this.store.getVREHashtagsWithOccurrence(vreid);
                    for (String hashtag : map.keySet()) {
                        toSort.add(new HashTagAndOccurrence(hashtag, (Integer)map.get(hashtag)));
                    }
                }
            } else {
                String scope = session.getScope();
                _log.debug("****** retrieving hashtags for scope " + scope);
                Map map = this.store.getVREHashtagsWithOccurrence(scope);
                for (String hashtag : map.keySet()) {
                    toSort.add(new HashTagAndOccurrence(hashtag, (Integer)map.get(hashtag)));
                }
            }
            Collections.sort(toSort, Collections.reverseOrder());
            int i = 0;
            for (HashTagAndOccurrence wrapper : toSort) {
                String hashtag;
                hashtag = wrapper.getHashtag();
                String href = "\"?" + new String(Base64.encodeBase64((byte[])"hashtagIdentificationParameter".getBytes())) + "=" + new String(Base64.encodeBase64((byte[])hashtag.getBytes())) + "\"";
                String hashtagLink = "<a class=\"topiclink\" href=" + href + ">" + hashtag + "</a>";
                hashtagsChart.add(hashtagLink);
                if (++i < 10) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return new HashtagsWrapper(isInfrastructure, hashtagsChart);
    }

    private boolean isInfrastructureScope() {
        boolean toReturn = false;
        try {
            ScopeBean scope = new ScopeBean(this.getASLSession().getScope());
            toReturn = scope.is(ScopeBean.Type.INFRASTRUCTURE);
            return toReturn;
        }
        catch (NullPointerException e) {
            _log.error("NullPointerException in isInfrastructureScope returning false");
            return false;
        }
    }
}

