/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.topics.server.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gcube.portlets.user.topics.server.cache.CacheInterface;
import org.gcube.portlets.user.topics.server.cache.CacheUtilities;
import org.gcube.portlets.user.topics.server.cache.CacheValueBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicsCacheImpl
implements CacheInterface<String, ArrayList<String>> {
    private static final Logger logger = LoggerFactory.getLogger(TopicsCacheImpl.class);
    private static TopicsCacheImpl instance = new TopicsCacheImpl();
    private Map<String, CacheValueBean<ArrayList<String>>> cacheMap = new HashMap();
    private static final long EXPIRED_AFTER = 120000L;

    private TopicsCacheImpl() {
    }

    public static TopicsCacheImpl getCacheInstance() {
        return instance;
    }

    public ArrayList<String> get(String key) {
        if (this.cacheMap.containsKey(key)) {
            CacheValueBean bean = (CacheValueBean)this.cacheMap.get(key);
            if (CacheUtilities.expired((long)bean.getTTL(), (long)120000L)) {
                this.cacheMap.remove(key);
                logger.debug("TopTopics for scope " + key + "expired, return null");
            } else {
                return (ArrayList)bean.getValue();
            }
        }
        return null;
    }

    public boolean insert(String key, ArrayList<String> value) {
        CacheValueBean newBean = new CacheValueBean(value, System.currentTimeMillis());
        if (this.cacheMap.containsKey(key)) {
            this.cacheMap.remove(key);
        }
        this.cacheMap.put(key, newBean);
        return true;
    }
}

