/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.uriresolvermanager.readers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.user.uriresolvermanager.entity.ServiceAccessPoint;
import org.gcube.portlets.user.uriresolvermanager.entity.ServiceParameter;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeResourceReader {
    public static final Logger logger = LoggerFactory.getLogger(RuntimeResourceReader.class);
    public List<ServiceAccessPoint> serviceAccessPoints;
    private String resourceName;
    private String entryName;

    public RuntimeResourceReader(String resourceName) throws Exception {
        this.resourceName = resourceName;
        this.readResource(resourceName);
    }

    private void readResource(String resourceName) throws Exception {
        try {
            String scope = ScopeProvider.instance.get();
            logger.info("Trying to read resource: " + resourceName + ", in the scope: " + scope);
            this.resourceName = resourceName;
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Name/string() eq '" + resourceName + "'");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List r = client.submit((Query)query);
            if (r == null || r.isEmpty()) {
                throw new Exception("Cannot retrieve the runtime resource with name: " + resourceName + " in the scope: " + scope);
            }
            ServiceEndpoint se = (ServiceEndpoint)r.get(0);
            if (se.profile() == null) {
                String msg = "Runtime reosource with resource name: " + resourceName + " is null in the scope: " + scope;
                logger.error(msg);
                throw new Exception(msg);
            }
            Group accessPoints = se.profile().accessPoints();
            if (accessPoints.size() == 0) {
                throw new Exception("Accesspoint in resource " + resourceName + " not found");
            }
            Iterator acIt = accessPoints.iterator();
            this.serviceAccessPoints = new ArrayList<ServiceAccessPoint>(accessPoints.size());
            while (acIt.hasNext()) {
                ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)acIt.next();
                Group properties = ap.properties();
                if (properties.size() == 0) {
                    logger.warn("Properties in resource " + resourceName + " not found for ap: " + ap.name());
                    this.serviceAccessPoints.add(new ServiceAccessPoint(ap.name(), ap.address(), null));
                    continue;
                }
                ArrayList<ServiceParameter> serviceParameters = new ArrayList<ServiceParameter>(properties.size());
                for (ServiceEndpoint.Property prop : properties) {
                    serviceParameters.add(new ServiceParameter(prop.value(), true));
                }
                this.serviceAccessPoints.add(new ServiceAccessPoint(ap.name(), ap.address(), serviceParameters));
            }
            logger.debug("Found properties: " + this.serviceAccessPoints);
        }
        catch (Exception e) {
            logger.error("Sorry, an error occurred on reading the resource " + resourceName + " Runtime Resource", (Throwable)e);
            throw new Exception("Sorry, an error occurred on reading the resource " + resourceName + " Runtime Reosurce");
        }
    }

    public ServiceAccessPoint getServiceAccessPointForEntryName(String entryName) {
        for (ServiceAccessPoint serviceAccessPoint : this.serviceAccessPoints) {
            if (!serviceAccessPoint.getEntryName().equals(entryName)) continue;
            return serviceAccessPoint;
        }
        return null;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public List<ServiceAccessPoint> getServiceAccessPoints() {
        return this.serviceAccessPoints;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RuntimeResourceReader [serviceAccessPoints=");
        builder.append(this.serviceAccessPoints);
        builder.append(", resourceName=");
        builder.append(this.resourceName);
        builder.append(", entryName=");
        builder.append(this.entryName);
        builder.append("]");
        return builder.toString();
    }
}

