/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlet.user.userstatisticsportlet.server.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gcube.portlet.user.userstatisticsportlet.server.cache.CacheInterface;
import org.gcube.portlet.user.userstatisticsportlet.server.cache.CacheUtilities;
import org.gcube.portlet.user.userstatisticsportlet.server.cache.CacheValueBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserInfrastructureSpaceCache
implements CacheInterface<String, Long> {
    private static final Logger logger = LoggerFactory.getLogger(UserInfrastructureSpaceCache.class);
    private static UserInfrastructureSpaceCache instance = new UserInfrastructureSpaceCache();
    private Map<String, CacheValueBean<Long>> userSpaceMap = new ConcurrentHashMap();
    private static final long EXPIRED_AFTER = 600000L;

    private UserInfrastructureSpaceCache() {
    }

    public static UserInfrastructureSpaceCache getCacheInstance() {
        return instance;
    }

    public Long get(String key) {
        if (this.userSpaceMap.containsKey(key)) {
            CacheValueBean bean = (CacheValueBean)this.userSpaceMap.get(key);
            if (CacheUtilities.expired((long)bean.getTTL(), (long)600000L)) {
                this.userSpaceMap.remove(key);
                logger.debug("Amount of space in the infrastructure used expired for key " + key + ", returning null");
            } else {
                return (Long)bean.getValue();
            }
        }
        return null;
    }

    public boolean insert(String key, Long value) {
        CacheValueBean newBean = new CacheValueBean((Object)value, System.currentTimeMillis());
        if (this.userSpaceMap.containsKey(key)) {
            this.userSpaceMap.remove(key);
        }
        this.userSpaceMap.put(key, newBean);
        return true;
    }
}

