/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlet.user.userstatisticsportlet.server;

import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.WebsiteLocalServiceUtil;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServerUtils {
    private static final Log logger = LogFactoryUtil.getLog(ServerUtils.class);

    public static GCubeUser getCurrentUser(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest is null!");
        }
        PortalContext pContext = PortalContext.getConfiguration();
        GCubeUser user = pContext.getCurrentUser(request);
        logger.debug((Object)("Returning user " + user));
        return user;
    }

    public static String getCurrentContext(HttpServletRequest request, boolean setInThread) {
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest is null!");
        }
        PortalContext pContext = PortalContext.getConfiguration();
        String context = pContext.getCurrentScope(request);
        logger.debug((Object)("Returning context " + context));
        if (context != null && setInThread) {
            ScopeProvider.instance.set(context);
        }
        return context;
    }

    public static String getCurrentSecurityToken(HttpServletRequest request, boolean setInThread) {
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest is null!");
        }
        PortalContext pContext = PortalContext.getConfiguration();
        String token = pContext.getCurrentUserToken(request);
        logger.debug((Object)("Returning token " + token));
        if (token != null && setInThread) {
            SecurityTokenProvider.instance.set(token);
        }
        return token;
    }

    public static boolean isInfrastructureScope(String userid, HttpServletRequest request) {
        boolean toReturn = false;
        try {
            LiferayGroupManager manager = new LiferayGroupManager();
            long groupId = manager.getGroupIdFromInfrastructureScope(ServerUtils.getCurrentContext((HttpServletRequest)request, (boolean)false));
            toReturn = manager.isVRE(groupId) == false || userid != null;
            return toReturn;
        }
        catch (Exception e) {
            logger.error((Object)"NullPointerException in isInfrastructureScope returning false");
            return false;
        }
    }

    public static boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            logger.trace((Object)"Development Mode ON");
            return false;
        }
    }

    public static String formatFileSize(long size) {
        String formattedSize = null;
        double b = size;
        double k = (double)size / 1024.0;
        double m = (double)size / 1024.0 / 1024.0;
        double g = (double)size / 1024.0 / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        formattedSize = t >= 1.0 ? dec.format(t).concat(" TB") : (g >= 1.0 ? dec.format(g).concat(" GB") : (m >= 1.0 ? dec.format(m).concat(" MB") : (k >= 1.0 ? dec.format(k).concat(" KB") : dec.format(b).concat(" Bytes"))));
        return formattedSize;
    }

    public static int evaluateProfileStrenght(User user, boolean imageIsPresent) {
        int score = ServerUtils.evaluateContactScore((User)user);
        return score += ServerUtils.evaluateInformationScore((User)user, (boolean)imageIsPresent);
    }

    public static int evaluateInformationScore(User user, boolean imageIsPresent) {
        String summary;
        int score = 0;
        if (user.getJobTitle() != null) {
            score += !user.getJobTitle().isEmpty() ? 20 : 0;
        }
        if (user.getOpenId() != null) {
            score += !user.getOpenId().isEmpty() ? 20 : 0;
        }
        if ((summary = ServerUtils.getSummary((User)user)) != null) {
            int lenght = summary.replace(" ", "").length();
            float partialScore = (float)lenght / 10.0f;
            score += partialScore > 20.0f ? 20 : (int)partialScore;
        }
        if (imageIsPresent) {
            score += 5;
        }
        return score;
    }

    public static String getSummary(User user) {
        if (user.getComments() != null) {
            String toReturn = ServerUtils.escapeHtml((String)user.getComments());
            toReturn = toReturn.replaceAll("(\r\n|\n)", " <br/> ");
            toReturn = toReturn.replaceAll("\\s\\s", "&nbsp;&nbsp;");
            return toReturn;
        }
        return null;
    }

    public static String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static int evaluateContactScore(User user) {
        int score = 0;
        try {
            List websites;
            Contact contact = user.getContact();
            if (contact.getMySpaceSn() != null) {
                score += !contact.getMySpaceSn().isEmpty() ? 5 : 0;
            }
            if (contact.getTwitterSn() != null) {
                score += !contact.getTwitterSn().isEmpty() ? 5 : 0;
            }
            if (contact.getFacebookSn() != null) {
                score += !contact.getFacebookSn().isEmpty() ? 5 : 0;
            }
            if (contact.getSkypeSn() != null) {
                score += !contact.getSkypeSn().isEmpty() ? 5 : 0;
            }
            if (contact.getJabberSn() != null) {
                score += !contact.getJabberSn().isEmpty() ? 5 : 0;
            }
            if (contact.getAimSn() != null) {
                score += !contact.getAimSn().isEmpty() ? 5 : 0;
            }
            score += (websites = WebsiteLocalServiceUtil.getWebsites((long)user.getCompanyId(), (String)"com.liferay.portal.model.Contact", (long)contact.getContactId())).size() > 0 ? 5 : 0;
        }
        catch (Exception e) {
            logger.error((Object)"Contact profile score evaluation failed!!");
            score = 0;
        }
        return score;
    }

    public static void setPermissionChecker() {
        if (ServerUtils.isWithinPortal()) {
            try {
                long adminId = LiferayUserManager.getAdmin().getUserId();
                PrincipalThreadLocal.setName((long)adminId);
                PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)UserLocalServiceUtil.getUser((long)adminId));
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to set permission checker. Custom fields set/get operations are likely to fail...");
            }
        }
    }

    public static void createUserCustomField(String customFieldNameUserStatisticsVisibility, boolean startingValue) {
        if (ServerUtils.isWithinPortal()) {
            try {
                ServerUtils.setPermissionChecker();
                User defaultUser = UserLocalServiceUtil.getDefaultUser((long)ManagementUtils.getCompany().getCompanyId());
                boolean exists = defaultUser.getExpandoBridge().hasAttribute(customFieldNameUserStatisticsVisibility);
                if (exists) {
                    logger.debug((Object)"Custom field already exists... There is no need to create it");
                } else {
                    logger.debug((Object)("Creating custom field " + customFieldNameUserStatisticsVisibility + " with starting value " + startingValue));
                    defaultUser.getExpandoBridge().addAttribute(customFieldNameUserStatisticsVisibility, 1, (Serializable)Boolean.valueOf(true));
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to create custom field " + customFieldNameUserStatisticsVisibility));
            }
        }
    }
}

