/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlet.user.userstatisticsportlet.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.custom.communitymanager.SiteManagerUtil;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portlet.user.userstatisticsportlet.client.UserStatisticsService;
import org.gcube.portlet.user.userstatisticsportlet.server.ServerUtils;
import org.gcube.portlet.user.userstatisticsportlet.server.cache.UserInfrastructureSpaceCache;
import org.gcube.portlet.user.userstatisticsportlet.shared.PostsStatsBean;
import org.gcube.portlet.user.userstatisticsportlet.shared.UserInformation;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;

public class UserStatisticsServiceImpl
extends RemoteServiceServlet
implements UserStatisticsService {
    private static final Log logger = LogFactoryUtil.getLog(UserStatisticsServiceImpl.class);
    private DatabookStore store;
    private static final String CUSTOM_FIELD_NAME_USER_STATISTICS_VISIBILITY = "show_user_statistics_other_people";
    private UserManager userManager = new LiferayUserManager();
    private GroupManager groupManager = new LiferayGroupManager();

    public void init() {
        logger.info((Object)"Getting connection to Cassandra..");
        this.store = new DBCassandraAstyanaxImpl();
        ServerUtils.createUserCustomField((String)CUSTOM_FIELD_NAME_USER_STATISTICS_VISIBILITY, (boolean)true);
    }

    public void destroy() {
        logger.info((Object)"Closing connection to Cassandra");
        this.store.closeConnection();
    }

    public String getTotalSpaceInUse(String userid) {
        String storageInUse = null;
        String userName = ServerUtils.getCurrentUser((HttpServletRequest)this.getThreadLocalRequest()).getUsername();
        ServerUtils.getCurrentContext((HttpServletRequest)this.getThreadLocalRequest(), (boolean)true);
        ServerUtils.getCurrentSecurityToken((HttpServletRequest)this.getThreadLocalRequest(), (boolean)true);
        if (userName == null) {
            logger.warn((Object)"Unable to determine the current user, returing null");
        }
        String statisticsOfUsername = userName;
        if (userid != null && !userid.equals(userName)) {
            statisticsOfUsername = userid;
        }
        logger.debug((Object)("Getting " + statisticsOfUsername + " amount of workspace in use."));
        try {
            UserInfrastructureSpaceCache cacheWorkspace = UserInfrastructureSpaceCache.getCacheInstance();
            Long storageInUseLong = cacheWorkspace.get(statisticsOfUsername);
            if (storageInUseLong == null) {
                Workspace workspace = HomeLibrary.getUserWorkspace((String)statisticsOfUsername);
                storageInUseLong = workspace.getDiskUsage();
                cacheWorkspace.insert(statisticsOfUsername, storageInUseLong);
            }
            storageInUse = ServerUtils.formatFileSize((long)storageInUseLong);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to retrieve workspace information!", (Throwable)e);
        }
        return storageInUse;
    }

    public int getProfileStrength(String userid) {
        int profileStrenght = -1;
        String userName = ServerUtils.getCurrentUser((HttpServletRequest)this.getThreadLocalRequest()).getUsername();
        if (userName == null) {
            logger.warn((Object)"Unable to determine the current user, returing null");
        }
        String statisticsOfUsername = userName;
        if (userid != null && !userid.equals(userName)) {
            statisticsOfUsername = userid;
        }
        if (ServerUtils.isWithinPortal()) {
            try {
                boolean avatarPresent = this.userManager.getUserAvatarBytes(statisticsOfUsername) != null;
                User user = UserLocalServiceUtil.getUserByScreenName((long)SiteManagerUtil.getCompany().getCompanyId(), (String)statisticsOfUsername);
                profileStrenght = ServerUtils.evaluateProfileStrenght((User)user, (boolean)avatarPresent);
            }
            catch (Exception e) {
                logger.error((Object)("Profile strenght evaluation failed!!" + e.toString()), (Throwable)e);
            }
        }
        return profileStrenght;
    }

    public UserInformation getUserSettings(String userid) {
        String userName = ServerUtils.getCurrentUser((HttpServletRequest)this.getThreadLocalRequest()).getUsername();
        if (userName == null) {
            logger.warn((Object)"Unable to determine the current user, returing null");
            return null;
        }
        String statisticsOfUsername = userName;
        boolean isOwner = false;
        boolean isProfileShowable = true;
        if (userid == null || userid != null && userid.equals(userName)) {
            isOwner = true;
            isProfileShowable = this.checkUserPrivacyOption(userName);
        }
        if (userid != null && !userid.equals(userName)) {
            statisticsOfUsername = userid;
            isProfileShowable = this.checkUserPrivacyOption(statisticsOfUsername);
            logger.info((Object)("Is profile showable for user " + userid + " " + isProfileShowable));
        }
        if (ServerUtils.isWithinPortal()) {
            boolean isInfrastructure = ServerUtils.isInfrastructureScope((String)userid, (HttpServletRequest)this.getThreadLocalRequest());
            logger.debug((Object)("User scope is " + (isInfrastructure ? " the whole infrastucture " : " a VRE")));
            String thumbnailURL = null;
            try {
                thumbnailURL = this.userManager.getUserByUsername(statisticsOfUsername).getUserAvatarURL();
            }
            catch (Exception e) {
                logger.error((Object)("Unable to retrieve avatar url for user " + statisticsOfUsername + ". Likely he/she doesn't have an avatar"));
            }
            String actualVre = null;
            if (!isInfrastructure) {
                String[] temp = ServerUtils.getCurrentContext((HttpServletRequest)this.getThreadLocalRequest(), (boolean)true).split("/");
                actualVre = temp[temp.length - 1];
            }
            String pageLanding = PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest());
            UserInformation bean = new UserInformation(isInfrastructure, thumbnailURL, userName, actualVre, isOwner, isProfileShowable);
            bean.setCurrentPageLanding(pageLanding);
            return bean;
        }
        return new UserInformation(true, null, userName, ServerUtils.getCurrentContext((HttpServletRequest)this.getThreadLocalRequest(), (boolean)false), true, true);
    }

    private boolean checkUserPrivacyOption(String username) {
        if (ServerUtils.isWithinPortal()) {
            try {
                ServerUtils.setPermissionChecker();
                CacheRegistryUtil.clear();
                User user = UserLocalServiceUtil.getUserByScreenName((long)ManagementUtils.getCompany().getCompanyId(), (String)username);
                if (!user.getExpandoBridge().hasAttribute(CUSTOM_FIELD_NAME_USER_STATISTICS_VISIBILITY)) {
                    return true;
                }
                return (Boolean)user.getExpandoBridge().getAttribute(CUSTOM_FIELD_NAME_USER_STATISTICS_VISIBILITY);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to retrieve user's privacy option for his statistics");
                return true;
            }
        }
        return false;
    }

    public PostsStatsBean getPostsStats(String userid) {
        String userName = ServerUtils.getCurrentUser((HttpServletRequest)this.getThreadLocalRequest()).getUsername();
        if (userName == null) {
            logger.warn((Object)"Unable to determine the current user, returing null");
        }
        String scope = ServerUtils.getCurrentContext((HttpServletRequest)this.getThreadLocalRequest(), (boolean)true);
        PostsStatsBean toReturn = null;
        String statisticsOfUsername = userName;
        if (userid != null && !userid.equals(userName)) {
            statisticsOfUsername = userid;
        }
        boolean isInfrastructure = ServerUtils.isInfrastructureScope((String)userid, (HttpServletRequest)this.getThreadLocalRequest());
        Calendar oneYearAgo = Calendar.getInstance();
        oneYearAgo.set(1, oneYearAgo.get(1) - 1);
        logger.debug((Object)("Reference time is " + oneYearAgo.getTime()));
        try {
            long userId = this.userManager.getUserId(statisticsOfUsername);
            List userFeeds = this.store.getRecentFeedsByUserAndDate(statisticsOfUsername, oneYearAgo.getTimeInMillis());
            List recentLikedFeeds = this.store.getRecentLikedFeedsByUserAndDate(statisticsOfUsername, oneYearAgo.getTimeInMillis());
            List recentComments = this.store.getRecentCommentsByUserAndDate(statisticsOfUsername, oneYearAgo.getTimeInMillis());
            ArrayList<String> contexts = new ArrayList<String>();
            if (isInfrastructure) {
                Set vresInPortal = this.groupManager.listGroupsByUserAndSite(userId, this.getThreadLocalRequest().getServerName());
                for (GCubeGroup gCubeGroup : vresInPortal) {
                    contexts.add(this.groupManager.getInfrastructureScope(gCubeGroup.getGroupId()));
                }
            } else {
                contexts.add(scope);
            }
            logger.info((Object)("Context(s) that are going to be used " + contexts));
            long feedsMade = 0L;
            long likesGot = 0L;
            long commentsGot = 0L;
            long commentsMade = 0L;
            long likesMade = 0L;
            for (Feed feed : userFeeds) {
                if (!contexts.contains(feed.getVreid())) continue;
                ++feedsMade;
                commentsGot += (long)Integer.parseInt(feed.getCommentsNo());
                likesGot += (long)Integer.parseInt(feed.getLikesNo());
            }
            for (Feed feed : recentLikedFeeds) {
                if (!contexts.contains(feed.getVreid())) continue;
                ++likesMade;
            }
            HashMap<String, Feed> parentFeeds = new HashMap<String, Feed>();
            for (Comment comment : recentComments) {
                Feed parentFeed = null;
                if (!parentFeeds.containsKey(comment.getFeedid())) {
                    parentFeed = this.store.readFeed(comment.getFeedid());
                    parentFeeds.put(comment.getFeedid(), parentFeed);
                } else {
                    parentFeed = (Feed)parentFeeds.get(comment.getFeedid());
                }
                if (!contexts.contains(parentFeed.getVreid())) continue;
                ++commentsMade;
            }
            toReturn = new PostsStatsBean(feedsMade, likesGot, commentsGot, commentsMade, likesMade);
        }
        catch (Exception e) {
            logger.error((Object)"Error while retrieving user's statistics", (Throwable)e);
        }
        return toReturn;
    }

    public void setShowMyOwnStatisticsToOtherPeople(boolean show) {
        if (ServerUtils.isWithinPortal()) {
            String username = ServerUtils.getCurrentUser((HttpServletRequest)this.getThreadLocalRequest()).getUsername();
            if (username == null) {
                logger.warn((Object)"Unable to determine the current user, returing null");
            }
            try {
                ServerUtils.setPermissionChecker();
                CacheRegistryUtil.clear();
                User user = UserLocalServiceUtil.getUserByScreenName((long)ManagementUtils.getCompany().getCompanyId(), (String)username);
                boolean hasAttribute = user.getExpandoBridge().hasAttribute(CUSTOM_FIELD_NAME_USER_STATISTICS_VISIBILITY);
                if (hasAttribute) {
                    logger.debug((Object)("Setting custom field value to " + show + " for user " + username));
                    user.getExpandoBridge().setAttribute(CUSTOM_FIELD_NAME_USER_STATISTICS_VISIBILITY, (Serializable)Boolean.valueOf(show));
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to check user's privacy for his statistics", (Throwable)e);
            }
        }
    }
}

