/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.vreappintegration.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"javax.portlet.name=org_gcube_portlets_user_vreappintegration_VREAppIntegrationPortlet"}, service={ConfigurationAction.class})
public class VREAppConfigurationAction
extends DefaultConfigurationAction {
    private static final Log _log = LogFactoryUtil.getLog(VREAppConfigurationAction.class);

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            super.processAction(portletConfig, actionRequest, actionResponse);
            PortletPreferences preferences = actionRequest.getPreferences();
            String appURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"preferences--appURL--", (String)"");
            String appURLTokenParam = ParamUtil.getString((PortletRequest)actionRequest, (String)"preferences--appURLTokenParam--", (String)"");
            String iFrameHeight = ParamUtil.getString((PortletRequest)actionRequest, (String)"preferences--iFrameHeightParam--", (String)"1000");
            String applicationName = ParamUtil.getString((PortletRequest)actionRequest, (String)"preferences--applicationNameParam--", (String)"the Application");
            boolean newAuthVersion = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"preferences--newAuthVersionPreference--", (boolean)false);
            boolean newWindow = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"preferences--newWindowPreference--", (boolean)false);
            if (appURL != null && !appURL.trim().isEmpty()) {
                preferences.setValue("appURL", appURL.trim());
                _log.debug((Object)("Set appURL preference: " + appURL));
            }
            if (appURLTokenParam != null && !appURLTokenParam.trim().isEmpty()) {
                preferences.setValue("appURLTokenParam", appURLTokenParam.trim());
                _log.debug((Object)("Set appURLTokenParam preference: " + appURLTokenParam));
            }
            try {
                int height = Integer.parseInt(iFrameHeight);
                if (height > 0 && height <= 5000) {
                    preferences.setValue("iFrameHeightParam", String.valueOf(height));
                    _log.debug((Object)("Set iFrameHeight preference: " + height));
                } else {
                    _log.warn((Object)("Invalid iframe height: " + height + ". Using default: 1000"));
                    preferences.setValue("iFrameHeightParam", "1000");
                }
            }
            catch (NumberFormatException e) {
                _log.warn((Object)("Invalid iframe height format: " + iFrameHeight + ". Using default: 1000"));
                preferences.setValue("iFrameHeightParam", "1000");
            }
            if (applicationName != null && !applicationName.trim().isEmpty()) {
                preferences.setValue("applicationNameParam", applicationName.trim());
                _log.debug((Object)("Set applicationName preference: " + applicationName));
            }
            preferences.setValue("newAuthVersionPreference", String.valueOf(newAuthVersion));
            preferences.setValue("newWindowPreference", String.valueOf(newWindow));
            _log.debug((Object)("Set newAuthVersion preference: " + newAuthVersion));
            _log.debug((Object)("Set newWindow preference: " + newWindow));
            preferences.store();
            _log.info((Object)"VRE App Integration portlet configuration updated successfully");
        }
        catch (Exception e) {
            _log.error((Object)"Error processing VRE App Integration portlet configuration", (Throwable)e);
            throw e;
        }
    }
}

