package org.gcube.portlets.user.warmanagementwidget.client.rpc;

import org.gcube.portlets.user.warmanagementwidget.client.data.WarProfile;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgress;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("WarManagementService")
public interface WarManagementService extends RemoteService {
	
	/**
	 * Utility class for simplifying access to the instance of async service.
	 */
	public static class Util {
		
		private static WarManagementServiceAsync instance;
		
		public static WarManagementServiceAsync getInstance(){
			if (instance == null) {
				instance = GWT.create(WarManagementService.class);
			}
			return instance;
		}
	}
	
	/**
	 * Create a new session import id.
	 * @return the session id.
	 */
	public String createWarSessionId();
	
	
	/**
	 * Returns the current file upload state, used by local upload.
	 * @param sessionId the CSV session id.
	 * @return the upload state.
	 * @throws WarImportException 
	 */
	public OperationProgress getLocalUploadStatus(String sessionId) throws WarImportException;
	
	/**
	 * Returns the war file name for the current session.
	 * @param sessionId the import session id.
	 * @return the war file name.
	 * @throws WarImportException
	 */
	public String getWarFileName(String sessionId) throws WarImportException;
	
	
	/**
	 * Returns the war profile with the specified id.
	 * @param warId
	 * @return
	 */
	public WarProfile getWarProfile(String warId) throws WarImportException;
	
	/**
	 * Stores the war on the software repository.
	 * @param sessionId the import session id.
	 * @param profile the war profile.
	 * @param baseUrl the application base url
	 */
	public void uploadWar(String sessionId, WarProfile profile, String baseUrl) throws WarImportException;
	
	
	/**
	 * Returns the war store progress.
	 * @param sessionId the import session id.
	 * @return the progress.
	 * @throws WarImportException
	 */
	public OperationProgress getWarUploadProgress(String sessionId) throws WarImportException;
	
	public String deleteWar(String warId) throws WarImportException;
	
	public OperationProgress getOperationProgress(String operationId) throws WarImportException;

}
