package org.gcube.portlets.widgets.ckan2zenodopublisher.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.gcube.portlets.widgets.ckan2zenodopublisher.client.ui.BasicTabPanel;
import org.gcube.portlets.widgets.ckan2zenodopublisher.client.view.Ckan2ZenodoViewManager;
import org.gcube.portlets.widgets.ckan2zenodopublisher.client.view.FormValidator;
import org.gcube.portlets.widgets.ckan2zenodopublisher.client.view.LoaderIcon;
import org.gcube.portlets.widgets.ckan2zenodopublisher.shared.CatalogueItem;
import org.gcube.portlets.widgets.ckan2zenodopublisher.shared.wrapped.ZenodoItem;

import com.github.gwtbootstrap.client.ui.Alert;
import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Hero;
import com.github.gwtbootstrap.client.ui.Modal;
import com.github.gwtbootstrap.client.ui.ModalFooter;
import com.github.gwtbootstrap.client.ui.Paragraph;
import com.github.gwtbootstrap.client.ui.constants.AlertType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * The Class CkanToZendoPublisherWidget.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
 * 
 *         Dec 9, 2019
 */
public class CkanToZendoPublisherWidget {

	private CkanToZenodoPublisherServiceAsync ckanToZenodoService;

	private Button buttonPublish = new Button("Upload to Zenodo");
	private Ckan2ZenodoViewManager manager = null;
	private BasicTabPanel basicTabPanel;
	private ModalFooter modalFooter;
	public static Map<String, String> mapOfFieldsDescriptions = new HashMap<String, String>();


	public CkanToZendoPublisherWidget() {
		ckanToZenodoService = CkanToZenodoPublisherServiceAsync.Util.getInstance();
	}


	public void publishOnZenodo(final CatalogueItem item) {
		
		final Modal modal = new Modal(true);
		modal.setTitle("Upload to Zenodo...");
		modal.addStyleName("ckan2zenodo-modal-style");
		modal.setCloseVisible(true);
		buttonPublish.setEnabled(false);
		
		Hero hero = new Hero();
		hero.addStyleName("hero-unit-custom");
		hero.add(new Paragraph("By using this process you are transferring selected catalogue item content to the Zenodo Repository (link). "
				+ "This will create a new item in Zenodo and a link of the Zenodo item will be added to the catalogue item."));
		
		modal.add(hero);
		final LoaderIcon loader = new LoaderIcon("Loading data from service...");
		modal.add(loader);
		ckanToZenodoService.convertToZenodoItem(item, new AsyncCallback<ZenodoItem>() {

			@Override
			public void onFailure(Throwable caught) {
				loader.setVisible(false);
				modal.remove(loader);
				Alert erroLabel = new Alert();
				erroLabel.setClose(false);
				erroLabel.setType(AlertType.ERROR);
				erroLabel.setText(caught.getLocalizedMessage());
				modal.add(erroLabel);
				Button close = new Button("Close");
				close.addClickHandler(new ClickHandler() {
					
					@Override
					public void onClick(ClickEvent event) {
						modal.hide();
					}
				});
				modal.add(close);
				//Window.alert(caught.getMessage());
			}

			@Override
			public void onSuccess(ZenodoItem result) {
				loader.setVisible(false);
				modal.remove(loader);
				manager = new Ckan2ZenodoViewManager();
				basicTabPanel = manager.viewForPublishing(result);
				modal.add(basicTabPanel);
				buttonPublish.setEnabled(true);
			}
		});
		
		ckanToZenodoService.readFieldsDescriptions(new AsyncCallback<Map<String,String>>() {



			@Override
			public void onFailure(Throwable caught) {
			}

			@Override
			public void onSuccess(Map<String, String> result) {
				mapOfFieldsDescriptions = result;
			}
		});
		
		buttonPublish.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				if(manager==null)
					Window.alert("Sorry, the upload to zenodo is not available at this point");
				
				boolean allFormsAreValid = true;
				List<FormValidator> forms = manager.getListForms();
				for (FormValidator formValidator : forms) {
					boolean isValid = formValidator.isValidForm();
					if(!isValid)
						allFormsAreValid = false;
				}
				
				if(allFormsAreValid) {
					buttonPublish.setEnabled(false);
					basicTabPanel.getElement().getStyle().setOpacity(0.5);
					final LoaderIcon loaderPublishing = new LoaderIcon("Trying to upload on Zenodo, please wait...");
					modalFooter.add(loaderPublishing);
					//Submit publish on zenodo.
					ZenodoItem zenodoItem = manager.getZenodoItemFromFieldsForm();
					GWT.log("Publishing file:  "+zenodoItem.getFiles());
					ckanToZenodoService.publishOnZenodo(zenodoItem, new AsyncCallback<String>() {

						@Override
						public void onFailure(Throwable caught) {
							buttonPublish.setEnabled(true);
							basicTabPanel.getElement().getStyle().setOpacity(1.0);
							modalFooter.remove(loaderPublishing);
							//modal.clear();
							Alert erroLabel = new Alert();
							erroLabel.setClose(false);
							erroLabel.setType(AlertType.ERROR);
							erroLabel.setText(caught.getLocalizedMessage());
							modal.add(erroLabel);
							Button close = new Button("Close");
							close.addClickHandler(new ClickHandler() {
								
								@Override
								public void onClick(ClickEvent event) {
									modal.hide();
								}
							});
							modal.add(close);
						}

						@Override
						public void onSuccess(String result) {
							buttonPublish.setEnabled(true);
							basicTabPanel.getElement().getStyle().setOpacity(1.0);
							modalFooter.remove(loaderPublishing);
							String msg = "Publishing: \n\n"+result+"\n\nIs it right?";
							Window.alert(msg);
						}
					});
				}
			}
		});
		
		modalFooter = new ModalFooter(buttonPublish);
		modal.add(modalFooter);
		modal.show();
	}
	
}
