package org.gcube.portlets.widgets.fileupload.client.view;

import org.gcube.portlets.widgets.fileupload.client.state.UploadProgressState;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;

public final class UploadProgressPanel extends Composite {

	private HandlerManager eventBus;


	private FileSubmit fileSubmit;
	private UploadProgress uploadProgress;
	
	private VerticalPanel mainPanel = new VerticalPanel();
	
	/**
	 * as a Panel
	 * @param eventBus
	 */
	public UploadProgressPanel(HandlerManager eventBus) {
		this.eventBus = eventBus; 
		mainPanel.setStyleName("progressContainer");
		initWidget(mainPanel);
	}
	
	public void initialize() {	
		mainPanel.clear();
		mainPanel.add(new FileSubmit(eventBus));
		mainPanel.add(new UploadProgress());
	}

	public void showRegisteringResult(boolean result) {
		fileSubmit.showRegisteringResult(result);
	}
}
