package org.gcube.datacatalogue.grsf_manage_widget.client;

import org.gcube.datacatalogue.grsf_manage_widget.shared.ManageProductBean;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;


@RemoteServiceRelativePath("grsfmanageservice")
public interface GRSFManageWidgetService extends RemoteService {

	/**
	 * check if the user has the rights to manage the item
	 */
	boolean isAdminUser();

	/**
	 * Get the product bean from the product identifier
	 * @param identifier
	 * @return ManageProductBean
	 * @throws Exception 
	 */
	ManageProductBean getProductBeanById(String identifier) throws Exception;

	/**
	 * Notify product update
	 */
	String notifyProductUpdate(ManageProductBean bean) throws Exception;

	/**
	 * Check that a record with such semantic identifier exists
	 * @param semanticIdentifier
	 * @return true or false
	 */
	boolean checkSemanticIdentifierExists(String semanticIdentifier) throws Exception;

	/**
	 * Check that a record with such semantic identifier exists in a given domain
	 * @param semanticIdentifier
	 * @param domain
	 * @return
	 * @throws Exception
	 */
	boolean checkSemanticIdentifierExistsInDomain(String semanticIdentifier, String domain) throws Exception;


	/**
	 * Identifier of the record (UUID)
	 * @param id
	 * @return
	 * @throws Exception
	 */
	boolean checkIdentifierExists(String id) throws Exception;

	/**
	 * Identifier of the record (UUID)
	 * @param id
	 * @param domain (stock or fishery)
	 * @return
	 * @throws Exception
	 */
	boolean checkIdentifierExistsInDomain(String id, String domain) throws Exception;

}
