package org.gcube.datacatalogue.grsf_manage_widget.client.view.subwidgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.gcube.datacatalogue.grsf_manage_widget.shared.SimilarGRSFRecord;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.CheckBox;
import com.github.gwtbootstrap.client.ui.Paragraph;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style.Float;
import com.google.gwt.dom.client.Style.FontWeight;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class SimilarGRSFRecordWidget extends Composite {

	private static SimilarGRSFRecordWidgetUiBinder uiBinder = GWT
			.create(SimilarGRSFRecordWidgetUiBinder.class);

	interface SimilarGRSFRecordWidgetUiBinder extends
	UiBinder<Widget, SimilarGRSFRecordWidget> {
	}

	@UiField
	VerticalPanel similarGrsfRecordsPanel;

	@UiField
	VerticalPanel similarGrsfRecordsSuggestedPanel;

	@UiField
	Button addSimilarRecord;

	private List<Tuple> extraSimilarRecordsList = new ArrayList<Tuple>(0);
	private List<SimilarGRSFRecord> availableGRSFSimilarRecords;
	//private GRSFManageWidgetServiceAsync service;

	/**
	 * Get widget for available similar grsf records
	 * @param availableGRSFSimilarRecords
	 * @param service 
	 */
	public SimilarGRSFRecordWidget(List<SimilarGRSFRecord> availableGRSFSimilarRecords/*, GRSFManageWidgetServiceAsync service*/) {
		initWidget(uiBinder.createAndBindUi(this));

		//this.service = service;
		this.availableGRSFSimilarRecords = availableGRSFSimilarRecords;

		if(availableGRSFSimilarRecords != null){

			similarGrsfRecordsPanel.add(new HTML("<hr style=\"width:100%;\"/>"));
			
			// add the existing ones, if any
			for (final SimilarGRSFRecord similarGRSFRecord : availableGRSFSimilarRecords) {
				Widget widget = buildWidgetForSimilarRecord(similarGRSFRecord);
				similarGrsfRecordsPanel.add(widget);
				similarGrsfRecordsPanel.add(new HTML("<hr style=\"width:100%;\"/>"));
			}

		}
		// manage the "suggest button"
		addSimilarRecord.setIcon(IconType.PLUS_SIGN);
		addSimilarRecord.getElement().getStyle().setFloat(Float.RIGHT);
		addSimilarRecord.setTitle("Suggest a Similar Record by using its Identifier (UUID)");
		addSimilarRecord.getElement().getStyle().setFloat(Float.RIGHT);

		// add handler
		addSimilarRecord.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent arg0) {

				SimilarGRSFRecord s = new SimilarGRSFRecord();
				s.setExtra(true);
				Widget w = buildWidgetForExtraSimilarRecord(s);
				extraSimilarRecordsList.add(new Tuple(s, w, null));
				similarGrsfRecordsSuggestedPanel.add(w);

			}
		});

	}

	/**
	 * Builds widget for already present similar GRSF records
	 * @param similarGRSFRecord
	 * @return a Widget (actually a VerticalPanel)
	 */
	public static Widget buildWidgetForSimilarRecord(final SimilarGRSFRecord similarGRSFRecord){

		HorizontalPanel hp = new HorizontalPanel();
		hp.setWidth("95%");
		VerticalPanel leftPanel = new VerticalPanel();
		leftPanel.setWidth("80%");
		leftPanel.getElement().getStyle().setMarginLeft(20, Unit.PX);
		Paragraph name = new Paragraph("Record name: " + (similarGRSFRecord.getShortName() != null? similarGRSFRecord.getShortName() : "Unavailable"));
		leftPanel.add(name);
		if(similarGRSFRecord.getDescription() != null){
			String shortDescrption = similarGRSFRecord.getDescription().length() > 45 ?
					similarGRSFRecord.getDescription().substring(0, 45) + " ... " :
						similarGRSFRecord.getDescription();
			Paragraph description = new Paragraph(
					"Description: " + shortDescrption);
			description.setTitle("Description: " + similarGRSFRecord.getDescription());
			leftPanel.add(description);
		}
		Paragraph identifier = new Paragraph("Record UUID: " + 
				similarGRSFRecord.getKnowledgeBaseId());
		leftPanel.add(identifier);

		Anchor view = new Anchor();
		view.setHref(similarGRSFRecord.getUrl());
		view.setText("View"); 
		view.setTitle("Click to view the similar record");
		view.setTarget("_blank");
		view.getElement().getStyle().setFontWeight(FontWeight.BOLD);
		leftPanel.add(view);

		VerticalPanel rightPanel = new VerticalPanel();
		rightPanel.setWidth("20%");

		// add merge checkbox
		final CheckBox mergeSuggested = new CheckBox("Merge");
		mergeSuggested.setTitle("Suggest to merge the current record with this similar record");
		//mergeSuggested.getElement().getStyle().setPaddingTop(3, Unit.PC);
		mergeSuggested.setValue(false);

		mergeSuggested.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent arg0) {

				similarGRSFRecord.setSuggestedMerge(mergeSuggested.getValue());

			}
		});

		final CheckBox removeExtra = new CheckBox("Remove");
		removeExtra.getElement().getStyle().setPaddingTop(3, Unit.PC);
		removeExtra.setTitle("Remove this record among the similar ones");
		removeExtra.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent arg0) {
				similarGRSFRecord.setToBeKept(!removeExtra.getValue());
			}
		});

		rightPanel.getElement().getStyle().setFloat(Float.RIGHT);
		rightPanel.add(mergeSuggested);
		rightPanel.add(removeExtra);
		hp.add(leftPanel);
		hp.add(rightPanel);
		hp.getElement().getStyle().setPadding(10, Unit.PX);
		hp.getElement().getStyle().setMarginBottom(10, Unit.PX);
		return hp;
	}

	/**
	 * Builds up a widget for suggested similar grsf records. Changes are performed in place with respect to w and s.
	 * @author Costantino Perciante at ISTI-CNR (costantino.perciante@isti.cnr.it)
	 * @param w the widget
	 * @param s the similar record.
	 */
	private Widget buildWidgetForExtraSimilarRecord(final SimilarGRSFRecord s){

		VerticalPanel main = new VerticalPanel();
		main.setWidth("95%");
		HorizontalPanel hp = new HorizontalPanel();
		hp.setWidth("100%");

		VerticalPanel vpLeft = new VerticalPanel();
		vpLeft.getElement().getStyle().setMarginLeft(15, Unit.PX);
		vpLeft.setWidth("80%");
		Paragraph identifier = new Paragraph("Identifier (UUID):");
		final TextBox box = new TextBox();
		box.addKeyPressHandler(new KeyPressHandler() {

			@Override
			public void onKeyPress(KeyPressEvent event) {

				String currentText = box.getText().trim();
				GWT.log("Text changed to " + currentText);
				s.setKnowledgeBaseId(currentText);

			}
		});
		box.addChangeHandler(new ChangeHandler() {

			@Override
			public void onChange(ChangeEvent event) {

				String currentText = box.getText().trim();
				GWT.log("Text changed to " + currentText);
				s.setKnowledgeBaseId(currentText);

			}
		});
		box.setWidth("511px");
		box.setPlaceholder("Insert the Identifier (UUID) of the suggested record");

		vpLeft.add(identifier);
		vpLeft.add(box);

		// add merge checkbox
		final CheckBox mergeSuggested = new CheckBox("Merge");
		mergeSuggested.setTitle("Suggest to merge the current record with this similar record");
		mergeSuggested.getElement().getStyle().setPaddingTop(3, Unit.PC);
		mergeSuggested.setValue(false);

		VerticalPanel vpRight = new VerticalPanel();
		vpRight.setWidth("20%");
		mergeSuggested.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent arg0) {
				s.setSuggestedMerge(mergeSuggested.getValue());
			}
		});

		vpRight.add(mergeSuggested);

		Button removeExtra = new Button();
		removeExtra.setIcon(IconType.MINUS);
		removeExtra.setTitle("Remove this suggested record");
		removeExtra.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent arg0) {

				// remove this object from the pairs list
				Iterator<Tuple> iterator = extraSimilarRecordsList.iterator();
				while (iterator.hasNext()) {
					Tuple pair = (Tuple) iterator
							.next();
					if(pair.getO().equals(s)){
						pair.getW().removeFromParent();
						iterator.remove();
					}
				}
			}
		});
		vpRight.getElement().getStyle().setFloat(Float.RIGHT);
		vpRight.add(removeExtra);
		vpRight.add(mergeSuggested);
		hp.add(vpLeft);
		hp.add(vpRight);
		HTML separator = new HTML("<hr style=\"width:100%;\"/>");
		similarGrsfRecordsSuggestedPanel.add(separator);
		main.add(hp);
		main.add(separator);
		return main;
	}

	/**
	 * Get the whole of similar records
	 * @return
	 */
	public List<SimilarGRSFRecord> getSimilarRecords(){

		if(availableGRSFSimilarRecords == null)
			availableGRSFSimilarRecords = new ArrayList<SimilarGRSFRecord>();

		for (Tuple p : extraSimilarRecordsList) {
			SimilarGRSFRecord similarRecord = ((SimilarGRSFRecord)p.getO());
			if(similarRecord.isExtra() && similarRecord.getKnowledgeBaseId() == null ||  similarRecord.getKnowledgeBaseId().isEmpty())
				continue;
			availableGRSFSimilarRecords.add((SimilarGRSFRecord) p.getO());
		}

		return availableGRSFSimilarRecords;

	}
}
