package org.gcube.portlets.widgets.pickuser.client;

import java.util.ArrayList;

import org.gcube.portlets.widgets.pickuser.client.dialog.PickUsersDialog;
import org.gcube.portlets.widgets.pickuser.client.events.PickedUserEvent;
import org.gcube.portlets.widgets.pickuser.shared.PickingUser;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;

/**
 * 
 * @author Massimiliano Assante, ISTI-CNR
 * Use this widget to display a  a dropdown user list you can attach to a textbox to make select portal users typing @
 * uncomment //sample in the onModuleLoad() to see it working
 * 
 * To get to know which user was selected listen for the {@link PickedUserEvent} on the {@link HandlerManager} instance you pass to this widget.
 *
 */
public class PickUser implements EntryPoint {
	/**
	 * This is the entry point method.
	 */
	public void onModuleLoad() {
		//sample();
	}
	
	private void sample() {
		HandlerManager eventbus = new HandlerManager(null);
		ArrayList<PickingUser> users = new ArrayList<PickingUser>();
		users.add(new PickingUser("id", "test.user1", "Test Foo", "phot URL"));
		users.add(new PickingUser("id", "test.user2", "Test Fie", "phot URL"));
		users.add(new PickingUser("id", "test.user3", "Abba Foo", "phot URL"));
		users.add(new PickingUser("id", "test.user4", "ABabba Fie", "phot URL"));
		users.add(new PickingUser("id", "test.user5", "ACaro Foo", "phot URL"));
		users.add(new PickingUser("id", "test.user6", "Dario Fie", "phot URL"));
		users.add(new PickingUser("id", "test.user7", "Ergo Fie", "phot URL"));
	
		final TextBox tb = new TextBox();
		final int popUpY = tb.getAbsoluteTop()+30;
	
		final PickUsersDialog pickUserDlg = new PickUsersDialog(users, eventbus, 300);
		tb.addKeyUpHandler(new KeyUpHandler() {
			@Override
			public void onKeyUp(KeyUpEvent event) {
				pickUserDlg.onKeyUp(event.getNativeKeyCode(), tb.getAbsoluteLeft(), popUpY, tb.getText());			
			}
		});
		
		RootPanel.get().add(tb);
	}
}
