package org.gcube.portlets.widgets.sessionchecker.server;

import java.util.Date;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.widgets.sessionchecker.client.SessionCheckerService;
import org.gcube.portlets.widgets.sessionchecker.shared.SessionInfoBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.service.UserLocalServiceUtil;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class SessionCheckerServiceImpl extends RemoteServiceServlet implements  SessionCheckerService {

	private static final Logger _log = LoggerFactory.getLogger(SessionCheckerServiceImpl.class);


	/**
	 * the current ASLSession
	 * @return .
	 */
	private ASLSession getASLSession() {	
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		SessionManager manager = SessionManager.getInstance();
		ASLSession toReturn = manager.getASLSession(sessionID, user);
		return toReturn;		
	}

	@Override
	public SessionInfoBean checkSession() {
		ASLSession session = getASLSession();
		if (session == null) {
			try { 
				UserLocalServiceUtil.getService();
			}
			catch (Exception e) {
				_log.warn("Stopping session polling as you are in dev mode (am I wrong?)");
				return new SessionInfoBean("","", true); //tells that you are in development mode 
			}	
			_log.warn("Liferay Portal Detected but session Expired");
			return new SessionInfoBean("",""); //tells session expired
		}

		String user = session.getUsername();
		String scope = session.getScope();
		//else
		_log.trace("Session check OK for " + user + " at " + new Date());
		if (user == null || user.compareTo("") == 0) {
			_log.warn("User is null at " + new Date());			
		}
		if (scope == null || scope.compareTo("") == 0) {
			_log.warn("Scope is null at " + new Date());
		}
		return new SessionInfoBean(session.getUsername(), session.getScope());
	}

	}
