package org.gcube.portlets.widgtes.wsthreddssync.client.view.binder;


import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.gcube.portlets.widgtes.wsthreddssync.client.WsThreddsWidget;
import org.gcube.portlets.widgtes.wsthreddssync.shared.GcubeVRE;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.Pager;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;


// TODO: Auto-generated Javadoc
/**
 * The Class CreateThreddsConfigurationView.
 *
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * Feb 15, 2018
 */
public abstract class CreateThreddsConfigurationView extends Composite {

	/** The ui binder. */
	private static CreateThreddsConfigurationViewUiBinder uiBinder =
		GWT.create(CreateThreddsConfigurationViewUiBinder.class);


	/**
	 * The Interface CreateFolderConfigurationToThreddsSyncUiBinder.
	 *
	 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
	 * Feb 14, 2018
	 */
	interface CreateThreddsConfigurationViewUiBinder
		extends UiBinder<Widget, CreateThreddsConfigurationView> {
	}

	/** The pager. */
	@UiField
	Pager pager;
	
	
	/** The field course desciption. */
	@UiField
	ListBox field_select_vre;
	

	/** The field catalogue name. */
	@UiField
	TextBox field_catalogue_name;
	
	/** The field folder name. */
	@UiField
	TextBox field_remote_path;
	

	/** The cg catalogue name. */
	@UiField
	ControlGroup cg_catalogue_name;

	/** The cg folder name. */
	@UiField
	ControlGroup cg_remote_path;


	/** The folder id. */
	private String folderId;
	
	/** The map VR es. */
	private Map<String, GcubeVRE> mapVREs = new HashMap<String, GcubeVRE>();
	
	
	/**
	 * Submit handler.
	 */
	public abstract void submitHandler();
	
	/**
	 * Sets the error.
	 *
	 * @param visible the visible
	 * @param error the error
	 */
	public abstract void setError(boolean visible, String error);
	

	/**
	 * Because this class has a default constructor, it can
	 * be used as a binder template. In other words, it can be used in other
	 * *.ui.xml files as follows:
	 * <ui:UiBinder xmlns:ui="urn:ui:com.google.gwt.uibinder"
	 *   xmlns:g="urn:import:**user's package**">
	 *  <g:**UserClassName**>Hello!</g:**UserClassName>
	 * </ui:UiBinder>
	 * Note that depending on the widget that is used, it may be necessary to
	 * implement HasHTML instead of HasText.
	 *
	 * @param folderId the folder id
	 */
	public CreateThreddsConfigurationView(String folderId) {
		this.folderId = folderId;

		initWidget(uiBinder.createAndBindUi(this));
		
		pager.getLeft().setVisible(false);
		
		pager.getRight().addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				setError(false, "");
				boolean isValid = validateSubmit();
				if(isValid)
					submitHandler();
				
			}
		});
		
		WsThreddsWidget.wsThreddsSyncService.getListOfVREsForLoggedUser(new AsyncCallback<List<GcubeVRE>>() {
			
			@Override
			public void onSuccess(List<GcubeVRE> result) {
				
				
				for (GcubeVRE gcubeVRE : result) {
					mapVREs.put(gcubeVRE.getVreScope(), gcubeVRE);
					field_select_vre.addItem(gcubeVRE.getVreScope(), gcubeVRE.getVreName());
					
				}
			}
			
			@Override
			public void onFailure(Throwable caught) {
				// TODO Auto-generated method stub
				
			}
		});

	}
	
	
	/**
	 * Validate submit.
	 *
	 * @return true, if successful
	 */
	protected boolean validateSubmit() {
		cg_catalogue_name.setType(ControlGroupType.NONE);
		cg_remote_path.setType(ControlGroupType.NONE);
		
		if(field_catalogue_name.getValue()==null || field_catalogue_name.getValue().isEmpty()){
			cg_catalogue_name.setType(ControlGroupType.ERROR);
			setError(true, "Catalogue Name is required");
			return false;
		}
		
		if(field_remote_path.getValue()==null || field_remote_path.getValue().isEmpty()){
			cg_remote_path.setType(ControlGroupType.ERROR);
			setError(true, "Remote Path field is required");
			return false;
		}else if(field_remote_path.getValue().startsWith("/")){
			cg_remote_path.setType(ControlGroupType.ERROR);
			setError(true, "Remote Path must be a relative URL. It does not start with '/'");
			return false;
		}
	
		return true;
	}


	/**
	 * Gets the remote path.
	 *
	 * @return the remote path
	 */
	public String getRemotePath() {
		return field_remote_path.getValue();
	}
	
	/**
	 * Gets the catalogue name.
	 *
	 * @return the catalogue name
	 */
	public String getCatalogueName(){
		return field_catalogue_name.getValue();
	}
	
	
	/**
	 * Gets the unit description.
	 *
	 * @return the unit description
	 */
	public GcubeVRE getSelectedVRE(){
		String item = field_select_vre.getSelectedItemText();
		String text = field_select_vre.getSelectedValue();
		return mapVREs.get(item);
	}




}
