package org.gcube.portlets.widgtes.wsthreddssync.client.rpc;

import java.util.List;

import org.gcube.portal.wssynclibrary.shared.ItemNotSynched;
import org.gcube.portal.wssynclibrary.shared.thredds.ThSyncStatus;
import org.gcube.portlets.widgtes.wsthreddssync.shared.GcubeVRE;
import org.gcube.portlets.widgtes.wsthreddssync.shared.WsThreddsSynchFolderConfiguration;
import org.gcube.portlets.widgtes.wsthreddssync.shared.WsThreddsSynchFolderDescriptor;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * The client side stub for the RPC service.
 */
@RemoteServiceRelativePath("wsthreddssync")
public interface ThreddsWorkspaceSyncService extends RemoteService {

	WsThreddsSynchFolderDescriptor isItemSynched(String folderId) throws ItemNotSynched, Exception;

	ThSyncStatus doSyncFolder(final String folderId, WsThreddsSynchFolderConfiguration clientConfig) throws Exception;

	ThSyncStatus monitorSyncStatus(String folderId) throws ItemNotSynched, Exception;

	List<GcubeVRE> getListOfVREsForLoggedUser() throws Exception;
}
