package org.gcube.portlets.user.gisviewer.client;


import java.util.List;

import org.gcube.portlets.user.gisviewer.client.commons.beans.DataResult;
import org.gcube.portlets.user.gisviewer.client.commons.beans.GroupInfo;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerConfiguration;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItemsResult;
import org.gcube.portlets.user.gisviewer.client.commons.beans.SavedGroup;
import org.gcube.portlets.user.gisviewer.client.commons.beans.WfsTable;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * The async counterpart of <code>GreetingService</code>.
 */
public interface GisViewerServiceAsync {

	public void getDataResult(List<String> urls, AsyncCallback<List<DataResult>> callback);

	public void getGroupsInfo(String groupName, AsyncCallback<LayerItemsResult> callback);

	public void getLayersInfo(List<String> layersName, AsyncCallback<LayerItemsResult> callback);

	public void getLayersInfoByLayerItems(List<LayerItem> layerItems, AsyncCallback<LayerItemsResult> asyncCallback);

	public void getLayersInfoByLayerConfigurations(List<LayerConfiguration> layerConfigurations, AsyncCallback<LayerItemsResult> asyncCallback);

	void getTransectUrl(AsyncCallback<String> callback);

	public void getDataResult(List<LayerItem> layerItems, String bbox, AsyncCallback<List<WfsTable>> asyncCallback);

	//public void saveLayersGroup(GroupInfo groupInfo, String format, AsyncCallback<SavedGroup> callback);
}
