package org.gcube.resourcemanagement.model.reference.properties;

import java.util.Set;

import org.gcube.resourcemanagement.model.impl.properties.EnumStringPropertyImpl;
import org.gcube.resourcemanagement.model.reference.properties.utilities.PropertyValidator;
import org.gcube.resourcemanagement.model.reference.properties.utilities.ValidatedTypedProperty;
import org.gcube.resourcemanagement.model.reference.properties.utilities.Validation;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;


/**
 * A string property validated against a set of accepted values.
 * 
 * @author Manuele Simi (ISTI - CNR)
 *
 */
@JsonDeserialize(as=EnumStringPropertyImpl.class)
public interface EnumStringProperty extends GCubeProperty, ValidatedTypedProperty<Set<String>, String> {
	
	@Override
	default Validation validate() {
		return new SetStringValidator().validate(this);
	}

	/**
	 * Validator for {@link ValueSchema} properties.
	 * 
	 * @author Manuele Simi (ISTI CNR)
	 *
	 */
	class SetStringValidator implements PropertyValidator<EnumStringProperty> {

		@Override
		public Validation validate(EnumStringProperty property) {
			return property.getType().contains(property.getValue()) ? Validation.success("Accepted!")
					: Validation.fail(property.getValue() + " is not a valid value.");
		}
	}
}
