/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.relations.consistsof;

import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.HasMemoryImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.MemoryFacet;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#hasMemory
 */
@Abstract
@JsonDeserialize(as=HasMemoryImpl.class)
public interface HasMemory<Out extends Resource, In extends MemoryFacet> 
	extends ConsistsOf<Out, In> {

	public static final String NAME = "HasMemory"; // HasMemory.class.getSimpleName();
}
