/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.model.reference.properties;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Set;
import org.gcube.resourcemanagement.model.impl.properties.EnumStringPropertyImpl;
import org.gcube.resourcemanagement.model.reference.properties.GCubeProperty;
import org.gcube.resourcemanagement.model.reference.properties.utilities.PropertyValidator;
import org.gcube.resourcemanagement.model.reference.properties.utilities.ValidatedTypedProperty;
import org.gcube.resourcemanagement.model.reference.properties.utilities.Validation;

@JsonDeserialize(as=EnumStringPropertyImpl.class)
public interface EnumStringProperty
extends GCubeProperty,
ValidatedTypedProperty<Set<String>, String> {
    @Override
    default public Validation validate() {
        return new SetStringValidator().validate(this);
    }

    public static class SetStringValidator
    implements PropertyValidator<EnumStringProperty> {
        @Override
        public Validation validate(EnumStringProperty property) {
            return ((Set)property.getType()).contains(property.getValue()) ? Validation.success("Accepted!") : Validation.fail((String)property.getValue() + " is not a valid value.");
        }
    }
}

