/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.resourcemanagement.model.impl.entities.facets.JSONSchemaFacetImpl;

/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#XSD_Schema_Facet
 */
@JsonDeserialize(as=JSONSchemaFacetImpl.class)
public interface JSONSchemaFacet extends SchemaFacet {
	
	public static final String NAME = "JSONSchemaFacet"; // JSONSchemaFacet.class.getSimpleName();
	public static final String DESCRIPTION = "Provide a way to store a JSON Schema";
	public static final String VERSION = "1.0.0";
	
	@ISProperty(mandatory=true, nullable=false)
	public Property getContent();
	
	public void setContent(Property content);
	
}
