package org.gcube.resourcemanagement.model.reference.relations.consistsof;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.HasRemoveActionImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.ActionFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.Service;

/**
 * An action triggered when a {@link Service} is deactivated.
 * 
 * @author Manuele Simi (ISTI CNR)
 *
 */
@JsonDeserialize(as=HasRemoveActionImpl.class)
public interface HasRemoveAction<Out extends Service, In extends ActionFacet> 
extends HasAction<Out, In> {
	
	public static final String NAME = "HasRemoveAction"; 

}
