/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import java.util.Date;

import org.gcube.com.fasterxml.jackson.annotation.JsonFormat;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.entities.facets.EventFacetImpl;

/**
 * EventFacet captures information on a certain event/happening characterising the life cycle of the resource.
 * 
 * Examples of an event are the start time of a virtual machine or the activation time of an electronic service.

 * https://wiki.gcube-system.org/gcube/GCube_Model#Event_Facet
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=EventFacetImpl.class)
@TypeMetadata(
	name = EventFacet.NAME, 
	description = "EventFacet captures information on a certain event/happening characterising the life cycle of the resource. "
			+ "Examples of an event are the start time of a virtual machine or the activation time of an electronic service.",
	version = Version.MINIMAL_VERSION_STRING
)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface EventFacet extends Facet {

	public static final String NAME = "EventFacet"; // EventFacet.class.getSimpleName();
	
	@JsonFormat(shape= JsonFormat.Shape.STRING, pattern = Element.DATETIME_PATTERN)
	@ISProperty(description = "The time the event took place/occurred", mandatory=true, nullable=false)
	public Date getDate();
	
	public void setDate(Date date);
	
	@ISProperty(description = "The typology of event", mandatory=true, nullable=false)
	public String getEvent();
	
	public void setEvent(String event);

}